/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.security.filter;

import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.security.authority.GlueServiceAuthorityManager;
import com.poscoict.glueframework.security.vo.GlueSecurityUser;
import com.poscoict.glueframework.util.log.GlueLog;
import com.poscoict.glueframework.util.log.GlueLogFactory;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContextHolder;

public class GlueServiceFilter
implements Filter {
    private static GlueLog logger = GlueLogFactory.getLogger(GlueServiceFilter.class);
    private String serviceAuthorityManagerId = "serviceAuthorityManager";

    public void setServiceAuthorityManagerId(String serviceAuthorityManagerId) {
        this.serviceAuthorityManagerId = serviceAuthorityManagerId;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String serviceName = request.getParameter("ServiceName");
        if (serviceName != null) {
            logger.info("try to check ServiceName : {}", (Object)serviceName);
            boolean isAuthService = this.isAuthGlueService(serviceName);
            if (!isAuthService) {
                logger.warn("Access(Glue) is denied! Check Role Resource. ServiceName is {}", (Object)serviceName);
                throw new AccessDeniedException("Access(Glue) is denied : ServiceName is " + serviceName);
            }
        }
        chain.doFilter(request, response);
    }

    private boolean isAuthGlueService(String checkService) {
        GlueServiceAuthorityManager serviceAuthorityManager = (GlueServiceAuthorityManager)GlueStaticContext.getBeanFactory().getBeanObject(this.serviceAuthorityManagerId);
        if (serviceAuthorityManager == null) {
            logger.debug("{} doesn't exist", (Object)this.serviceAuthorityManagerId);
            return false;
        }
        Set<String> allAuthService = serviceAuthorityManager.getAllAuthService();
        if (allAuthService == null) {
            logger.trace("{} doesn't have any service", (Object)this.serviceAuthorityManagerId);
            return true;
        }
        if (!allAuthService.contains(checkService)) {
            logger.debug("{} doesn't need to check ServiceName", (Object)checkService);
            return true;
        }
        try {
            GlueSecurityUser user = (GlueSecurityUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            Set<String> authService = user.getGlueService();
            logger.trace("checkService : {}, authService : {}, allAuthService : {}", new Object[]{checkService, authService, allAuthService});
            if (authService != null && authService.contains(checkService)) {
                return true;
            }
        }
        catch (ClassCastException exception) {
            logger.info("User doesn't exist");
        }
        return false;
    }

    public void destroy() {
    }
}

