/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.security.controller;

import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.security.authority.GlueServiceAuthorityManager;
import com.poscoict.glueframework.security.authority.GlueViewAuthorityManager;
import com.poscoict.glueframework.security.bean.GlueInvocationDefinitionSource;
import com.poscoict.glueframework.util.log.GlueLog;
import com.poscoict.glueframework.util.log.GlueLogFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class GlueSecurityResourceReload
implements Controller {
    private final GlueLog logger = GlueLogFactory.getLogger(this.getClass());
    private String requestName = "ReloadType";
    private String urlManagerId = "glueInvocationDefinitionSource";
    private String serviceManagerId = "serviceAuthorityManager";
    private String viewManagerId = "viewAuthorityManager";

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public void setUrlManagerId(String urlManagerId) {
        this.urlManagerId = urlManagerId;
    }

    public void setServiceManagerId(String serviceManagerId) {
        this.serviceManagerId = serviceManagerId;
    }

    public void setViewManagerId(String viewManagerId) {
        this.viewManagerId = viewManagerId;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reloadType = request.getParameter(this.requestName);
        ModelAndView mv = request.getParameter("callback") != null ? new ModelAndView("jsonpView") : new ModelAndView("jsonView");
        String result = "Success!";
        this.logger.debug("ReloadType : " + reloadType);
        try {
            if ("URL".equals(reloadType)) {
                this.logger.debug("URL Reload!!!!!!!");
                WebApplicationContext wContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getSession().getServletContext());
                GlueInvocationDefinitionSource metadataSource = (GlueInvocationDefinitionSource)wContext.getBean(this.urlManagerId);
                metadataSource.loadResourceMap();
            } else if ("SERVICE".equals(reloadType)) {
                this.logger.debug("SERVICE Reload!!!!!!!");
                GlueServiceAuthorityManager serviceManager = (GlueServiceAuthorityManager)GlueStaticContext.getBeanFactory().getBeanObject(this.serviceManagerId);
                serviceManager.loadResource();
            } else if ("VIEW".equals(reloadType)) {
                this.logger.debug("VIEW Reload!!!!!!!");
                GlueViewAuthorityManager viewManager = (GlueViewAuthorityManager)GlueStaticContext.getBeanFactory().getBeanObject(this.viewManagerId);
                viewManager.loadResource();
            } else {
                result = "Check type! ";
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            result = "Failure!";
        }
        mv.addObject("JsonResult", (Object)result);
        return mv;
    }
}

