/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.security.bean;

import com.poscoict.glueframework.biz.control.GlueBizProvider;
import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueDefaultContext;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.security.authority.GlueServiceAuthorityManager;
import com.poscoict.glueframework.security.authority.GlueViewAuthorityManager;
import com.poscoict.glueframework.security.util.GlueSecurityUtil;
import com.poscoict.glueframework.security.vo.GlueRole;
import com.poscoict.glueframework.security.vo.GlueSecurityUserImpl;
import com.poscoict.glueframework.security.vo.GlueUser;
import com.poscoict.glueframework.security.vo.GlueViewAuthority;
import com.poscoict.glueframework.util.log.GlueLog;
import com.poscoict.glueframework.util.log.GlueLogFactory;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class GlueUserDetailsService
implements UserDetailsService {
    private static GlueLog logger = GlueLogFactory.getLogger(GlueUserDetailsService.class);
    private boolean crc = false;
    private String userName = "user_id";
    private String crcName = "crc_id";
    private String serviceName = "security-service";
    private String serviceAuthorityManagerId = "serviceAuthorityManager";
    private String viewAuthorityManagerId = "viewAuthorityManager";

    public void setCrc(boolean crc) {
        this.crc = crc;
    }

    public void setServiceName(String glueService) {
        this.serviceName = glueService;
    }

    public void setServiceAuthorityManagerId(String serviceAuthorityManagerId) {
        this.serviceAuthorityManagerId = serviceAuthorityManagerId;
    }

    public void setViewAuthorityManagerId(String viewAuthorityManagerId) {
        this.viewAuthorityManagerId = viewAuthorityManagerId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setCrcName(String crcName) {
        this.crcName = crcName;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        logger.trace("try to load UserDetailsService : {}", (Object)username);
        HashSet<SimpleGrantedAuthority> authsSet = new HashSet<SimpleGrantedAuthority>();
        boolean accountNonExpired = true;
        boolean accountNonLocked = true;
        boolean credentialsNonExpired = true;
        Date today = new Date();
        GlueDefaultContext ctx = new GlueDefaultContext();
        ctx.put(this.userName, (Object)username);
        if (this.crc) {
            logger.debug("Crc is true!");
            ctx.put(this.crcName, (Object)GlueSecurityUtil.getCrcCode(username));
        }
        ctx.put("getUserInfo", (Object)1);
        ctx.put("ServiceName", (Object)this.serviceName);
        GlueBizProvider.getController().doAction((GlueContext)ctx);
        List users = (List)ctx.get((Object)"users");
        List roles = (List)ctx.get((Object)"roles");
        if (users == null || users.size() == 0) {
            throw new UsernameNotFoundException("User[" + username + "] not found");
        }
        List<GlueViewAuthority> viewAuthorities = null;
        GlueViewAuthorityManager viewAuthorityManager = (GlueViewAuthorityManager)GlueStaticContext.getBeanFactory().getBeanObject(this.viewAuthorityManagerId);
        if (viewAuthorityManager != null) {
            viewAuthorities = viewAuthorityManager.getViewAuthorities(roles);
        }
        GlueServiceAuthorityManager serviceAuthorityManager = (GlueServiceAuthorityManager)GlueStaticContext.getBeanFactory().getBeanObject(this.serviceAuthorityManagerId);
        Set<String> serviceAuthorities = null;
        if (serviceAuthorityManager != null) {
            serviceAuthorities = serviceAuthorityManager.getServiceAuthorities(roles);
        }
        for (GlueRole role : roles) {
            authsSet.add(new SimpleGrantedAuthority(role.getRoleId()));
        }
        GlueUser user = (GlueUser)users.get(0);
        Date endActiveDate = user.getEndActiveDate();
        Date startActiveDate = user.getStartActiveDate();
        if (endActiveDate != null && today.compareTo(endActiveDate) > 0) {
            accountNonExpired = false;
        } else if (startActiveDate != null && today.compareTo(startActiveDate) < 0) {
            accountNonExpired = false;
        }
        GlueSecurityUserImpl userDetail = new GlueSecurityUserImpl(username, user.getPassword(), user.isEnabled(), accountNonExpired, accountNonLocked, credentialsNonExpired, authsSet);
        userDetail.setGlueUser(user);
        userDetail.setViewAuthorities(viewAuthorities);
        userDetail.setGlueService(serviceAuthorities);
        return userDetail;
    }
}

