/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.security.bean;

import com.poscoict.glueframework.biz.control.GlueBizProvider;
import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueDefaultContext;
import com.poscoict.glueframework.security.vo.GlueResource;
import com.poscoict.glueframework.util.log.GlueLog;
import com.poscoict.glueframework.util.log.GlueLogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class GlueInvocationDefinitionSource
implements FilterInvocationSecurityMetadataSource,
InitializingBean {
    private static GlueLog logger = GlueLogFactory.getLogger(GlueInvocationDefinitionSource.class);
    private Map<RequestMatcher, Collection<ConfigAttribute>> resourceMap;
    private String glueService = "security-service";
    private String resultKey = "ResourcePattern";

    public void setGlueService(String glueService) {
        this.glueService = glueService;
    }

    public void setResultKey(String resultKey) {
        this.resultKey = resultKey;
    }

    public void loadResourceMap() {
        this.resourceMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
        List<GlueResource> resourceList = this.getUrlRepositories();
        for (GlueResource entry : resourceList) {
            List tmprole;
            AntPathRequestMatcher key = new AntPathRequestMatcher(entry.getResourcePattern());
            logger.trace("[{}-{}] {}", new Object[]{entry.getRoleId(), entry.getResourcePattern(), key});
            if (this.resourceMap.get(key) == null) {
                tmprole = SecurityConfig.createList((String[])new String[]{entry.getRoleId()});
                this.resourceMap.put((RequestMatcher)key, tmprole);
                continue;
            }
            tmprole = this.resourceMap.get(key);
            tmprole.add(new SecurityConfig(entry.getRoleId()));
        }
    }

    private List<GlueResource> getUrlRepositories() {
        GlueDefaultContext ctx = new GlueDefaultContext();
        ctx.put("ServiceName", (Object)this.glueService);
        GlueBizProvider.getController().doAction((GlueContext)ctx);
        List result = (List)ctx.get((Object)this.resultKey);
        return result;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> allAttributes = new HashSet<ConfigAttribute>();
        for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : this.resourceMap.entrySet()) {
            allAttributes.addAll(entry.getValue());
        }
        return allAttributes;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) {
        HttpServletRequest request = ((FilterInvocation)object).getRequest();
        for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : this.resourceMap.entrySet()) {
            if (!entry.getKey().matches(request)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public void afterPropertiesSet() throws Exception {
        this.loadResourceMap();
    }
}

