/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.security.authority;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.dao.jdbc.GlueJdbcDao;
import com.poscoict.glueframework.security.authority.GlueViewAuthorityManager;
import com.poscoict.glueframework.security.vo.GlueRole;
import com.poscoict.glueframework.security.vo.GlueViewAuthority;
import com.poscoict.glueframework.security.vo.GlueViewRoles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class GlueViewAuthorityDbManagerImpl
implements GlueViewAuthorityManager,
InitializingBean {
    private Map<String, List<GlueViewAuthority>> glueViewRoles = null;
    private String queryKey = "security.viewRoles.select";
    private GlueJdbcDao jdbcDao;

    public void setQueryKey(String queryKey) {
        this.queryKey = queryKey;
    }

    public void setJdbcDao(GlueJdbcDao jdbcDao) {
        this.jdbcDao = jdbcDao;
    }

    @Override
    public List<GlueViewAuthority> getViewAuthorities(List<GlueRole> roles) {
        if (this.glueViewRoles == null) {
            return null;
        }
        ArrayList<GlueViewAuthority> glueViewAuthorities = new ArrayList<GlueViewAuthority>();
        ArrayList<GlueViewAuthority> glueViewAuthoritiesUnique = null;
        for (GlueRole role : roles) {
            List<GlueViewAuthority> eletmp = this.glueViewRoles.get(role.getRoleId());
            if (eletmp == null || eletmp.size() <= 0) continue;
            glueViewAuthorities.addAll(eletmp);
        }
        if (glueViewAuthorities.size() > 0) {
            glueViewAuthoritiesUnique = new ArrayList<GlueViewAuthority>();
            for (GlueViewAuthority view : glueViewAuthorities) {
                boolean uniqueFlg = true;
                for (GlueViewAuthority viewSub : glueViewAuthoritiesUnique) {
                    if (!view.getViewId().equals(viewSub.getViewId())) continue;
                    uniqueFlg = false;
                    break;
                }
                if (!uniqueFlg) continue;
                glueViewAuthoritiesUnique.add(view);
            }
        }
        return glueViewAuthorities;
    }

    @Override
    public void loadResource() {
        List glueViewRoleList = this.jdbcDao.find(this.queryKey);
        if (glueViewRoleList.size() > 0) {
            this.glueViewRoles = new HashMap<String, List<GlueViewAuthority>>();
        }
        for (GlueViewRoles glueViewRole : glueViewRoleList) {
            List<GlueViewAuthority> tmpele = this.glueViewRoles.get(glueViewRole.getRoleId());
            if (tmpele == null) {
                tmpele = new ArrayList<GlueViewAuthority>();
            }
            tmpele.add(glueViewRole.getViewAuthority());
            this.glueViewRoles.put(glueViewRole.getRoleId(), tmpele);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jdbcDao == null) {
            throw new GlueException("jdbcDao doesn't exist");
        }
        this.loadResource();
    }
}

