/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.security.authority;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.dao.jdbc.GlueJdbcDao;
import com.poscoict.glueframework.security.authority.GlueServiceAuthorityManager;
import com.poscoict.glueframework.security.vo.GlueResource;
import com.poscoict.glueframework.security.vo.GlueRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;

public class GlueServiceAuthorityDbManagerImpl
implements GlueServiceAuthorityManager,
InitializingBean {
    private Map<String, List<String>> glueServiceRoles = null;
    private Set<String> glueService = null;
    private String queryKey = "security.serviceRoles.select";
    private GlueJdbcDao jdbcDao;

    public void setQueryKey(String queryKey) {
        this.queryKey = queryKey;
    }

    public void setJdbcDao(GlueJdbcDao jdbcDao) {
        this.jdbcDao = jdbcDao;
    }

    @Override
    public Set<String> getAllAuthService() {
        return this.glueService;
    }

    @Override
    public Set<String> getServiceAuthorities(List<GlueRole> roles) {
        if (this.glueServiceRoles == null) {
            return null;
        }
        HashSet<String> glueServiceAuthorities = new HashSet<String>();
        for (GlueRole role : roles) {
            List<String> eletmp = this.glueServiceRoles.get(role.getRoleId());
            if (eletmp == null || eletmp.size() <= 0) continue;
            glueServiceAuthorities.addAll(eletmp);
        }
        return glueServiceAuthorities;
    }

    @Override
    public void loadResource() {
        List resourceList = this.jdbcDao.find(this.queryKey);
        if (resourceList.size() > 0) {
            this.glueServiceRoles = new HashMap<String, List<String>>();
            this.glueService = new HashSet<String>();
        }
        for (GlueResource resource : resourceList) {
            List<String> tmpele = this.glueServiceRoles.get(resource.getRoleId());
            if (tmpele == null) {
                tmpele = new ArrayList<String>();
            }
            tmpele.add(resource.getResourcePattern());
            this.glueService.add(resource.getResourcePattern());
            this.glueServiceRoles.put(resource.getRoleId(), tmpele);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jdbcDao == null) {
            throw new GlueException("jdbcDao doesn't exist");
        }
        this.loadResource();
    }
}

