/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.job;

import com.poscoict.glueframework.biz.control.GlueBizProvider;
import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueDefaultContext;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;

public class GlueSimpleJob {
    static ApplicationContext applicationContext = null;
    static Logger logger = LoggerFactory.getLogger(GlueSimpleJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        String requestId;
        GlueDefaultContext ctx;
        long start;
        boolean isLocalTest;
        block49: {
            logger.info("GlueSimpleJob version : {}", (Object)"2.1.1");
            boolean bl = isLocalTest = args != null && args.length > 0 && args[0] != null && "-1".equals(args[0]);
            if (!isLocalTest) {
                Connection connection;
                BasicDataSource dataSource;
                block48: {
                    dataSource = null;
                    connection = null;
                    try {
                        applicationContext = new ClassPathXmlApplicationContext("applicationContext-job.xml");
                        dataSource = (BasicDataSource)applicationContext.getBean("dataSource", BasicDataSource.class);
                        connection = DataSourceUtils.getConnection((DataSource)dataSource);
                        String databaseProductName = connection.getMetaData().getDatabaseProductName().toLowerCase();
                        if (databaseProductName.contains("oracle")) {
                            dataSource.addConnectionProperty("v$session.program", "GlueSimpleJob ver.2.1.1");
                            break block48;
                        }
                        if (databaseProductName.contains("postgresql") || databaseProductName.contains("enterprisedb")) {
                            dataSource.addConnectionProperty("ApplicationName", "GlueSimpleJob ver.2.1.1");
                            break block48;
                        }
                        logger.warn("not support adding datasource connection property (application name) - {}", (Object)databaseProductName);
                    }
                    catch (Exception e) {
                        logger.error("Exception", (Throwable)e);
                        e.printStackTrace();
                        DataSourceUtils.releaseConnection(connection, (DataSource)dataSource);
                        return;
                    }
                    catch (Throwable t) {
                        logger.error("Throwable", t);
                        t.printStackTrace();
                        {
                            catch (Throwable throwable) {
                                DataSourceUtils.releaseConnection(connection, dataSource);
                                throw throwable;
                            }
                        }
                        DataSourceUtils.releaseConnection(connection, (DataSource)dataSource);
                        return;
                    }
                }
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
            }
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String pid = name.substring(0, name.indexOf("@"));
            logger.info("RuntimeMXBean Name : {}, {}", (Object)name, (Object)pid);
            if (logger.isTraceEnabled()) {
                logger.trace("BootClassPath : {}", (Object)ManagementFactory.getRuntimeMXBean().getBootClassPath());
                logger.trace("ClassPath : {}", (Object)ManagementFactory.getRuntimeMXBean().getClassPath());
                logger.trace("LibraryPath : {}", (Object)ManagementFactory.getRuntimeMXBean().getLibraryPath());
                logger.trace("ManagementSpecVersion : {}", (Object)ManagementFactory.getRuntimeMXBean().getManagementSpecVersion());
                logger.trace("SpecName : {}", (Object)ManagementFactory.getRuntimeMXBean().getSpecName());
                logger.trace("SpecVendor : {}", (Object)ManagementFactory.getRuntimeMXBean().getSpecVendor());
                logger.trace("SpecVersion : {}", (Object)ManagementFactory.getRuntimeMXBean().getSpecVersion());
                logger.trace("StartTime : {}", (Object)ManagementFactory.getRuntimeMXBean().getStartTime());
                logger.trace("Uptime : {}", (Object)ManagementFactory.getRuntimeMXBean().getUptime());
                logger.trace("VmName : {}", (Object)ManagementFactory.getRuntimeMXBean().getVmName());
                logger.trace("VmVendor : {}", (Object)ManagementFactory.getRuntimeMXBean().getVmVendor());
                logger.trace("VmVersion : {}", (Object)ManagementFactory.getRuntimeMXBean().getVmVersion());
                logger.trace("SystemProperties : {}", ManagementFactory.getRuntimeMXBean().getSystemProperties());
                logger.trace("BootClassPathSupported : {}", (Object)ManagementFactory.getRuntimeMXBean().isBootClassPathSupported());
                logger.trace("InputArguments : {}", ManagementFactory.getRuntimeMXBean().getInputArguments());
                List<String> arguements = ManagementFactory.getRuntimeMXBean().getInputArguments();
                for (String string : arguements) {
                    logger.trace("InputArgument : {}", (Object)string);
                }
            }
            if (!isLocalTest) {
                GlueSimpleJob.updateStartTime(args[0], pid);
            }
            start = System.currentTimeMillis();
            ctx = new GlueDefaultContext();
            requestId = null;
            try {
                requestId = args[0];
                if (logger.isTraceEnabled()) {
                    Map<String, String> env = System.getenv();
                    logger.trace("{}", env);
                    logger.trace("");
                    logger.trace("{}", (Object)System.getProperties());
                    logger.trace("");
                    logger.trace("");
                }
                logger.info("RequestID:[{}] StartTime[{}]", (Object)requestId, (Object)new Date(start));
                ctx.put("_Job_RequestID", (Object)requestId);
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    logger.trace("{}", (Object)arg);
                    if (arg.contains("=")) {
                        String[] s = arg.split("=");
                        if (arg.startsWith("\"") && arg.endsWith("\"")) {
                            String tmp = arg.substring(1, arg.length() - 1);
                            logger.trace("{}", (Object)tmp);
                            s = tmp.split("=");
                        }
                        if (s[1].contains("@")) {
                            int idx = s[1].lastIndexOf("@");
                            String value = s[1].substring(0, idx);
                            if (s[1].endsWith("S")) {
                                ctx.put(s[0], (Object)("NULL".equalsIgnoreCase(value) ? "" : value));
                                continue;
                            }
                            if (s[1].endsWith("B")) {
                                ctx.put(s[0], (Object)("NULL".equalsIgnoreCase(value) ? null : Boolean.valueOf(value)));
                                continue;
                            }
                            if (s[1].endsWith("I")) {
                                ctx.put(s[0], (Object)("NULL".equalsIgnoreCase(value) ? null : new Integer(value)));
                                continue;
                            }
                            if (s[1].endsWith("L")) {
                                ctx.put(s[0], (Object)("NULL".equalsIgnoreCase(value) ? null : new Long(value)));
                                continue;
                            }
                            if (s[1].endsWith("D")) {
                                ctx.put(s[0], (Object)("NULL".equalsIgnoreCase(value) ? null : new Double(value)));
                                continue;
                            }
                            if (!s[1].endsWith("F")) continue;
                            ctx.put(s[0], (Object)("NULL".equalsIgnoreCase(value) ? null : new Float(value)));
                            continue;
                        }
                        ctx.put(s[0], (Object)s[1]);
                        continue;
                    }
                    logger.error("ignore {}", (Object)arg);
                }
                logger.info("{}", (Object)ctx);
                if (ctx.containsKey((Object)"ServiceName")) {
                    try {
                        GlueBizProvider.getController().doAction((GlueContext)ctx);
                    }
                    catch (Throwable t) {
                        if (ctx.getException() != null) {
                            ctx.setException(t);
                        } else {
                            logger.error("unknwon error", t);
                        }
                        t.printStackTrace();
                    }
                    break block49;
                }
                if (ctx.containsKey((Object)"className")) {
                    try {
                        Object clz = Thread.currentThread().getContextClassLoader().loadClass((String)ctx.get((Object)"className")).newInstance();
                        Method method = clz.getClass().getMethod("runProgram", GlueContext.class);
                        method.invoke(clz, ctx);
                        if (ctx.getException() != null) {
                            logger.error("UserException", ctx.getException());
                            ctx.getException().printStackTrace();
                        }
                        break block49;
                    }
                    catch (InstantiationException e) {
                        ctx.setException((Throwable)e);
                        logger.error("InstantiationException", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        ctx.setException((Throwable)e);
                        logger.error("IllegalAccessException", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        ctx.setException((Throwable)e);
                        logger.error("ClassNotFoundException", (Throwable)e);
                    }
                    catch (SecurityException e) {
                        ctx.setException((Throwable)e);
                        logger.error("SecurityException", (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        ctx.setException((Throwable)e);
                        logger.error("NoSuchMethodException", (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        ctx.setException((Throwable)e);
                        logger.error("IllegalArgumentException", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        ctx.setException((Throwable)e);
                        logger.error("InvocationTargetException", (Throwable)e);
                    }
                    catch (Throwable t) {
                        ctx.setException(t);
                        logger.error("UserException", t);
                    }
                    break block49;
                }
                ctx.setException((Throwable)new Exception("Service is Null!"));
                logger.info("Service is Null!");
            }
            catch (Exception e) {
                logger.error("Exception", (Throwable)e);
                e.printStackTrace();
                long end = System.currentTimeMillis();
                if (!isLocalTest) {
                    GlueSimpleJob.updateEndTime(args[0], end - start, ctx.getException());
                }
                logger.info("RequestID:[{}] EndTime[{}] RunTime:[{}]", new Object[]{requestId, new Date(end), end - start});
            }
            catch (Throwable t) {
                logger.error("Throwable", t);
                t.printStackTrace();
                {
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        if (!isLocalTest) {
                            GlueSimpleJob.updateEndTime(args[0], end - start, ctx.getException());
                        }
                        logger.info("RequestID:[{}] EndTime[{}] RunTime:[{}]", new Object[]{requestId, new Date(end), end - start});
                        throw throwable;
                    }
                }
                long end = System.currentTimeMillis();
                if (!isLocalTest) {
                    GlueSimpleJob.updateEndTime(args[0], end - start, ctx.getException());
                }
                logger.info("RequestID:[{}] EndTime[{}] RunTime:[{}]", new Object[]{requestId, new Date(end), end - start});
            }
        }
        long end = System.currentTimeMillis();
        if (!isLocalTest) {
            GlueSimpleJob.updateEndTime(args[0], end - start, ctx.getException());
        }
        logger.info("RequestID:[{}] EndTime[{}] RunTime:[{}]", new Object[]{requestId, new Date(end), end - start});
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateEndTime(String id, long runtime, Throwable throwable) {
        try {
            if ("-1".equals(id)) {
                return;
            }
            DataSource ds = (DataSource)applicationContext.getBean("dataSource", DataSource.class);
            logger.debug("{}", (Object)"update SCHEDULE_JOB_HISTORY set PGM_END=CURRENT_TIMESTAMP, PGM_TIME=?, STATUS=?, PROCESS_ID=null where HISTORY_ID=?");
            logger.trace("{}", (Object)runtime);
            logger.trace("{}", (Object)(throwable == null ? "END" : "ERROR"));
            logger.trace("{}", (Object)id);
            Connection con = null;
            PreparedStatement ps = null;
            con = DataSourceUtils.getConnection((DataSource)ds);
            try {
                ps = con.prepareStatement("update SCHEDULE_JOB_HISTORY set PGM_END=CURRENT_TIMESTAMP, PGM_TIME=?, STATUS=?, PROCESS_ID=null where HISTORY_ID=?");
                ps.setObject(1, runtime);
                ps.setObject(2, throwable == null ? "END" : "ERROR");
                ps.setObject(3, new Long(id));
                ps.executeUpdate();
                con.commit();
            }
            catch (SQLException e) {
                logger.error("fail to executeUpdate", (Throwable)e);
            }
            finally {
                JdbcUtils.closeStatement((Statement)ps);
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        catch (Exception e) {
            logger.error("fail to getConnection", (Throwable)e);
        }
        catch (Throwable t) {
            logger.error("fail to getConnection", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateStartTime(String id, String pid) {
        try {
            if ("-1".equals(id)) {
                return;
            }
            DataSource ds = (DataSource)applicationContext.getBean("dataSource", DataSource.class);
            logger.debug("{}", (Object)"update SCHEDULE_JOB_HISTORY set PGM_START=CURRENT_TIMESTAMP, STATUS=?, PROCESS_ID=? where HISTORY_ID=?");
            logger.trace("{}", (Object)"RUNNING");
            logger.trace("{}", (Object)pid);
            logger.trace("{}", (Object)id);
            Connection con = null;
            PreparedStatement ps = null;
            con = DataSourceUtils.getConnection((DataSource)ds);
            try {
                ps = con.prepareStatement("update SCHEDULE_JOB_HISTORY set PGM_START=CURRENT_TIMESTAMP, STATUS=?, PROCESS_ID=? where HISTORY_ID=?");
                ps.setObject(1, "RUNNING");
                ps.setObject(2, new Integer(pid));
                ps.setObject(3, new Long(id));
                ps.executeUpdate();
                con.commit();
            }
            catch (SQLException e) {
                logger.error("fail to executeUpdate", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("fail to getConnection", (Throwable)e);
            }
            catch (Throwable t) {
                logger.error("fail to getConnection", t);
            }
            finally {
                JdbcUtils.closeStatement((Statement)ps);
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        catch (Exception e) {
            logger.error("fail to getConnection", (Throwable)e);
        }
        catch (Throwable t) {
            logger.error("fail to getConnection", t);
        }
    }
}

