/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.job;

import com.poscoict.glueframework.GlueException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlueJobStatusCheck {
    private static Logger logger = LoggerFactory.getLogger(GlueJobStatusCheck.class);

    public static String getJobStatus(String url, String requestId, String jobKey) {
        String ip = null;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            ip = localMachine.getHostAddress();
            return GlueJobStatusCheck.getJobStatus(url, requestId, jobKey, ip, 2);
        }
        catch (UnknownHostException e) {
            logger.error("UnknownHostException", (Throwable)e);
            return null;
        }
    }

    public static String getJobStatus(String url, String requestId, String jobKey, String ip) {
        return GlueJobStatusCheck.getJobStatus(url, requestId, jobKey, ip, 2);
    }

    public static String getJobStatus(String url, String requestId, String jobKey, String ip, int retryCount) {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        method.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add(new NameValuePair("check", "status"));
        nameValuePairs.add(new NameValuePair("request_id", requestId));
        nameValuePairs.add(new NameValuePair("jobKey", jobKey));
        nameValuePairs.add(new NameValuePair("client_ip", ip));
        NameValuePair[] nvps = new NameValuePair[nameValuePairs.size()];
        nvps = nameValuePairs.toArray(nvps);
        method.setRequestBody(nvps);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(retryCount, false));
        String responseBody = null;
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 700 && statusCode != 200) {
                logger.error("Method failed: {}", (Object)method.getStatusLine());
            }
            responseBody = new String(method.getResponseBody());
            logger.info("Response Body :{}", (Object)responseBody);
            logger.info("Status Line :{}", (Object)method.getStatusLine());
        }
        catch (HttpException httpe) {
            throw new GlueException("Fatal protocol violation: " + httpe.getMessage(), (Throwable)httpe);
        }
        catch (IOException ioe) {
            throw new GlueException("Fatal transport error: " + ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            method.releaseConnection();
        }
        return responseBody;
    }

    public static String getJobHistoryIdsByJobKey(String url, String jobKey) {
        String ip = null;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            ip = localMachine.getHostAddress();
            return GlueJobStatusCheck.getJobHistoryIdsByJobKey(url, jobKey, ip, 2);
        }
        catch (UnknownHostException e) {
            logger.error("UnknownHostException", (Throwable)e);
            return null;
        }
    }

    public static String getJobHistoryIdsByJobKey(String url, String jobKey, String ip) {
        return GlueJobStatusCheck.getJobHistoryIdsByJobKey(url, jobKey, ip, 2);
    }

    public static String getJobHistoryIdsByJobKey(String url, String jobKey, String ip, int retryCount) {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        method.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add(new NameValuePair("check", "status"));
        nameValuePairs.add(new NameValuePair("jobKey", jobKey));
        nameValuePairs.add(new NameValuePair("client_ip", ip));
        NameValuePair[] nvps = new NameValuePair[nameValuePairs.size()];
        nvps = nameValuePairs.toArray(nvps);
        method.setRequestBody(nvps);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(retryCount, false));
        String responseBody = null;
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 700 && statusCode != 200) {
                logger.error("Method failed: {}", (Object)method.getStatusLine());
            }
            responseBody = new String(method.getResponseBody());
            logger.info("Response Body :{}", (Object)responseBody);
            logger.info("Status Line :{}", (Object)method.getStatusLine());
        }
        catch (HttpException httpe) {
            throw new GlueException("Fatal protocol violation: " + httpe.getMessage(), (Throwable)httpe);
        }
        catch (IOException ioe) {
            throw new GlueException("Fatal transport error: " + ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            method.releaseConnection();
        }
        return responseBody;
    }
}

