/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.util.license;

import com.poscoict.app.glue.master.access.util.license.LicenseLogger;
import com.poscoict.glueframework.GlueInvalidLicenseException;
import com.poscoict.glueframework.util.log.GlueLog;
import com.poscoict.glueframework.util.log.GlueLogFactory;
import com.poscoict.license.ILicenseLogger;
import com.poscoict.license.LicenseAPI;

public final class LicenseManager {
    private static final GlueLog m_logger = GlueLogFactory.getLogger(LicenseManager.class);
    private static LicenseAPI licenseAPI = null;
    private static LicenseAPI.LicenseMode licenseMode = LicenseAPI.LicenseMode.EDUCATION;
    private static int runCount = 1;
    private static int licenseAvailableCount = 50;

    public static LicenseAPI.LicenseMode getLicenseMode() {
        return licenseMode;
    }

    public static LicenseAPI getLicenseAPI(String licenseXmlFilePath) throws Exception {
        if (licenseAPI == null) {
            LicenseAPI.initialize((ILicenseLogger)new LicenseLogger(), (String)licenseXmlFilePath, LicenseManager.class);
            licenseAPI = LicenseAPI.getInstance();
            licenseMode = licenseAPI.getLicenseMode(LicenseAPI.Solution.GlueMaster);
            m_logger.trace("{} -> {} : {}", new Object[]{licenseXmlFilePath, licenseMode, LicenseManager.checkLicense()});
        }
        return licenseAPI;
    }

    public static void invalidateLicenseAPI() {
        licenseAPI = null;
        licenseMode = LicenseAPI.LicenseMode.EDUCATION;
    }

    public static int checkLicenseMode() {
        switch (licenseMode) {
            case EDUCATION: {
                m_logger.warn("running in EDUCATION MODE : {}", (Object)runCount);
                if (runCount > licenseAvailableCount) {
                    for (int i = 0; i < 10; ++i) {
                        m_logger.error("it exceeds run limit in EDUCATION mode!!");
                        System.out.println("it exceeds run limit in EDUCATION mode!!");
                    }
                    throw new GlueInvalidLicenseException("it exceeds run limit!!");
                }
                ++runCount;
                break;
            }
            case DEVELOPMENT: 
            case PRODUCT: {
                if (!LicenseManager.checkLicense()) {
                    m_logger.error("Please check license file!! : GlueMaster Access is delayed by 10 seconds!!");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    runCount = 0;
                    break;
                }
                runCount = 1;
            }
        }
        return runCount - 1;
    }

    private static boolean checkLicense() {
        try {
            if (licenseAPI != null) {
                return licenseAPI.checkLicense(LicenseAPI.Solution.GlueMaster);
            }
        }
        catch (Exception e) {
            m_logger.error("Check license fail!!!", (Throwable)e);
        }
        return false;
    }
}

