/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.util;

import com.poscoict.app.glue.master.access.common.PosMasterAccessConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.math.NumberUtils;

public class PosMasterUtil {
    public static List<String> tokenize(String formula, String delim) {
        if (delim == null) {
            delim = "()+-*/><=!, ";
        }
        ArrayList<String> tokenList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(formula, delim, true);
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken().trim();
            tokenList.add(token.length() > 0 ? token : " ");
        }
        return tokenList;
    }

    public static String makeWhereClause(List<String> tokenList, Map<String, String> inputMap) {
        StringBuffer where = new StringBuffer();
        for (String token : tokenList) {
            if (token.startsWith("C") || token.startsWith("V")) {
                if (inputMap.containsKey(token)) {
                    where.append("?");
                    continue;
                }
                where.append(token);
                continue;
            }
            where.append(token);
        }
        return where.toString();
    }

    public static List<String> makeWhereClauseParameter(List<String> tokenList, Map<String, String> inputMap) {
        ArrayList<String> paramList = new ArrayList<String>();
        for (String token : tokenList) {
            if (!token.startsWith("C") && !token.startsWith("V") || !inputMap.containsKey(token)) continue;
            paramList.add(inputMap.get(token));
        }
        return paramList;
    }

    public static boolean isNumeric(String ... inputValues) {
        boolean isNumber = false;
        for (String inputValue : inputValues) {
            if (inputValue != null && !(isNumber = NumberUtils.isNumber((String)inputValue))) break;
        }
        return isNumber;
    }

    public static boolean checkLogic(String source, String target, String operator) {
        boolean isTrue = true;
        boolean isNumber = PosMasterUtil.isNumeric(source, target);
        double dblSource = 0.0;
        double dblTarget = 0.0;
        if (isNumber) {
            dblSource = !source.equals("") ? Double.parseDouble(source) : 0.0;
            dblTarget = !target.equals("") ? Double.parseDouble(target) : 0.0;
        }
        switch (PosMasterAccessConstants.OPERATOR1.valueOf(operator)) {
            case LE: {
                if (isNumber) {
                    if (!(dblSource > dblTarget)) break;
                    isTrue = false;
                    break;
                }
                if (!source.isEmpty() && source.compareTo(target) <= 0) break;
                isTrue = false;
                break;
            }
            case LT: {
                if (isNumber) {
                    if (!(dblSource >= dblTarget)) break;
                    isTrue = false;
                    break;
                }
                if (!source.isEmpty() && source.compareTo(target) < 0) break;
                isTrue = false;
                break;
            }
            case GE: {
                if (isNumber) {
                    if (!(dblSource < dblTarget)) break;
                    isTrue = false;
                    break;
                }
                if (!source.isEmpty() && source.compareTo(target) >= 0) break;
                isTrue = false;
                break;
            }
            case GT: {
                if (isNumber) {
                    if (!(dblSource <= dblTarget)) break;
                    isTrue = false;
                    break;
                }
                if (!source.isEmpty() && source.compareTo(target) > 0) break;
                isTrue = false;
            }
        }
        return isTrue;
    }

    public static boolean checkLogic(String value, String compare1, String compare2, String operator) {
        boolean isTrue = true;
        boolean isNumber = false;
        double dblValue = 0.0;
        double dblComp1 = 0.0;
        double dblComp2 = 0.0;
        PosMasterAccessConstants.OPERATOR2 tempOper = PosMasterAccessConstants.OPERATOR2.valueOf(operator);
        if (tempOper == PosMasterAccessConstants.OPERATOR2.AB || tempOper == PosMasterAccessConstants.OPERATOR2.RB || tempOper == PosMasterAccessConstants.OPERATOR2.LB || tempOper == PosMasterAccessConstants.OPERATOR2.NB) {
            isNumber = PosMasterUtil.isNumeric(value, compare1, compare2);
            if (isNumber) {
                dblValue = !value.equals("") ? Double.parseDouble(value) : 0.0;
                dblComp1 = !compare1.equals("") ? Double.parseDouble(compare1) : 0.0;
                dblComp2 = !compare2.equals("") ? Double.parseDouble(compare2) : 0.0;
            }
        } else if ((tempOper == PosMasterAccessConstants.OPERATOR2.EQ || tempOper == PosMasterAccessConstants.OPERATOR2.NE || tempOper == PosMasterAccessConstants.OPERATOR2.LT || tempOper == PosMasterAccessConstants.OPERATOR2.LE || tempOper == PosMasterAccessConstants.OPERATOR2.GE || tempOper == PosMasterAccessConstants.OPERATOR2.GT) && (isNumber = PosMasterUtil.isNumeric(value, compare1))) {
            dblValue = !value.equals("") ? Double.parseDouble(value) : 0.0;
            dblComp1 = !compare1.equals("") ? Double.parseDouble(compare1) : 0.0;
        }
        switch (tempOper) {
            case DE: {
                break;
            }
            case AB: {
                if (isNumber) {
                    if (!(dblComp1 > dblValue) && !(dblValue > dblComp2)) break;
                    isTrue = false;
                    break;
                }
                if (!value.isEmpty() && compare1.compareTo(value) <= 0 && value.compareTo(compare2) <= 0) break;
                isTrue = false;
                break;
            }
            case RB: {
                if (isNumber) {
                    if (!(dblComp1 >= dblValue) && !(dblValue > dblComp2)) break;
                    isTrue = false;
                    break;
                }
                if (!value.isEmpty() && compare1.compareTo(value) < 0 && value.compareTo(compare2) <= 0) break;
                isTrue = false;
                break;
            }
            case LB: {
                if (isNumber) {
                    if (!(dblComp1 > dblValue) && !(dblValue >= dblComp2)) break;
                    isTrue = false;
                    break;
                }
                if (!value.isEmpty() && compare1.compareTo(value) <= 0 && value.compareTo(compare2) < 0) break;
                isTrue = false;
                break;
            }
            case NB: {
                if (isNumber) {
                    if (!(dblComp1 >= dblValue) && !(dblValue >= dblComp2)) break;
                    isTrue = false;
                    break;
                }
                if (!value.isEmpty() && compare1.compareTo(value) < 0 && value.compareTo(compare2) < 0) break;
                isTrue = false;
                break;
            }
            case EQ: {
                if (isNumber) {
                    if (dblValue == dblComp1) break;
                    isTrue = false;
                    break;
                }
                if (value.equals(compare1)) break;
                isTrue = false;
                break;
            }
            case NE: {
                if (isNumber) {
                    if (dblValue != dblComp1) break;
                    isTrue = false;
                    break;
                }
                if (!value.equals(compare1)) break;
                isTrue = false;
                break;
            }
            case LE: {
                if (isNumber) {
                    if (!(dblValue > dblComp1)) break;
                    isTrue = false;
                    break;
                }
                if (!value.isEmpty() && value.compareTo(compare1) <= 0) break;
                isTrue = false;
                break;
            }
            case LT: {
                if (isNumber) {
                    if (!(dblValue >= dblComp1)) break;
                    isTrue = false;
                    break;
                }
                if (!value.isEmpty() && value.compareTo(compare1) < 0) break;
                isTrue = false;
                break;
            }
            case GE: {
                if (isNumber) {
                    if (!(dblValue < dblComp1)) break;
                    isTrue = false;
                    break;
                }
                if (!value.isEmpty() && value.compareTo(compare1) >= 0) break;
                isTrue = false;
                break;
            }
            case GT: {
                if (isNumber) {
                    if (!(dblValue <= dblComp1)) break;
                    isTrue = false;
                    break;
                }
                if (!value.isEmpty() && value.compareTo(compare1) > 0) break;
                isTrue = false;
                break;
            }
            case NN: {
                if (value != null && value.length() != 0) break;
                isTrue = false;
                break;
            }
            case NU: {
                if (value == null || value.length() <= 0) break;
                isTrue = false;
                break;
            }
            case IN: {
                if (compare1 == null) {
                    compare1 = "";
                }
                if (Arrays.asList(compare1.split(",")).contains(value)) break;
                isTrue = false;
                break;
            }
            case NI: {
                if (compare1 == null) {
                    compare1 = "";
                }
                if (!Arrays.asList(compare1.split(",")).contains(value)) break;
                isTrue = false;
                break;
            }
            case AL: {
                if (compare1 == null) {
                    compare1 = "";
                }
                if (value.indexOf(compare1) >= 0) break;
                isTrue = false;
                break;
            }
            case RL: {
                if (compare1 == null) {
                    compare1 = "";
                }
                isTrue = value.endsWith(compare1);
                break;
            }
            case LL: {
                if (compare1 == null) {
                    compare1 = "";
                }
                isTrue = value.startsWith(compare1);
            }
        }
        return isTrue;
    }
}

