/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.type;

import com.poscoict.app.glue.master.access.exception.PosMasterDataException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PosRuleValueInfo
extends ArrayList<LinkedHashMap<String, String>> {
    private static final long serialVersionUID = 866898289494226942L;
    private String m_headerInfo;
    private final List<String> m_itemIDList;

    public PosRuleValueInfo(List<String> itemIDList) {
        this.m_itemIDList = itemIDList;
    }

    public String getHeaderInfo() {
        return this.m_headerInfo;
    }

    public void setHeaderInfo(String headerInfo) {
        this.m_headerInfo = headerInfo;
    }

    public List<String> getItemIDList() {
        return this.m_itemIDList;
    }

    public List<LinkedHashMap<String, String>> getRuleResultAll() {
        return this;
    }

    public void addRuleResult(List<String> ruleValueList) {
        LinkedHashMap<String, String> ruleValueMap;
        if (this.m_itemIDList.size() == ruleValueList.size()) {
            ruleValueMap = new LinkedHashMap<String, String>(this.m_itemIDList.size());
            for (int i = 0; i < this.m_itemIDList.size(); ++i) {
                ruleValueMap.put(this.m_itemIDList.get(i), ruleValueList.get(i));
            }
        } else {
            throw new PosMasterDataException("Does not match size!! ItemID[" + this.m_itemIDList.size() + "] != Result[" + ruleValueList.size() + "]");
        }
        this.add(ruleValueMap);
    }

    public String[] getRuleResult(int index) {
        if (index < this.size() && index >= 0) {
            return this.getRuleResultMap(index).values().toArray(new String[0]);
        }
        throw new PosMasterDataException("Index[" + index + "] must be less than Size[" + this.size() + "]");
    }

    public Map<String, String> getRuleResultMap(int index) {
        if (index < this.size() && index >= 0) {
            return (Map)this.get(index);
        }
        throw new PosMasterDataException("Index[" + index + "] must be less than Size[" + this.size() + "]");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("=== Header Information ===").append("\n");
        sb.append(this.m_headerInfo).append("\n");
        sb.append("=== Business Rule Information ===").append("\n");
        for (Map resultMap : this) {
            sb.append(resultMap).append("\n");
        }
        return sb.toString();
    }
}

