/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.rmi.vo;

import com.poscoict.glueframework.dao.GlueGenericDao;
import com.poscoict.glueframework.dao.jdbc.GlueJdbcDao;
import com.poscoict.glueframework.dao.vo.GlueParameter;
import com.poscoict.glueframework.util.log.GlueLog;
import com.poscoict.glueframework.util.log.GlueLogFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MigrationVO
implements Serializable {
    private static final long serialVersionUID = 1645639656818569879L;
    private static GlueLog logger = GlueLogFactory.getLogger(MigrationVO.class);
    String masterType;
    String masterId;
    String masterVersion;
    List<String> tableName = new ArrayList<String>();
    Map<String, List<Map<String, Object>>> tableData = new HashMap<String, List<Map<String, Object>>>();
    String prefixForExportQueryId = "EXPORT_NAMED_";
    String prefixForImportSelectId = "IMPORT_NAMED_SELECT_";
    String prefixForImportUpdateId = "IMPORT_NAMED_UPDATE_";
    String prefixForImportInsertId = "IMPORT_NAMED_INSERT_";
    String prefixForImportDeleteId = "IMPORT_NAMED_DELETE_";

    public void setMasterId(String masterId) {
        this.masterId = masterId;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterType(String masterType) {
        this.masterType = masterType;
    }

    public String getMasterType() {
        return this.masterType;
    }

    public void setMasterVersion(String masterVersion) {
        this.masterVersion = masterVersion;
    }

    public String getMasterVersion() {
        return this.masterVersion;
    }

    public void setPrefixForExportQueryId(String prefixForExportQueryId) {
        this.prefixForExportQueryId = prefixForExportQueryId;
    }

    public void setPrefixForImportSelectId(String prefixForImportSelectId) {
        this.prefixForImportSelectId = prefixForImportSelectId;
    }

    public void setPrefixForImportUpdateId(String prefixForImportUpdateId) {
        this.prefixForImportUpdateId = prefixForImportUpdateId;
    }

    public void setPrefixForImportInsertId(String prefixForImportInsertId) {
        this.prefixForImportInsertId = prefixForImportInsertId;
    }

    public void setPrefixForImportDeleteId(String prefixForImportDeleteId) {
        this.prefixForImportDeleteId = prefixForImportDeleteId;
    }

    public void readData(GlueGenericDao dao, String[] queryIds, Map<String, String> paramMap) {
        for (int i = 0; i < queryIds.length; ++i) {
            this.tableName.add(queryIds[i]);
            this.tableData.put(queryIds[i], dao.find(this.prefixForExportQueryId + queryIds[i], new GlueParameter(paramMap)));
        }
    }

    public String writeData(GlueJdbcDao dao) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.tableName.size(); ++i) {
            sb.append(this.saveTableData(dao, this.tableName.get(i), this.tableData.get(this.tableName.get(i))));
        }
        return sb.toString();
    }

    protected String saveTableData(GlueJdbcDao dao, String tableName, List<Map<String, Object>> tableData) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tableData.size(); ++i) {
            Map<String, Object> row = tableData.get(i);
            if (this.isExist(dao, this.prefixForImportSelectId + tableName, row)) {
                sb.append(this.updateRow(dao, this.prefixForImportUpdateId + tableName, row));
            } else {
                sb.append(this.insertRow(dao, this.prefixForImportInsertId + tableName, row));
            }
            sb.append("<br>");
        }
        return sb.toString();
    }

    protected abstract boolean isExist(GlueJdbcDao var1, String var2, Map<String, Object> var3);

    protected abstract int updateRow(GlueJdbcDao var1, String var2, Map<String, Object> var3);

    protected abstract int insertRow(GlueJdbcDao var1, String var2, Map<String, Object> var3);

    protected GlueParameter<Map<String, Object>> getParameter(GlueJdbcDao dao, String queryId, Map<String, Object> row) {
        GlueParameter param = new GlueParameter();
        param.setParameter(row);
        return param;
    }

    protected void printRow(Map<String, Object> row) {
        logger.info("---------------- Row Info ----------------");
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            logger.info(entry.getKey() + " : " + entry.getValue());
        }
    }
}

