/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.rmi.impl;

import com.poscoict.app.glue.master.access.common.PosMasterAccessConstants;
import com.poscoict.app.glue.master.access.entity.PosMasterCommonInfo;
import com.poscoict.app.glue.master.access.rmi.JCSAdminService;
import com.poscoict.app.glue.master.access.rmi.vo.MigrationVO;
import com.poscoict.glueframework.biz.control.GlueBizController;
import com.poscoict.glueframework.biz.control.GlueBizProvider;
import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueWebContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jcs.access.CacheAccess;
import org.apache.jcs.admin.CacheElementInfo;
import org.apache.jcs.admin.CacheRegionInfo;
import org.apache.jcs.admin.JCSAdminBean;

public class JCSAdminServiceImpl
implements JCSAdminService {
    private static JCSAdminBean m_admin = new JCSAdminBean();
    private final List<String> m_regionList = new ArrayList<String>(4);

    public JCSAdminServiceImpl() {
        for (PosMasterAccessConstants.MasterRegions region : PosMasterAccessConstants.MasterRegions.values()) {
            this.m_regionList.add(region.getRegionName());
        }
    }

    @Override
    public Map<String, String> getRegionInfo() throws Exception {
        HashMap<String, String> regionMap = new HashMap<String, String>();
        for (Object info : m_admin.buildCacheInfo()) {
            CacheRegionInfo regionInfo = (CacheRegionInfo)info;
            String cacheName = regionInfo.getCache().getCacheName();
            if (!this.m_regionList.contains(cacheName)) continue;
            PosMasterAccessConstants.MasterRegions regions = PosMasterAccessConstants.MasterRegions.getRegion(cacheName);
            regionMap.put(regions.getMasterType().toString(), regions.getRegionName());
        }
        return regionMap;
    }

    @Override
    public List<Map<String, String>> getMasterHeaderInfo(String regionName) throws Exception {
        ArrayList<Map<String, String>> infoList = new ArrayList<Map<String, String>>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (Object info : m_admin.buildElementInfo(regionName)) {
            CacheElementInfo elementInfo = (CacheElementInfo)info;
            keyList.add(elementInfo.getKey());
        }
        CacheAccess cacheAccess = CacheAccess.defineRegion((String)regionName);
        for (String key : keyList) {
            Object info = cacheAccess.get((Object)key);
            if (!(info instanceof PosMasterCommonInfo)) continue;
            infoList.add(((PosMasterCommonInfo)info).getMasterHeaderInfo());
        }
        return infoList;
    }

    @Override
    public void clearAll() throws Exception {
        m_admin.clearAllRegions();
    }

    @Override
    public void clearRegion(String regionName) throws Exception {
        m_admin.clearRegion(regionName);
    }

    @Override
    public void removeMasterInfo(String regionName, String cmID, String cmVer) throws Exception {
        m_admin.removeItem(regionName, cmID + "/" + cmVer);
    }

    @Override
    public void removeMasterInfo(Map<String, List<String[]>> infoMap) throws Exception {
        for (Map.Entry<String, List<String[]>> infoEntry : infoMap.entrySet()) {
            String regionName = infoEntry.getKey();
            for (String[] info : infoEntry.getValue()) {
                if (info.length != 2) continue;
                this.removeMasterInfo(regionName, info[0], info[1]);
            }
        }
    }

    @Override
    public boolean checkLive() {
        return true;
    }

    @Override
    public String sendMasterdata(String serviceName, String transitionName, List<MigrationVO> masterdata) throws Exception {
        boolean isSuccess = true;
        String message = null;
        GlueWebContext ctx = new GlueWebContext();
        try {
            ctx.put("ServiceName", (Object)serviceName);
            ctx.put(transitionName, (Object)"1");
            ctx.put("SYNC_CACHE", (Object)"Y");
            ctx.put("masterdataList", masterdata);
            GlueBizController bizIF = GlueBizProvider.getController();
            bizIF.doAction((GlueContext)ctx);
            int status = Integer.parseInt((String)ctx.get((Object)"HttpServletResponseCode"));
            if (status != 200) {
                isSuccess = false;
                message = "Migration \uc2e4\ud328";
            } else {
                message = (String)ctx.get((Object)"message");
            }
        }
        catch (Exception e) {
            isSuccess = false;
            message = ctx.get((Object)"message") == null ? "Migration \uc2e4\ud328 : " + e.getMessage() : (String)ctx.get((Object)"message");
        }
        return message;
    }
}

