/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.manager.impl;

import com.poscoict.app.glue.master.access.common.PosMasterAccessConstants;
import com.poscoict.app.glue.master.access.entity.PosBusinessRuleInfo;
import com.poscoict.app.glue.master.access.entity.PosCalculationRuleInfo;
import com.poscoict.app.glue.master.access.entity.PosInterfaceFormatInfo;
import com.poscoict.app.glue.master.access.entity.PosMasterCodeInfo;
import com.poscoict.app.glue.master.access.entity.PosMasterCommonInfo;
import com.poscoict.app.glue.master.access.exception.PosMasterDataException;
import com.poscoict.app.glue.master.access.manager.PosMasterDataManager;
import com.poscoict.glueframework.cache.GlueCacheLoader;
import com.poscoict.glueframework.cache.GlueCacheManager;
import com.poscoict.glueframework.dao.jdbc.GlueGenericJdbcDao;
import com.poscoict.glueframework.dao.vo.GlueParameter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PosMasterDataManagerImpl
implements PosMasterDataManager {
    private GlueCacheManager m_cacheManager;
    private GlueGenericJdbcDao m_dao;
    private GlueCacheLoader m_codeLoader;
    private GlueCacheLoader m_ruleLoader;
    private GlueCacheLoader m_calcLoader;
    private GlueCacheLoader m_infLoader;
    private static final String CM_VER = "CM_VER";
    private static final String IF_ID = "IF_ID";
    private static final String IF_VER = "IF_VER";

    public void setCacheManager(GlueCacheManager cacheManager) {
        this.m_cacheManager = cacheManager;
    }

    public void setDao(GlueGenericJdbcDao dao) {
        this.m_dao = dao;
    }

    public void setMasterCodeLoader(GlueCacheLoader loader) {
        this.m_codeLoader = loader;
    }

    public void setBusinessRuleLoader(GlueCacheLoader loader) {
        this.m_ruleLoader = loader;
    }

    public void setCalculationLoader(GlueCacheLoader loader) {
        this.m_calcLoader = loader;
    }

    public void setInterfaceLoader(GlueCacheLoader loader) {
        this.m_infLoader = loader;
    }

    @Override
    public PosMasterCodeInfo getMasterCodeInfo(String codeID, String codeVer) {
        String cacheKey = this.createCacheKey(codeID, codeVer, PosMasterAccessConstants.MasterTypes.MC);
        PosMasterCommonInfo info = (PosMasterCommonInfo)this.m_cacheManager.getCacheObject((Object)cacheKey, PosMasterAccessConstants.MasterRegions.getRegion(PosMasterAccessConstants.MasterTypes.MC).getRegionName(), this.m_codeLoader);
        return (PosMasterCodeInfo)this.checkValidActiveDate(cacheKey, info);
    }

    @Override
    public PosBusinessRuleInfo getBizRuleInfo(String ruleID, String ruleVer) {
        String cacheKey = this.createCacheKey(ruleID, ruleVer, PosMasterAccessConstants.MasterTypes.BR);
        PosMasterCommonInfo info = (PosMasterCommonInfo)this.m_cacheManager.getCacheObject((Object)cacheKey, PosMasterAccessConstants.MasterRegions.getRegion(PosMasterAccessConstants.MasterTypes.BR).getRegionName(), this.m_ruleLoader);
        return (PosBusinessRuleInfo)this.checkValidActiveDate(cacheKey, info);
    }

    @Override
    public PosCalculationRuleInfo getCalcRuleInfo(String calcID, String calcVer) {
        String cacheKey = this.createCacheKey(calcID, calcVer, PosMasterAccessConstants.MasterTypes.CR);
        PosMasterCommonInfo info = (PosMasterCommonInfo)this.m_cacheManager.getCacheObject((Object)cacheKey, PosMasterAccessConstants.MasterRegions.getRegion(PosMasterAccessConstants.MasterTypes.CR).getRegionName(), this.m_calcLoader);
        return (PosCalculationRuleInfo)this.checkValidActiveDate(cacheKey, info);
    }

    @Override
    public PosInterfaceFormatInfo getInfFormatInfo(String tcID) {
        ArrayList<String> paramList = new ArrayList<String>(1);
        paramList.add(tcID);
        GlueParameter param = new GlueParameter();
        param.setParameter(paramList);
        List resultList = this.m_dao.find("ACCESS_SELECT_INTERFACE_TC", param);
        if (resultList.size() > 0) {
            Map tcMap = (Map)resultList.get(0);
            String formatID = tcMap.get(IF_ID).toString();
            String formatVer = tcMap.get(IF_VER).toString();
            String cacheKey = this.createCacheKey(formatID, formatVer, PosMasterAccessConstants.MasterTypes.IF);
            PosMasterCommonInfo info = (PosMasterCommonInfo)this.m_cacheManager.getCacheObject((Object)cacheKey, PosMasterAccessConstants.MasterRegions.getRegion(PosMasterAccessConstants.MasterTypes.IF).getRegionName(), this.m_infLoader);
            PosInterfaceFormatInfo formatInfo = (PosInterfaceFormatInfo)this.checkValidActiveDate(cacheKey, info);
            formatInfo.setInterfaceTcId(tcID);
            return formatInfo;
        }
        throw new PosMasterDataException(PosMasterAccessConstants.MasterTypes.IF.getDesc() + " does not found!!! : TC_ID[" + tcID + "]");
    }

    private String createCacheKey(String masterID, String masterVer, PosMasterAccessConstants.MasterTypes masterType) {
        if (masterVer == null) {
            ArrayList<Object> paramList = new ArrayList<Object>(1);
            paramList.add(masterID);
            paramList.add(masterType.toString());
            paramList.add(new Date());
            GlueParameter param = new GlueParameter();
            param.setParameter(paramList);
            List resultList = this.m_dao.find("ACCESS_SELECT_MASTER_COMMON_MAX_VERSION", param);
            if (resultList.size() > 0) {
                Object cmVer = ((Map)resultList.get(0)).get(CM_VER);
                if (cmVer == null) {
                    throw new PosMasterDataException(masterType.getDesc() + " does not found!!! : ID[" + masterID + "]");
                }
                masterVer = cmVer.toString();
            }
        }
        return masterID + "/" + masterVer;
    }

    private PosMasterCommonInfo checkValidActiveDate(String cacheKey, PosMasterCommonInfo masterInfo) {
        Date endActiveDate = masterInfo.getEndActiveDate();
        if (!this.isValidDate(endActiveDate)) {
            String regionName = "";
            switch (PosMasterAccessConstants.MasterTypes.valueOf(masterInfo.getMasterType())) {
                case MC: {
                    regionName = PosMasterAccessConstants.MasterRegions.getRegion(PosMasterAccessConstants.MasterTypes.MC).getRegionName();
                    break;
                }
                case BR: {
                    regionName = PosMasterAccessConstants.MasterRegions.getRegion(PosMasterAccessConstants.MasterTypes.BR).getRegionName();
                    break;
                }
                case CR: {
                    regionName = PosMasterAccessConstants.MasterRegions.getRegion(PosMasterAccessConstants.MasterTypes.CR).getRegionName();
                    break;
                }
                case IF: {
                    regionName = PosMasterAccessConstants.MasterRegions.getRegion(PosMasterAccessConstants.MasterTypes.IF).getRegionName();
                }
            }
            this.m_cacheManager.removeCacheObject((Object)cacheKey, regionName);
            masterInfo = (PosMasterCommonInfo)this.m_cacheManager.getCacheObject((Object)cacheKey, regionName, this.m_codeLoader);
        }
        return masterInfo;
    }

    private boolean isValidDate(Date date) {
        return new Date().compareTo(date) < 0;
    }
}

