/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.manager.impl;

import com.poscoict.app.glue.master.access.PosMasterDataFactory;
import com.poscoict.app.glue.master.access.exception.PosMasterDataException;
import com.poscoict.app.glue.master.access.manager.PosMasterCodeManager;
import com.poscoict.app.glue.master.access.type.PosCodeValueInfo;
import com.poscoict.app.glue.master.access.type.PosCodeValueList;
import java.util.Collections;
import java.util.Comparator;

public class PosMasterCodeManagerImpl
implements PosMasterCodeManager {
    @Override
    public boolean checkCodeValue(String codeID, String codeVer, String category, String codeValue) throws PosMasterDataException {
        PosCodeValueInfo valueInfo = this.getCodeValueInfo(codeID, codeVer, category, codeValue);
        return valueInfo != null;
    }

    @Override
    public boolean isValidRangeValue(String codeID, String codeVer, String category, String codeValue, int rangeValue) throws PosMasterDataException {
        boolean isValid = false;
        PosCodeValueInfo valueInfo = this.getCodeValueInfo(codeID, codeVer, category, codeValue);
        if (valueInfo != null) {
            String maxValue = valueInfo.getMaxValue();
            String minValue = valueInfo.getMinValue();
            if (maxValue != null && minValue != null) {
                int iMaxValue = Integer.parseInt(maxValue);
                int iMinValue = Integer.parseInt(minValue);
                if (rangeValue >= iMinValue && rangeValue <= iMaxValue) {
                    isValid = true;
                }
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    @Override
    public PosCodeValueInfo getCodeValueInfo(String codeID, String codeVer, String category, String codeValue) throws PosMasterDataException {
        return this.getCodeList(codeID, codeVer, category).getCodeValueInfo(codeValue);
    }

    @Override
    public PosCodeValueList getCodeList(String codeID, String codeVer, String category) throws PosMasterDataException {
        return PosMasterDataFactory.getManager().getMasterCodeInfo(codeID, codeVer).getCodeList(category);
    }

    @Override
    public PosCodeValueList getCodeListOrderByValue(String codeID, String codeVer, String category, boolean isAsc) throws PosMasterDataException {
        PosCodeValueList codeList = this.getCodeList(codeID, codeVer, category);
        Collections.sort(codeList, new ValueCompare());
        if (!isAsc) {
            Collections.reverse(codeList);
        }
        return codeList;
    }

    @Override
    public PosCodeValueList getCodeListOrderByMean(String codeID, String codeVer, String category, boolean isAsc) throws PosMasterDataException {
        PosCodeValueList codeList = this.getCodeList(codeID, codeVer, category);
        Collections.sort(codeList, new MeanCompare());
        if (!isAsc) {
            Collections.reverse(codeList);
        }
        return codeList;
    }

    @Override
    public PosCodeValueList getCodeListOrderBySequence(String codeID, String codeVer, String category) throws PosMasterDataException {
        PosCodeValueList codeList = this.getCodeList(codeID, codeVer, category);
        Collections.sort(codeList, new SequenceCompare());
        return codeList;
    }

    @Override
    public PosCodeValueList getCodeListStartWith(String codeID, String codeVer, String category, String startString) throws PosMasterDataException {
        PosCodeValueList codeList = this.getCodeList(codeID, codeVer, category);
        PosCodeValueList exceptList = new PosCodeValueList();
        for (PosCodeValueInfo valueInfo : codeList) {
            if (valueInfo.getCodeValue().startsWith(startString)) continue;
            exceptList.add(valueInfo);
        }
        codeList.removeAll(exceptList);
        return codeList;
    }

    private class SequenceCompare
    implements Comparator<PosCodeValueInfo> {
        private SequenceCompare() {
        }

        @Override
        public int compare(PosCodeValueInfo valueInfo1, PosCodeValueInfo valueInfo2) {
            return valueInfo1.getSequence().compareTo(valueInfo2.getSequence());
        }
    }

    private class MeanCompare
    implements Comparator<PosCodeValueInfo> {
        private MeanCompare() {
        }

        @Override
        public int compare(PosCodeValueInfo valueInfo1, PosCodeValueInfo valueInfo2) {
            return valueInfo1.getCodeMean().compareTo(valueInfo2.getCodeMean());
        }
    }

    private class ValueCompare
    implements Comparator<PosCodeValueInfo> {
        private ValueCompare() {
        }

        @Override
        public int compare(PosCodeValueInfo valueInfo1, PosCodeValueInfo valueInfo2) {
            return valueInfo1.getCodeValue().compareTo(valueInfo2.getCodeValue());
        }
    }
}

