/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.entity;

import com.poscoict.app.glue.master.access.common.PosMasterAccessConstants;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PosMasterCommonInfo
extends HashMap<String, String> {
    private static final long serialVersionUID = 6312619794757903121L;
    private static final String CM_ID = "CM_ID";
    private static final String CM_VER = "CM_VER";
    private static final String CM_TP = "CM_TP";
    private static final String DETAIL_TP = "DETAIL_TP";
    private static final String CM_NM = "CM_NM";
    private static final String START_DT = "START_DT";
    private static final String END_DT = "END_DT";
    private String m_masterID;
    private String m_masterVersion;
    private String m_masterType;
    private String m_detailType;
    private String m_masterName;
    private Date m_startActiveDate;
    private Date m_endActiveDate;

    public void setMasterCommonInfo(Map<String, Object> dataMap) {
        this.m_masterID = this.getRowData(dataMap, CM_ID);
        this.m_masterVersion = this.getRowData(dataMap, CM_VER);
        this.m_masterType = this.getRowData(dataMap, CM_TP);
        this.m_detailType = this.getRowData(dataMap, DETAIL_TP);
        this.m_masterName = this.getRowData(dataMap, CM_NM);
        this.m_startActiveDate = (Date)dataMap.get(START_DT);
        this.m_endActiveDate = (Date)dataMap.get(END_DT);
    }

    public String getMasterID() {
        return this.m_masterID;
    }

    public String getMasterVer() {
        return this.m_masterVersion;
    }

    public String getMasterType() {
        return this.m_masterType;
    }

    public String getDetailType() {
        return this.m_detailType;
    }

    public String getMasterName() {
        return this.m_masterName;
    }

    public Date getStartActiveDate() {
        return this.m_startActiveDate;
    }

    public Date getEndActiveDate() {
        return this.m_endActiveDate;
    }

    public Map<String, String> getMasterHeaderInfo() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put(CM_ID, this.m_masterID);
        headerMap.put(CM_VER, this.m_masterVersion);
        headerMap.put(CM_TP, this.m_masterType);
        headerMap.put(DETAIL_TP, this.m_detailType);
        headerMap.put(CM_NM, this.m_masterName);
        headerMap.put(START_DT, this.m_startActiveDate.toString());
        headerMap.put(END_DT, this.m_endActiveDate.toString());
        return headerMap;
    }

    protected String getRowData(Map<String, Object> dataMap, String key) {
        Object value = dataMap.get(key);
        String returnValue = null;
        if (value != null) {
            returnValue = value.toString();
        }
        return returnValue;
    }

    @Override
    public String toString() {
        PosMasterAccessConstants.MasterTypes masterType = PosMasterAccessConstants.MasterTypes.valueOf(this.m_masterType);
        StringBuilder sb = new StringBuilder();
        sb.append("Master Type : ").append(masterType.getDesc()).append("\n");
        sb.append("ID : ").append(this.m_masterID).append("\n");
        sb.append("Version : ").append(this.m_masterVersion).append("\n");
        sb.append("Master Name : ").append(this.m_masterName).append("\n");
        String detailType = "";
        switch (masterType) {
            case MC: {
                detailType = PosMasterAccessConstants.MasterCodeTypes.valueOf(this.m_detailType).getDesc();
                break;
            }
            case BR: {
                detailType = PosMasterAccessConstants.BusinessRuleTypes.valueOf(this.m_detailType).getDesc();
                break;
            }
            case CR: {
                detailType = PosMasterAccessConstants.CalculationRuleTypes.valueOf(this.m_detailType).getDesc();
                break;
            }
        }
        sb.append("Detail Type : ").append(detailType).append("\n");
        sb.append("Expiration Period : ").append(this.m_startActiveDate).append(" ~ ").append(this.m_endActiveDate);
        return sb.toString();
    }
}

