/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.entity;

import com.poscoict.app.glue.master.access.entity.PosMasterCommonInfo;
import com.poscoict.app.glue.master.access.exception.PosMasterDataException;
import com.poscoict.app.glue.master.access.type.PosCodeValueInfo;
import com.poscoict.app.glue.master.access.type.PosCodeValueList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PosMasterCodeInfo
extends PosMasterCommonInfo {
    private static final long serialVersionUID = 8356006909373233179L;
    private static final String CATE_ID = "CATE_ID";
    private static final String ITEM_ID = "ITEM_ID";
    private static final String ITEM_NM = "ITEM_NM";
    private static final String ITEM_MIN = "ITEM_MIN";
    private static final String ITEM_MAX = "ITEM_MAX";
    private static final String ITEM_SEQ = "ITEM_SEQ";
    private final Map<String, PosCodeValueList> m_codeMap = new HashMap<String, PosCodeValueList>();

    public void setMasterCodeInfo(List<Map<String, Object>> codeList) {
        for (Map<String, Object> codeRow : codeList) {
            String category = super.getRowData(codeRow, CATE_ID);
            if (!this.m_codeMap.containsKey(category)) {
                this.m_codeMap.put(category, new PosCodeValueList());
            }
            String codeValue = super.getRowData(codeRow, ITEM_ID);
            String codeMean = super.getRowData(codeRow, ITEM_NM);
            String minValue = super.getRowData(codeRow, ITEM_MIN);
            String maxValue = super.getRowData(codeRow, ITEM_MAX);
            String sequence = super.getRowData(codeRow, ITEM_SEQ);
            this.m_codeMap.get(category).add(new PosCodeValueInfo(codeValue, codeMean, minValue, maxValue, sequence));
        }
    }

    public PosCodeValueList getCodeList(String category) throws PosMasterDataException {
        if (!this.m_codeMap.containsKey(category)) {
            throw new PosMasterDataException("Category[" + category + "] does not found!!");
        }
        return this.m_codeMap.get(category);
    }
}

