/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.entity;

import com.poscoict.app.glue.master.access.common.PosMasterAccessConstants;
import com.poscoict.app.glue.master.access.entity.PosMasterCommonInfo;
import com.poscoict.app.glue.master.access.exception.PosMasterDataException;
import com.poscoict.app.glue.master.access.type.PosInfValueInfo;
import com.poscoict.app.glue.master.access.util.PosMasterUtil;
import com.poscoict.glueframework.dao.jdbc.GlueGenericJdbcDao;
import com.poscoict.glueframework.dao.vo.GlueParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PosInterfaceFormatInfo
extends PosMasterCommonInfo {
    private static final long serialVersionUID = -1870779946217922293L;
    private static final String STD_NM = "STD_NM";
    private static final String STD_ID = "STD_ID";
    private static final String ITEM_TP = "ITEM_TP";
    private static final String DATA_TP = "DATA_TP";
    private static final String DATA_LEN = "DATA_LEN";
    private static final String OPER_TP = "OPER_TP";
    private static final String COMP_VAL1 = "COMP_VAL1";
    private static final String COMP_VAL2 = "COMP_VAL2";
    private static final String OPER_REL = "OPER_REL";
    private static final String TRUE_YN = "TRUE_YN";
    private InterfaceLayoutInfo m_layoutInfo;
    private GlueGenericJdbcDao m_dao;
    private final Map<String, InterfaceCheckInfo> m_checkInfoMap = new HashMap<String, InterfaceCheckInfo>();
    private String m_tcID;

    public void setInterfaceFormatLayout(List<Map<String, Object>> layoutList) {
        this.m_layoutInfo = new InterfaceLayoutInfo();
        for (Map<String, Object> layout : layoutList) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put(STD_NM, super.getRowData(layout, STD_NM));
            itemMap.put(STD_ID, super.getRowData(layout, STD_ID));
            itemMap.put(ITEM_TP, super.getRowData(layout, ITEM_TP));
            itemMap.put(DATA_TP, super.getRowData(layout, DATA_TP));
            itemMap.put(DATA_LEN, super.getRowData(layout, DATA_LEN));
            this.m_layoutInfo.add(itemMap);
        }
        this.m_layoutInfo.parseItemMap();
    }

    public void setDAO(GlueGenericJdbcDao dao) {
        this.m_dao = dao;
    }

    public void setInterfaceTcId(String tcID) {
        this.m_tcID = tcID;
    }

    public PosInfValueInfo getInfValueInfo(String message) {
        LinkedHashMap<String, String> messageMap;
        PosInfValueInfo infInfo = new PosInfValueInfo();
        if (message.length() == this.m_layoutInfo.getLength()) {
            int substrIdx = 0;
            messageMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Integer> entry : this.m_layoutInfo.getItemMap().entrySet()) {
                int startIdx = substrIdx;
                int endIdx = startIdx + entry.getValue();
                messageMap.put(entry.getKey(), message.substring(startIdx, endIdx));
                substrIdx = endIdx;
            }
        } else {
            throw new PosMasterDataException("Message Length[" + message.length() + "] does not match Layout Length[" + this.m_layoutInfo.getLength() + "]!!!");
        }
        infInfo.setMessage(message);
        infInfo.setMessageMap(messageMap);
        infInfo.setLayoutMap(this.m_layoutInfo.getItemMap());
        infInfo.setErrorList(this.getErrorList(messageMap));
        infInfo.setHeaderInfo(super.toString());
        return infInfo;
    }

    private List<String[]> getErrorList(Map<String, String> messageMap) {
        InterfaceCheckInfo checkInfo;
        ArrayList<String[]> errorList = new ArrayList<String[]>();
        if (!this.m_checkInfoMap.containsKey(this.m_tcID)) {
            checkInfo = new InterfaceCheckInfo();
            ArrayList<String> paramList = new ArrayList<String>(3);
            paramList.add(this.m_tcID);
            paramList.add(super.getMasterID());
            paramList.add(super.getMasterVer());
            GlueParameter param = new GlueParameter();
            param.setParameter(paramList);
            List resultList = this.m_dao.find("ACCESS_SELECT_INTERFACE_TC_CHECK", param);
            for (Map check : resultList) {
                String stdNm = super.getRowData(check, STD_NM);
                if (!checkInfo.containsKey(stdNm)) {
                    checkInfo.put(stdNm, new ArrayList());
                }
                List checkList = (List)checkInfo.get(stdNm);
                HashMap<String, String> checkMap = new HashMap<String, String>();
                checkMap.put(OPER_TP, super.getRowData(check, OPER_TP));
                checkMap.put(COMP_VAL1, super.getRowData(check, COMP_VAL1));
                checkMap.put(COMP_VAL2, super.getRowData(check, COMP_VAL2));
                checkMap.put(OPER_REL, super.getRowData(check, OPER_REL));
                checkMap.put(TRUE_YN, super.getRowData(check, TRUE_YN));
                checkList.add(checkMap);
            }
            this.m_checkInfoMap.put(this.m_tcID, checkInfo);
        }
        checkInfo = this.m_checkInfoMap.get(this.m_tcID);
        for (Map.Entry<String, String> messageEntry : messageMap.entrySet()) {
            String value;
            String stdName = this.m_layoutInfo.getStandardName(messageEntry.getKey());
            if (checkInfo.checkValid(stdName, value = messageEntry.getValue().trim())) continue;
            errorList.add(new String[]{messageEntry.getKey(), value, checkInfo.getErrorCheckDescription(stdName)});
        }
        return errorList;
    }

    public PosInfValueInfo getInfValueInfo(Map<String, String> messageMap) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.m_layoutInfo.getItemMap().entrySet()) {
            String value = messageMap.get(entry.getKey());
            int length = entry.getValue();
            builder.append(this.makeItem(value, length));
        }
        return this.getInfValueInfo(builder.toString());
    }

    private String makeItem(String itemValue, int length) {
        String result = StringUtils.rightPad((String)"", (int)length);
        if (itemValue != null) {
            result = itemValue.length() >= length ? itemValue.substring(0, length) : StringUtils.rightPad((String)itemValue, (int)length);
        }
        return result;
    }

    protected class InterfaceCheckInfo
    extends HashMap<String, List<Map<String, String>>> {
        private static final long serialVersionUID = -1343961376396726156L;

        protected InterfaceCheckInfo() {
        }

        public String getErrorCheckDescription(String stdName) {
            List checkMapList = (List)this.get(stdName);
            StringBuilder sb = new StringBuilder();
            for (Map checkMap : checkMapList) {
                String operRelation;
                String operator = (String)checkMap.get(PosInterfaceFormatInfo.OPER_TP);
                String compare1 = checkMap.get(PosInterfaceFormatInfo.COMP_VAL1) != null ? (String)checkMap.get(PosInterfaceFormatInfo.COMP_VAL1) : "";
                String compare2 = checkMap.get(PosInterfaceFormatInfo.COMP_VAL2) != null ? (String)checkMap.get(PosInterfaceFormatInfo.COMP_VAL2) : "";
                boolean isTrue = false;
                if ("Y".equals(checkMap.get(PosInterfaceFormatInfo.TRUE_YN))) {
                    isTrue = true;
                }
                if ("AD".equals(operRelation = (String)checkMap.get(PosInterfaceFormatInfo.OPER_REL))) {
                    operRelation = "AND";
                }
                sb.append("Operator : [").append((Object)PosMasterAccessConstants.OPERATOR2.valueOf(operator)).append("], ");
                sb.append("Compare Value 1 : [").append(compare1).append("], ");
                sb.append("Compare Value 2 : [").append(compare2).append("], ");
                sb.append("True/False : [").append(isTrue).append("], ");
                sb.append("Operation Relation : [").append(operRelation).append("]\n");
            }
            return sb.toString();
        }

        public boolean checkValid(String stdName, String value) {
            boolean isValid = true;
            ArrayList<Boolean> checkList = new ArrayList<Boolean>();
            ArrayList relationList = new ArrayList();
            List checkMapList = (List)this.get(stdName);
            if (checkMapList == null) {
                return true;
            }
            for (Map checkMap : checkMapList) {
                String compare1 = checkMap.get(PosInterfaceFormatInfo.COMP_VAL1) != null ? (String)checkMap.get(PosInterfaceFormatInfo.COMP_VAL1) : "";
                String compare2 = checkMap.get(PosInterfaceFormatInfo.COMP_VAL2) != null ? (String)checkMap.get(PosInterfaceFormatInfo.COMP_VAL2) : "";
                String operator = (String)checkMap.get(PosInterfaceFormatInfo.OPER_TP);
                String trueYn = (String)checkMap.get(PosInterfaceFormatInfo.TRUE_YN);
                boolean checkResult = PosMasterUtil.checkLogic(value, compare1, compare2, operator);
                if ("Y".equals(trueYn)) {
                    checkList.add(checkResult);
                } else if ("N".equals(trueYn)) {
                    checkList.add(!checkResult);
                }
                relationList.add(checkMap.get(PosInterfaceFormatInfo.OPER_REL));
            }
            for (int i = 0; i < checkList.size(); ++i) {
                String relation = (String)relationList.get(i);
                Boolean checkResult = (Boolean)checkList.get(i);
                if ("AD".equals(relation)) {
                    isValid = isValid && checkResult != false;
                    continue;
                }
                if (!"OR".equals(relation)) continue;
                isValid = isValid || checkResult != false;
            }
            return isValid;
        }
    }

    protected class InterfaceLayoutInfo
    extends ArrayList<Map<String, String>> {
        private static final long serialVersionUID = 8493370894169978769L;
        private static final String GROUP_KEY = "#GROUP#";
        private Map<String, Integer> parsedItemMap;

        protected InterfaceLayoutInfo() {
        }

        public Map<String, Integer> getItemMap() {
            return this.parsedItemMap;
        }

        public Map<String, Integer> parseItemMap() {
            LinkedHashMap<String, Integer> itemInfoMap = new LinkedHashMap<String, Integer>();
            ArrayList tempMapList = new ArrayList();
            for (Map itemMap : this) {
                String string = (String)itemMap.get(PosInterfaceFormatInfo.STD_ID);
                int dataLen = Integer.parseInt((String)itemMap.get(PosInterfaceFormatInfo.DATA_LEN));
                PosMasterAccessConstants.ItemTypes itemType = PosMasterAccessConstants.ItemTypes.valueOf((String)itemMap.get(PosInterfaceFormatInfo.ITEM_TP));
                switch (itemType) {
                    case IT: {
                        Map<String, Integer> groupItemMap = new LinkedHashMap<String, Integer>();
                        groupItemMap.put(string, dataLen);
                        tempMapList.add(groupItemMap);
                        break;
                    }
                    case GR: {
                        Map<String, Integer> groupItemMap = new LinkedHashMap();
                        groupItemMap.put(GROUP_KEY, dataLen);
                        groupItemMap.put(string, 0);
                        tempMapList.add(groupItemMap);
                        break;
                    }
                    case GI: {
                        Map<String, Integer> groupItemMap = (Map)tempMapList.get(tempMapList.size() - 1);
                        groupItemMap.put(string, dataLen);
                    }
                }
            }
            String groupName = "";
            for (Map map : tempMapList) {
                if (map.containsKey(GROUP_KEY)) {
                    int groupLength = (Integer)map.remove(GROUP_KEY);
                    for (Map.Entry entry : map.entrySet()) {
                        if ((Integer)entry.getValue() != 0) continue;
                        groupName = (String)entry.getKey();
                        map.remove(groupName);
                        break;
                    }
                    for (int i = 1; i <= groupLength; ++i) {
                        for (Map.Entry entry : map.entrySet()) {
                            itemInfoMap.put(groupName + "." + i + "." + (String)entry.getKey(), (Integer)entry.getValue());
                        }
                    }
                    continue;
                }
                itemInfoMap.putAll(map);
            }
            this.parsedItemMap = itemInfoMap;
            return itemInfoMap;
        }

        public int getLength() {
            int totalLength = 0;
            for (Integer itemLength : this.getItemMap().values()) {
                totalLength += itemLength.intValue();
            }
            return totalLength;
        }

        public String getStandardName(String stdID) {
            String stdName = null;
            for (Map itemMap : this) {
                switch (PosMasterAccessConstants.ItemTypes.valueOf((String)itemMap.get(PosInterfaceFormatInfo.ITEM_TP))) {
                    case IT: {
                        if (!stdID.equals(itemMap.get(PosInterfaceFormatInfo.STD_ID))) break;
                        stdName = (String)itemMap.get(PosInterfaceFormatInfo.STD_NM);
                        break;
                    }
                    case GI: {
                        if (!stdID.startsWith((String)itemMap.get(PosInterfaceFormatInfo.STD_ID))) break;
                        stdName = (String)itemMap.get(PosInterfaceFormatInfo.STD_NM);
                        break;
                    }
                }
            }
            return stdName;
        }
    }
}

