/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.entity;

import com.poscoict.app.glue.master.access.MasterAccess;
import com.poscoict.app.glue.master.access.common.PosMasterAccessConstants;
import com.poscoict.app.glue.master.access.entity.PosMasterCommonInfo;
import com.poscoict.app.glue.master.access.exception.PosMasterDataException;
import com.poscoict.app.glue.master.access.type.PosCalcValueInfo;
import com.poscoict.app.glue.master.access.type.PosRuleValueInfo;
import com.poscoict.app.glue.master.access.util.PosMasterUtil;
import com.poscoict.glueframework.dao.jdbc.GlueGenericJdbcDao;
import com.poscoict.glueframework.dao.vo.GlueParameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PosCalculationRuleInfo
extends PosMasterCommonInfo {
    private static final long serialVersionUID = -1636873954178508169L;
    private static final String ITEM_SEQ = "ITEM_SEQ";
    private static final String ITEM_LABEL = "ITEM_LABEL";
    private static final String STD_NM = "STD_NM";
    private static final String STD_ID = "STD_ID";
    private static final String PROC_TP = "PROC_TP";
    private static final String BR_ID = "BR_ID";
    private static final String BR_VER = "BR_VER";
    private static final String FACTOR_CNT = "FACTOR_CNT";
    private static final String FACTOR_SEQ = "FACTOR_SEQ";
    private static final String OPER_TP = "OPER_TP";
    private static final String COMP_VAL1 = "COMP_VAL1";
    private static final String COMP_VAL2 = "COMP_VAL2";
    private static final String RSLT_VAL = "RSLT_VAL";
    private static final String FORMULA_COND = "FORMULA_COND";
    private static final String FORMULA = "FORMULA";
    private static final String CR_COND = "CR_COND";
    private static final String APPROX_TP = "APPROX_TP";
    private static final String DECIMAL_PREC = "DECIMAL_PREC";
    private static final String UOM_NM = "UOM_NM";
    private CalcRuleItemInfo m_itemInfo;
    private CalcRuleFactorInfo m_factorInfo;
    private CalcRuleFormulaInfo m_formulInfo;
    private CalcRuleInoutInfo m_inoutInfo;
    private GlueGenericJdbcDao m_dao;

    public void setCalculationRuleItem(List<Map<String, Object>> itemList) {
        this.m_itemInfo = new CalcRuleItemInfo();
        for (Map<String, Object> item : itemList) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put(ITEM_SEQ, super.getRowData(item, ITEM_SEQ));
            itemMap.put(ITEM_LABEL, super.getRowData(item, ITEM_LABEL));
            itemMap.put(STD_NM, super.getRowData(item, STD_NM));
            itemMap.put(STD_ID, super.getRowData(item, STD_ID));
            itemMap.put(PROC_TP, super.getRowData(item, PROC_TP));
            itemMap.put(BR_ID, super.getRowData(item, BR_ID));
            itemMap.put(BR_VER, super.getRowData(item, BR_VER));
            itemMap.put(FACTOR_CNT, super.getRowData(item, FACTOR_CNT));
            this.m_itemInfo.add(itemMap);
        }
    }

    public void setCalculationRuleFactor(List<Map<String, Object>> factorList) {
        this.m_factorInfo = new CalcRuleFactorInfo();
        for (Map<String, Object> factor : factorList) {
            String itemSeq = super.getRowData(factor, ITEM_SEQ);
            if (!this.m_factorInfo.containsKey(itemSeq)) {
                this.m_factorInfo.put(itemSeq, new CalcRuleFactor());
            }
            CalcRuleFactor ruleFactor = (CalcRuleFactor)this.m_factorInfo.get(itemSeq);
            HashMap<String, String> factorMap = new HashMap<String, String>();
            factorMap.put(FACTOR_SEQ, super.getRowData(factor, FACTOR_SEQ));
            factorMap.put(OPER_TP, super.getRowData(factor, OPER_TP));
            factorMap.put(COMP_VAL1, super.getRowData(factor, COMP_VAL1));
            factorMap.put(COMP_VAL2, super.getRowData(factor, COMP_VAL2));
            factorMap.put(RSLT_VAL, super.getRowData(factor, RSLT_VAL));
            ruleFactor.add(factorMap);
        }
    }

    public void setCalculationRuleFormula(List<Map<String, Object>> formulaList) {
        this.m_formulInfo = new CalcRuleFormulaInfo();
        for (Map<String, Object> formula : formulaList) {
            HashMap<String, String> formulaMap = new HashMap<String, String>();
            formulaMap.put(FORMULA_COND, super.getRowData(formula, FORMULA_COND));
            formulaMap.put(FORMULA, super.getRowData(formula, FORMULA));
            this.m_formulInfo.add(formulaMap);
        }
    }

    public void setCalculationRuleInout(List<Map<String, Object>> inoutList) {
        this.m_inoutInfo = new CalcRuleInoutInfo();
        for (Map<String, Object> inout : inoutList) {
            this.m_inoutInfo.put(CR_COND, super.getRowData(inout, CR_COND));
            this.m_inoutInfo.put(APPROX_TP, super.getRowData(inout, APPROX_TP));
            this.m_inoutInfo.put(DECIMAL_PREC, super.getRowData(inout, DECIMAL_PREC));
            this.m_inoutInfo.put(UOM_NM, super.getRowData(inout, UOM_NM));
        }
    }

    public void setDAO(GlueGenericJdbcDao dao) {
        this.m_dao = dao;
    }

    public PosCalcValueInfo getCalcValueInfo(List<String[]> inputParamList) {
        String formula;
        PosCalcValueInfo calcInfo = new PosCalcValueInfo();
        Map<String, String> inputValueMap = this.getInputValueList(inputParamList);
        if (this.m_formulInfo == null || this.m_formulInfo.size() == 0) {
            throw new PosMasterDataException("Calculation formula is not registered. : CM_ID = [" + super.getMasterID() + "]");
        }
        if (this.m_inoutInfo == null || this.m_inoutInfo.size() == 0 || this.m_inoutInfo.get(CR_COND) == null || ((String)this.m_inoutInfo.get(CR_COND)).trim().length() == 0 || this.checkCondition((String)this.m_inoutInfo.get(CR_COND), inputValueMap)) {
            formula = "";
            switch (PosMasterAccessConstants.CalculationRuleTypes.valueOf(super.getDetailType())) {
                case SF: {
                    formula = (String)((Map)this.m_formulInfo.get(0)).get(FORMULA);
                    break;
                }
                case CF: {
                    formula = this.getFormula(inputValueMap);
                }
            }
        } else {
            throw new PosMasterDataException("Invalid Calculation Rule Precondition!!! : INPUT_VALUE[" + inputValueMap + "], CONDITION[" + (String)this.m_inoutInfo.get(CR_COND) + "]");
        }
        calcInfo.setFormula(formula);
        calcInfo.setInputValues(inputValueMap);
        calcInfo.setCalcResultValue(this.roundValue(this.calculateFormula(formula, inputValueMap)));
        calcInfo.setHeaderInfo(super.toString());
        return calcInfo;
    }

    private Map<String, String> getInputValueList(List<String[]> inputParamList) {
        HashMap<String, String> inputValueMap = new HashMap<String, String>();
        if (inputParamList.size() == this.m_itemInfo.size()) {
            block5: for (int i = 0; i < this.m_itemInfo.size(); ++i) {
                Map itemMap = (Map)this.m_itemInfo.get(i);
                String[] inputParams = inputParamList.get(i);
                switch (PosMasterAccessConstants.ProcessTypes.valueOf((String)itemMap.get(PROC_TP))) {
                    case VA: 
                    case SE: {
                        inputValueMap.put((String)itemMap.get(ITEM_LABEL), inputParams[0]);
                        continue block5;
                    }
                    case FC: {
                        inputValueMap.put((String)itemMap.get(ITEM_LABEL), this.getFactorValue(inputParams[0], (String)itemMap.get(ITEM_SEQ)));
                        continue block5;
                    }
                    case RT: {
                        PosRuleValueInfo info = MasterAccess.getRuleValueInfo((String)itemMap.get(BR_ID), (String)itemMap.get(BR_VER), inputParams);
                        inputValueMap.put((String)itemMap.get(ITEM_LABEL), info.getRuleResult(0)[0]);
                    }
                }
            }
        } else {
            throw new PosMasterDataException("Input Parameter's Count[" + inputParamList.size() + "] and Input Item's Count[" + this.m_itemInfo.size() + "] must be the same!!!");
        }
        return inputValueMap;
    }

    private String getFactorValue(String inputParam, String itemSeq) {
        String returnValue = "";
        for (Map factorMap : (CalcRuleFactor)this.m_factorInfo.get(itemSeq)) {
            String result;
            String compare1 = factorMap.get(COMP_VAL1) != null ? (String)factorMap.get(COMP_VAL1) : "";
            String compare2 = factorMap.get(COMP_VAL2) != null ? (String)factorMap.get(COMP_VAL2) : "";
            String string = result = factorMap.get(RSLT_VAL) != null ? (String)factorMap.get(RSLT_VAL) : "";
            String operator = (String)factorMap.get(OPER_TP);
            if (!PosMasterUtil.checkLogic(inputParam, compare1, compare2, operator)) continue;
            returnValue = result;
            break;
        }
        return returnValue;
    }

    private boolean checkCondition(String condition, Map<String, String> inputValueMap) {
        List resultList = null;
        if (condition != null && condition.trim().length() != 0) {
            List<String> tokenList = PosMasterUtil.tokenize(condition, "()+-*/><=!, ");
            String whereClause = PosMasterUtil.makeWhereClause(tokenList, inputValueMap);
            List<String> paramList = PosMasterUtil.makeWhereClauseParameter(tokenList, inputValueMap);
            GlueParameter param = new GlueParameter();
            param.setParameter(paramList);
            resultList = this.m_dao.find("ACCESS_CHECK_BUSINESS_RULE", whereClause, param);
        }
        return resultList != null && resultList.size() > 0;
    }

    private String getFormula(Map<String, String> inputValueMap) {
        String formula = "";
        for (Map formulaMap : this.m_formulInfo) {
            String formulaCond = (String)formulaMap.get(FORMULA_COND);
            if (!this.checkCondition(formulaCond, inputValueMap)) continue;
            formula = (String)formulaMap.get(FORMULA);
            break;
        }
        return formula;
    }

    private BigDecimal calculateFormula(String formula, Map<String, String> inputValueMap) {
        List<String> tokenList = PosMasterUtil.tokenize(formula, "()+-*/><=!, ");
        String whereClause = PosMasterUtil.makeWhereClause(tokenList, inputValueMap);
        List<String> paramList = PosMasterUtil.makeWhereClauseParameter(tokenList, inputValueMap);
        GlueParameter param = new GlueParameter();
        param.setParameter(paramList);
        String query = this.m_dao.getQueryManager().getQueryDefinition("ACCESS_CHECK_CALCULATION_RULE").getQueryStatement();
        query = query.replaceAll("#CALCULATION#", whereClause);
        List resultList = this.m_dao.findByQueryStatement(query, param);
        return new BigDecimal(((Map)resultList.get(0)).get("RESULT").toString());
    }

    private BigDecimal roundValue(BigDecimal value) {
        BigDecimal resultValue = null;
        if (this.m_inoutInfo.get(APPROX_TP) == null) {
            return value;
        }
        String decimalPrec = (String)this.m_inoutInfo.get(DECIMAL_PREC);
        if (decimalPrec == null || decimalPrec.trim().length() == 0) {
            decimalPrec = "0";
        }
        int roundPoint = Integer.parseInt(decimalPrec);
        switch (PosMasterAccessConstants.ApproximateTypes.valueOf((String)this.m_inoutInfo.get(APPROX_TP))) {
            case RU: {
                resultValue = value.setScale(roundPoint, 4);
                break;
            }
            case CE: {
                resultValue = value.setScale(roundPoint, 2);
                break;
            }
            case FL: {
                resultValue = value.setScale(roundPoint, 3);
                break;
            }
            case KR: {
                resultValue = this.roundKS(value, roundPoint);
                break;
            }
            case JR: {
                resultValue = this.roundJS(value, roundPoint);
            }
        }
        return resultValue;
    }

    private BigDecimal roundKS(BigDecimal value, int rPosition) {
        BigDecimal resultValue = null;
        String strValue = value.toPlainString();
        int idxPoint = strValue.indexOf(".");
        if (idxPoint != -1) {
            String number;
            int idxBase = idxPoint + rPosition;
            while (strValue.length() < idxBase + 2) {
                strValue = strValue + "0";
            }
            resultValue = "5".equals(strValue.substring(idxBase + 1, idxBase + 2)) ? (Integer.parseInt(number = strValue.substring(idxBase, idxBase + 1)) % 2 == 0 ? value.setScale(rPosition, 3) : value.setScale(rPosition, 2)) : value.setScale(rPosition, 4);
        } else {
            resultValue = value.setScale(rPosition, 4);
        }
        return resultValue;
    }

    private BigDecimal roundJS(BigDecimal value, int rPosition) {
        BigDecimal resultValue = null;
        String strValue = value.toPlainString();
        int idxPoint = strValue.indexOf(".");
        if (idxPoint != -1) {
            String number;
            int idxBase = idxPoint + rPosition;
            while (strValue.length() < idxBase + 3) {
                strValue = strValue + "0";
            }
            resultValue = "50".equals(strValue.substring(idxBase + 1, idxBase + 3)) ? (Integer.parseInt(number = strValue.substring(idxBase, idxBase + 1)) % 2 == 0 ? value.setScale(rPosition, 3) : value.setScale(rPosition, 2)) : value.setScale(rPosition, 4);
        } else {
            resultValue = value.setScale(rPosition, 4);
        }
        return resultValue;
    }

    protected class CalcRuleInoutInfo
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1338631169934733643L;

        protected CalcRuleInoutInfo() {
        }
    }

    protected class CalcRuleFormulaInfo
    extends ArrayList<Map<String, String>> {
        private static final long serialVersionUID = 5036718231471011869L;

        protected CalcRuleFormulaInfo() {
        }
    }

    protected class CalcRuleFactor
    extends ArrayList<Map<String, String>> {
        private static final long serialVersionUID = 709193037915791689L;

        protected CalcRuleFactor() {
        }
    }

    protected class CalcRuleFactorInfo
    extends HashMap<String, CalcRuleFactor> {
        private static final long serialVersionUID = -6676486078293417271L;

        protected CalcRuleFactorInfo() {
        }
    }

    protected class CalcRuleItemInfo
    extends ArrayList<Map<String, String>> {
        private static final long serialVersionUID = -3038311058464882695L;

        protected CalcRuleItemInfo() {
        }
    }
}

