/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.entity;

import com.poscoict.app.glue.master.access.common.PosMasterAccessConstants;
import com.poscoict.app.glue.master.access.entity.PosMasterCommonInfo;
import com.poscoict.app.glue.master.access.exception.PosMasterDataException;
import com.poscoict.app.glue.master.access.type.PosRuleValueInfo;
import com.poscoict.app.glue.master.access.util.PosMasterUtil;
import com.poscoict.glueframework.dao.jdbc.GlueGenericJdbcDao;
import com.poscoict.glueframework.dao.vo.GlueParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PosBusinessRuleInfo
extends PosMasterCommonInfo {
    private static final long serialVersionUID = -669417862823859678L;
    private static final String LAYOUT_SEQ = "LAYOUT_SEQ";
    private static final String STD_NM = "STD_NM";
    private static final String STD_ID = "STD_ID";
    private static final String COND_YN = "COND_YN";
    private static final String OPER_TP = "OPER_TP";
    private static final String SUBSTR_IDX = "SUBSTR_IDX";
    private static final String SUBSTR_LEN = "SUBSTR_LEN";
    private static final String DATA_SEQ = "DATA_SEQ";
    private static final String BR_DATA = "BR_DATA";
    private static final String COMP_VAL1 = "COMP_VAL1";
    private static final String COMP_VAL2 = "COMP_VAL2";
    private static final String WILDCARD = "%";
    private static final String EXCEPTION_SEQ = "0";
    private BizRuleLayoutInfo m_layoutInfo;
    private BizRuleDataInfo m_dataInfo;
    private GlueGenericJdbcDao m_dao;

    public void setBusinessRuleLayout(List<Map<String, Object>> layoutList) {
        this.m_layoutInfo = new BizRuleLayoutInfo(layoutList.size());
        for (Map<String, Object> layout : layoutList) {
            String layoutSeq = super.getRowData(layout, LAYOUT_SEQ);
            BizRuleLayout ruleLayout = new BizRuleLayout();
            ruleLayout.put(LAYOUT_SEQ, layoutSeq);
            ruleLayout.put(STD_NM, super.getRowData(layout, STD_NM));
            ruleLayout.put(STD_ID, super.getRowData(layout, STD_ID));
            ruleLayout.put(COND_YN, super.getRowData(layout, COND_YN));
            ruleLayout.put(OPER_TP, super.getRowData(layout, OPER_TP));
            ruleLayout.put(SUBSTR_IDX, super.getRowData(layout, SUBSTR_IDX));
            ruleLayout.put(SUBSTR_LEN, super.getRowData(layout, SUBSTR_LEN));
            this.m_layoutInfo.put(layoutSeq, ruleLayout);
        }
    }

    public void setBusinessRuleData(List<Map<String, Object>> dataList) {
        this.m_dataInfo = new BizRuleDataInfo();
        for (Map<String, Object> data : dataList) {
            String dataSeq = super.getRowData(data, DATA_SEQ);
            String layoutSeq = super.getRowData(data, LAYOUT_SEQ);
            BizRuleData ruleData = (BizRuleData)this.m_dataInfo.get(dataSeq);
            if (ruleData == null) {
                ruleData = new BizRuleData();
                this.m_dataInfo.put(dataSeq, ruleData);
            }
            HashMap<String, String> dataMap = new HashMap<String, String>(5);
            dataMap.put(STD_NM, this.m_layoutInfo.getItemID(layoutSeq));
            dataMap.put(BR_DATA, super.getRowData(data, BR_DATA));
            dataMap.put(OPER_TP, super.getRowData(data, OPER_TP));
            dataMap.put(COMP_VAL1, super.getRowData(data, COMP_VAL1));
            dataMap.put(COMP_VAL2, super.getRowData(data, COMP_VAL2));
            ruleData.put(layoutSeq, dataMap);
        }
    }

    public void setDAO(GlueGenericJdbcDao dao) {
        this.m_dao = dao;
    }

    public PosRuleValueInfo getAllRuleValueInfo() {
        PosRuleValueInfo ruleInfo = new PosRuleValueInfo(this.m_layoutInfo.getItemIDList(this.m_layoutInfo.getLayoutSeqList()));
        List<String> condLayoutSeqList = this.m_layoutInfo.getCondLayoutSeqList();
        List<String> rsltLayoutSeqList = this.m_layoutInfo.getRsltLayoutSeqList();
        switch (PosMasterAccessConstants.BusinessRuleTypes.valueOf(super.getDetailType())) {
            case SG: 
            case MG: 
            case CG: {
                for (Map.Entry entry : this.m_dataInfo.entrySet()) {
                    ruleInfo.addRuleResult(((BizRuleData)entry.getValue()).getDataList(this.m_layoutInfo.getLayoutSeqList(), BR_DATA));
                }
                break;
            }
            case SC: {
                for (Map.Entry entry : this.m_dataInfo.entrySet()) {
                    List<String> condList = ((BizRuleData)entry.getValue()).getDataList(condLayoutSeqList, OPER_TP, COMP_VAL1, COMP_VAL2);
                    List<String> rsltList = ((BizRuleData)entry.getValue()).getDataList(rsltLayoutSeqList, BR_DATA);
                    condList.addAll(rsltList);
                    ruleInfo.addRuleResult(condList);
                }
                break;
            }
            case RC: {
                List<String> condItemIDList = this.m_layoutInfo.getItemIDList(condLayoutSeqList);
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i <= condItemIDList.size(); ++i) {
                    sb.append(" / " + condItemIDList.get(i - 1) + "(V" + i + ")");
                }
                ArrayList<String> condItemList = new ArrayList<String>(1);
                condItemList.add(sb.toString().substring(3));
                List<String> rsltIDList = this.m_layoutInfo.getItemIDList(rsltLayoutSeqList);
                condItemList.addAll(rsltIDList);
                ruleInfo = new PosRuleValueInfo((List<String>)condItemList);
                for (Map.Entry entry : this.m_dataInfo.entrySet()) {
                    ArrayList<String> resultList = new ArrayList<String>();
                    String condition = ((BizRuleData)entry.getValue()).getData(Collections.min(condLayoutSeqList), BR_DATA);
                    resultList.add(condition);
                    List<String> rsltList = ((BizRuleData)entry.getValue()).getDataList(rsltLayoutSeqList, BR_DATA);
                    resultList.addAll(rsltList);
                    ruleInfo.addRuleResult(resultList);
                }
                break;
            }
        }
        ruleInfo.setHeaderInfo(super.toString());
        return ruleInfo;
    }

    public PosRuleValueInfo getRuleValueInfo(String[] inputParams) {
        List<String> condLayoutSeqList = this.m_layoutInfo.getCondLayoutSeqList();
        List<String> inputValueList = this.getInputValueList(inputParams, condLayoutSeqList);
        PosRuleValueInfo ruleInfo = new PosRuleValueInfo(this.m_layoutInfo.getItemIDList(this.m_layoutInfo.getRsltLayoutSeqList()));
        block0 : switch (PosMasterAccessConstants.BusinessRuleTypes.valueOf(super.getDetailType())) {
            case SG: 
            case MG: {
                for (Map.Entry entry : this.m_dataInfo.entrySet()) {
                    List<String> condDataList;
                    if (((String)entry.getKey()).equals(EXCEPTION_SEQ) || !this.checkEqual(inputValueList, condDataList = ((BizRuleData)entry.getValue()).getDataList(condLayoutSeqList, BR_DATA))) continue;
                    ruleInfo.addRuleResult(((BizRuleData)entry.getValue()).getDataList(this.m_layoutInfo.getRsltLayoutSeqList(), BR_DATA));
                }
                break;
            }
            case CG: {
                List<String> operator1List = this.m_layoutInfo.getLayoutAttrList(OPER_TP, condLayoutSeqList);
                for (Map.Entry entry : this.m_dataInfo.entrySet()) {
                    List<String> condDataList;
                    if (((String)entry.getKey()).equals(EXCEPTION_SEQ) || !this.checkLogic(inputValueList, condDataList = ((BizRuleData)entry.getValue()).getDataList(condLayoutSeqList, BR_DATA), operator1List)) continue;
                    ruleInfo.addRuleResult(((BizRuleData)entry.getValue()).getDataList(this.m_layoutInfo.getRsltLayoutSeqList(), BR_DATA));
                    break block0;
                }
                break;
            }
            case SC: {
                for (Map.Entry entry : this.m_dataInfo.entrySet()) {
                    List<String> operator2List;
                    List<String> compare2List;
                    List<String> compare1List;
                    if (((String)entry.getKey()).equals(EXCEPTION_SEQ) || !this.checkLogic(inputValueList, compare1List = ((BizRuleData)entry.getValue()).getDataList(condLayoutSeqList, COMP_VAL1), compare2List = ((BizRuleData)entry.getValue()).getDataList(condLayoutSeqList, COMP_VAL2), operator2List = ((BizRuleData)entry.getValue()).getDataList(condLayoutSeqList, OPER_TP))) continue;
                    ruleInfo.addRuleResult(((BizRuleData)entry.getValue()).getDataList(this.m_layoutInfo.getRsltLayoutSeqList(), BR_DATA));
                }
                break;
            }
            case RC: {
                for (Map.Entry entry : this.m_dataInfo.entrySet()) {
                    String condition;
                    if (((String)entry.getKey()).equals(EXCEPTION_SEQ) || !this.checkLogic(inputValueList, condition = ((BizRuleData)entry.getValue()).getData(Collections.min(condLayoutSeqList), BR_DATA))) continue;
                    ruleInfo.addRuleResult(((BizRuleData)entry.getValue()).getDataList(this.m_layoutInfo.getRsltLayoutSeqList(), BR_DATA));
                    break block0;
                }
                break;
            }
        }
        if (ruleInfo.size() == 0) {
            ruleInfo.addRuleResult(((BizRuleData)this.m_dataInfo.get(EXCEPTION_SEQ)).getDataList(this.m_layoutInfo.getRsltLayoutSeqList(), BR_DATA));
        }
        ruleInfo.setHeaderInfo(super.toString());
        return ruleInfo;
    }

    private List<String> getInputValueList(String[] inputParams, List<String> condLayoutSeqList) {
        if (inputParams.length == condLayoutSeqList.size()) {
            ArrayList<String> inputValueList = new ArrayList<String>(inputParams.length);
            List<String> substrIndexList = this.m_layoutInfo.getLayoutAttrList(SUBSTR_IDX, condLayoutSeqList);
            List<String> substrLengthList = this.m_layoutInfo.getLayoutAttrList(SUBSTR_LEN, condLayoutSeqList);
            for (int i = 0; i < inputParams.length; ++i) {
                int substrLength;
                int substrIndex;
                String inputValue = inputParams[i];
                int n = substrIndex = substrIndexList.get(i) != null ? Integer.parseInt(substrIndexList.get(i)) - 1 : -1;
                if (inputValue == null) {
                    inputValueList.add(null);
                    continue;
                }
                int n2 = substrLength = substrLengthList.get(i) != null ? Integer.parseInt(substrLengthList.get(i)) : inputValue.length();
                if (!inputValue.contains(WILDCARD) && substrIndex >= 0 && inputValue.length() >= substrIndex + substrLength) {
                    inputValueList.add(inputValue.substring(substrIndex, substrIndex + substrLength));
                    continue;
                }
                inputValueList.add(inputValue);
            }
            return inputValueList;
        }
        throw new PosMasterDataException("Input Parameter's Count[" + inputParams.length + "] and Condition's Count[" + condLayoutSeqList.size() + "] must be the same!!!");
    }

    private boolean checkEqual(List<String> sourceList, List<String> targetList) {
        boolean isEqual = true;
        if (sourceList.size() == targetList.size()) {
            for (int i = 0; i < sourceList.size(); ++i) {
                String target;
                String source = sourceList.get(i) != null ? sourceList.get(i) : "";
                String string = target = targetList.get(i) != null ? targetList.get(i) : "";
                if (source.equals(WILDCARD)) continue;
                if (source.contains(WILDCARD)) {
                    int start = source.indexOf(WILDCARD);
                    int end = source.lastIndexOf(WILDCARD);
                    int length = source.length();
                    if (start == 0 && end == length - 1) {
                        if (target.contains(source.substring(start + 1, end))) continue;
                        isEqual = false;
                    } else if (start == 0) {
                        if (target.endsWith(source.substring(start + 1))) continue;
                        isEqual = false;
                    } else if (end == length - 1) {
                        if (target.startsWith(source.substring(0, end))) continue;
                        isEqual = false;
                    } else {
                        if (start != end || start == 0) continue;
                        if (!target.startsWith(source.substring(0, start))) {
                            isEqual = false;
                        } else {
                            if (target.endsWith(source.substring(start + 1))) continue;
                            isEqual = false;
                        }
                    }
                } else {
                    if (source.equals(target)) continue;
                    isEqual = false;
                }
                break;
            }
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    private boolean checkLogic(List<String> sourceList, List<String> targetList, List<String> operatorList) {
        boolean isTrue = true;
        if (sourceList.size() == targetList.size() && sourceList.size() == operatorList.size()) {
            for (int i = 0; i < sourceList.size(); ++i) {
                String strSource = sourceList.get(i) != null ? sourceList.get(i) : "";
                String strTarget = targetList.get(i) != null ? targetList.get(i) : "";
                String operator = operatorList.get(i);
                if (!strSource.contains(WILDCARD) && !(isTrue = PosMasterUtil.checkLogic(strSource, strTarget, operator))) break;
            }
        }
        return isTrue;
    }

    private boolean checkLogic(List<String> valueList, List<String> compare1List, List<String> compare2List, List<String> operatorList) {
        boolean isTrue = true;
        for (int i = 0; i < valueList.size(); ++i) {
            String strValue = valueList.get(i) != null ? valueList.get(i) : "";
            String strComp1 = compare1List.get(i) != null ? compare1List.get(i) : "";
            String strComp2 = compare2List.get(i) != null ? compare2List.get(i) : "";
            String operator = operatorList.get(i);
            if (strValue.contains(WILDCARD)) continue;
            isTrue &= PosMasterUtil.checkLogic(strValue, strComp1, strComp2, operator);
        }
        return isTrue;
    }

    private boolean checkLogic(List<String> inputValueList, String condition) {
        HashMap<String, String> inputValueMap = new HashMap<String, String>();
        for (int i = 1; i <= inputValueList.size(); ++i) {
            inputValueMap.put("V" + i, inputValueList.get(i - 1));
        }
        List<String> tokenList = PosMasterUtil.tokenize(condition, "()+-*/><=!, ");
        String whereClause = PosMasterUtil.makeWhereClause(tokenList, inputValueMap);
        List<String> paramList = PosMasterUtil.makeWhereClauseParameter(tokenList, inputValueMap);
        GlueParameter param = new GlueParameter();
        param.setParameter(paramList);
        List resultList = this.m_dao.find("ACCESS_CHECK_BUSINESS_RULE", whereClause, param);
        return resultList != null && resultList.size() > 0;
    }

    protected class BizRuleData
    extends HashMap<String, Map<String, String>> {
        private static final long serialVersionUID = 1504566050430325169L;

        protected BizRuleData() {
        }

        public List<String> getDataList(List<String> layoutSeqList, String ... attrNames) {
            ArrayList<String> dataList = new ArrayList<String>(layoutSeqList.size());
            for (String layoutSeq : layoutSeqList) {
                Map dataMap = (Map)this.get(layoutSeq);
                if (dataMap != null) {
                    if (attrNames.length > 1) {
                        LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>(attrNames.length);
                        for (String attrName : attrNames) {
                            String data = (String)dataMap.get(attrName);
                            if (data != null && attrName.equals(PosBusinessRuleInfo.OPER_TP)) {
                                data = PosMasterAccessConstants.OPERATOR2.valueOf(data).toString();
                            }
                            attrMap.put(attrName, data);
                        }
                        dataList.add(((Object)attrMap).toString());
                        continue;
                    }
                    dataList.add((String)dataMap.get(attrNames[0]));
                    continue;
                }
                dataList.add("");
            }
            return dataList;
        }

        public String getData(String layoutSeq, String attrName) {
            String data = "";
            Map dataMap = (Map)this.get(layoutSeq);
            if (dataMap != null) {
                data = (String)dataMap.get(attrName);
            }
            return data;
        }
    }

    protected class BizRuleDataInfo
    extends LinkedHashMap<String, BizRuleData> {
        private static final long serialVersionUID = 8113489767475806097L;

        protected BizRuleDataInfo() {
        }
    }

    protected class BizRuleLayout
    extends HashMap<String, String> {
        private static final long serialVersionUID = 8499830448659431493L;

        protected BizRuleLayout() {
        }

        public boolean isCondition() {
            return ((String)this.get(PosBusinessRuleInfo.COND_YN)).equals("Y");
        }
    }

    protected class BizRuleLayoutInfo
    extends HashMap<String, BizRuleLayout> {
        private static final long serialVersionUID = 8499830448659431493L;
        private final List<String> m_condLayoutSeqList;
        private final List<String> m_rsltLayoutSeqList;

        public BizRuleLayoutInfo() {
            this.m_condLayoutSeqList = new ArrayList<String>();
            this.m_rsltLayoutSeqList = new ArrayList<String>();
        }

        public BizRuleLayoutInfo(int capacity) {
            super(capacity);
            this.m_condLayoutSeqList = new ArrayList<String>();
            this.m_rsltLayoutSeqList = new ArrayList<String>();
        }

        @Override
        public BizRuleLayout put(String layoutSeq, BizRuleLayout layout) {
            if (layout.isCondition()) {
                this.m_condLayoutSeqList.add(layoutSeq);
            } else {
                this.m_rsltLayoutSeqList.add(layoutSeq);
            }
            return super.put(layoutSeq, layout);
        }

        public List<String> getCondLayoutSeqList() {
            return this.m_condLayoutSeqList;
        }

        public List<String> getRsltLayoutSeqList() {
            return this.m_rsltLayoutSeqList;
        }

        public List<String> getLayoutSeqList() {
            ArrayList<String> layoutSeqList = new ArrayList<String>(this.size());
            layoutSeqList.addAll(this.m_condLayoutSeqList);
            layoutSeqList.addAll(this.m_rsltLayoutSeqList);
            return layoutSeqList;
        }

        public String getItemID(String layoutSeq) {
            return (String)((BizRuleLayout)this.get(layoutSeq)).get(PosBusinessRuleInfo.STD_ID);
        }

        public List<String> getItemIDList(List<String> layoutSeqList) {
            return this.getLayoutAttrList(PosBusinessRuleInfo.STD_ID, layoutSeqList);
        }

        public List<String> getLayoutAttrList(String attrName, List<String> layoutSeqList) {
            ArrayList<String> attrList = new ArrayList<String>(layoutSeqList.size());
            for (String layoutSeq : layoutSeqList) {
                attrList.add((String)((BizRuleLayout)this.get(layoutSeq)).get(attrName));
            }
            return attrList;
        }
    }
}

