/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access.common;

public class PosMasterAccessConstants {
    public static final String CACHE_KEY_SEPARATOR = "/";
    public static final String QUERY_SELECT_MASTER_COMMON_MAX_VERSION = "ACCESS_SELECT_MASTER_COMMON_MAX_VERSION";
    public static final String QUERY_SELECT_MASTER_COMMON = "ACCESS_SELECT_MASTER_COMMON";
    public static final String QUERY_SELECT_MASTER_CODE = "ACCESS_SELECT_MASTER_CODE";
    public static final String QUERY_SELECT_BUSINESS_RULE_LAYOUT = "ACCESS_SELECT_BUSINESS_RULE_LAYOUT";
    public static final String QUERY_SELECT_BUSINESS_RULE_DATA = "ACCESS_SELECT_BUSINESS_RULE_DATA";
    public static final String QUERY_CHECK_BUSINESS_RULE = "ACCESS_CHECK_BUSINESS_RULE";
    public static final String QUERY_CHECK_CALCULATION_RULE = "ACCESS_CHECK_CALCULATION_RULE";
    public static final String QUERY_SELECT_CALCULATION_ITEM = "ACCESS_SELECT_CALCULATION_ITEM";
    public static final String QUERY_SELECT_CALCULATION_FACTOR = "ACCESS_SELECT_CALCULATION_FACTOR";
    public static final String QUERY_SELECT_CALCULATION_FORMULA = "ACCESS_SELECT_CALCULATION_FORMULA";
    public static final String QUERY_SELECT_CALCULATION_INOUT = "ACCESS_SELECT_CALCULATION_INOUT";
    public static final String QUERY_SELECT_INTERFACE_TC = "ACCESS_SELECT_INTERFACE_TC";
    public static final String QUERY_SELECT_INTERFACE_LAYOUT = "ACCESS_SELECT_INTERFACE_LAYOUT";
    public static final String QUERY_SELECT_INTERFACE_TC_CHECK = "ACCESS_SELECT_INTERFACE_TC_CHECK";
    public static final String CALCULATION = "#CALCULATION#";
    public static final String MIGRATION_SYNC_CACHE = "SYNC_CACHE";
    public static final String MAJOR_VERSION = "2";
    public static final String MINOR_VERSION = "3";
    public static final String MASTER_VERSION = "Glue Master 2.3.1";

    private PosMasterAccessConstants() {
    }

    public static enum MasterRegions {
        MASTER_CODE(MasterTypes.MC, "master-code-region"),
        BUSINESS_RULE(MasterTypes.BR, "business-rule-region"),
        CALCULATION_RULE(MasterTypes.CR, "calculation-rule-region"),
        INTERFACE_FORMAT(MasterTypes.IF, "interface-format-region");

        private MasterTypes m_masterType;
        private String m_regionName;

        private MasterRegions(MasterTypes masterType, String regionName) {
            this.m_masterType = masterType;
            this.m_regionName = regionName;
        }

        public MasterTypes getMasterType() {
            return this.m_masterType;
        }

        public String getRegionName() {
            return this.m_regionName;
        }

        public static MasterRegions getRegion(String regionName) {
            if (regionName == null) {
                throw new IllegalArgumentException();
            }
            for (MasterRegions region : MasterRegions.values()) {
                if (!regionName.equals(region.getRegionName())) continue;
                return region;
            }
            throw new IllegalArgumentException();
        }

        public static MasterRegions getRegion(MasterTypes masterType) {
            if (masterType == null) {
                throw new IllegalArgumentException();
            }
            for (MasterRegions region : MasterRegions.values()) {
                if (!masterType.equals((Object)region.getMasterType())) continue;
                return region;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum ItemTypes {
        IT,
        GR,
        GI;

    }

    public static enum ProcessTypes {
        VA,
        FC,
        RT,
        SE;

    }

    public static enum ApproximateTypes {
        RU,
        CE,
        FL,
        KR,
        JR;

    }

    public static enum OPERATOR2 {
        DE("DEFAULT"),
        EQ("=="),
        NE("!="),
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">="),
        AB("<= BETWEEN <="),
        RB("< BETWEEN <="),
        LB("<= BETWEEN <"),
        NB("< BETWEEN <"),
        AL("% LIKE %"),
        RL("LIKE %"),
        LL("% LIKE"),
        IN("IN"),
        NI("NOT IN"),
        NN("NOT NULL"),
        NU("IS NULL");

        private String m_desc;

        private OPERATOR2(String desc) {
            this.m_desc = desc;
        }

        public String toString() {
            return this.m_desc;
        }
    }

    public static enum OPERATOR1 {
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">=");

        private String m_desc;

        private OPERATOR1(String desc) {
            this.m_desc = desc;
        }

        public String toString() {
            return this.m_desc;
        }
    }

    public static enum CalculationRuleTypes {
        SF("Simple Formula"),
        CF("Conditional Formula");

        private String m_desc;

        private CalculationRuleTypes(String desc) {
            this.m_desc = desc;
        }

        public String getDesc() {
            return this.m_desc;
        }
    }

    public static enum BusinessRuleTypes {
        SG("Simple General"),
        MG("Matrix General"),
        CG("Conditional General"),
        SC("Simle Condition"),
        RC("Relative Condition");

        private String m_desc;

        private BusinessRuleTypes(String desc) {
            this.m_desc = desc;
        }

        public String getDesc() {
            return this.m_desc;
        }
    }

    public static enum MasterCodeTypes {
        SC("Simple Code"),
        RC("Range Code"),
        CC("Combination Code");

        private String m_desc;

        private MasterCodeTypes(String desc) {
            this.m_desc = desc;
        }

        public String getDesc() {
            return this.m_desc;
        }
    }

    public static enum MasterTypes {
        MC("Master Code"),
        BR("Business Rule"),
        CR("Calculation Rule"),
        IF("Interface Format");

        private String m_desc;

        private MasterTypes(String desc) {
            this.m_desc = desc;
        }

        public String getDesc() {
            return this.m_desc;
        }
    }
}

