/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.app.glue.master.access;

import com.poscoict.app.glue.master.access.manager.PosMasterDataManager;
import com.poscoict.app.glue.master.access.util.license.LicenseManager;
import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.util.license.GlueSolution;
import com.poscoict.glueframework.util.log.GlueLog;
import com.poscoict.glueframework.util.log.GlueLogFactory;
import com.poscoict.license.LicenseAPI;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PosMasterDataFactory {
    private static final GlueLog m_logger = GlueLogFactory.getLogger(PosMasterDataFactory.class);
    private static PosMasterDataFactory m_factory = new PosMasterDataFactory();
    private final PosMasterDataManager m_masterManager = this.initializeManager();
    private static final String ACCESS_CONFIG_LOCATION = "glue-master-access.xml";
    private static final String MASTER_MANAGER_BEAN_NAME = "masterDataManager";

    private PosMasterDataFactory() {
    }

    private final PosMasterDataManager initializeManager() {
        m_logger.info("Access API Version : {}-RELEASE", (Object)"Glue Master 2.3.1");
        PosMasterDataManager manager = null;
        ClassPathXmlApplicationContext accessContext = null;
        try {
            GlueSolution.set((LicenseAPI.Solution)LicenseAPI.Solution.GlueMaster);
            accessContext = new ClassPathXmlApplicationContext(ACCESS_CONFIG_LOCATION);
            manager = (PosMasterDataManager)accessContext.getBean(MASTER_MANAGER_BEAN_NAME, PosMasterDataManager.class);
        }
        catch (BeansException be) {
            throw new GlueException("Critical warning; Fail to get MasterDataManager - " + be.getMessage(), (Throwable)be);
        }
        m_logger.info("Master Data Manager is initialized successfully...");
        return manager;
    }

    public static PosMasterDataManager getManager() {
        LicenseManager.checkLicenseMode();
        return PosMasterDataFactory.m_factory.m_masterManager;
    }
}

