function analyzeCode(code) {
    var ast = esprima.parse(code);
    estraverse.traverse(ast, {
        enter: function(node) { 
            if (${isView} && node.type === 'Property' && node.key.name == 'views') {
                node.value.elements.push({type:'Literal', value: '${viewName}', raw:'\'${viewName}\''});
            }

            if (${isModel} && node.type === 'Property' && node.key.name == 'models') {
                node.value.elements.push({type:'Literal', value: '${modelName}', raw:'\'${modelName}\''});
            }

            if (${isCollection} && node.type === 'Property' && node.key.name == 'collections') {
                node.value.elements.push({type:'Literal', value: '${collectionName}', raw:'\'${collectionName}\''});
            }

            if (${isTemplate} && node.type === 'Property' && node.key.name == 'templates') {
                node.value.elements.push({type:'Literal', value: '${templateName}', raw:'\'${templateName}\''});
            }

            if (${isPage} && node.type === 'Property' && node.key.name == 'appRoutes') {
                var properties = node.value.properties;
                //properties.push({ type: 'Property', key: { type: 'Literal', value: '${pageName}', raw: '\'${pageName}\'' }, value: { type: 'Literal', value: '${functionName}', raw: '\'${functionName}\'' }, kind: 'init' });
                properties.splice(properties.length-1, 0, { type: 'Property', key: { type: 'Literal', value: '${pageName}', raw: '\'${pageName}\'' }, value: { type: 'Literal', value: '${functionName}', raw: '\'${functionName}\'' }, kind: 'init' });
            }

            if (${isEvent} && node.type === 'Property' && node.key.name == 'appEvents') {
                var properties = node.value.properties;
                properties.push({ type: 'Property', key: { type: 'Literal', value: '${eventType}:${tagId}', raw: '\'${eventType}:${tagId}\'' }, value: { type: 'Literal', value: '${functionName}', raw: '\'${functionName}\'' }, kind: 'init' });
            }
        }
    });
    return escodegen.generate(ast);
}