var gulp = require("gulp");

// What Plumber does is catches errors and prevents the pipe from breaking
var plumber = require('gulp-plumber');
// combine multiple javascript files into one js file to reduce the number of network requests
var concat = require('gulp-concat');
// spinning up a web server that helps us do live-reloading easily
var browserSync = require('browser-sync').create();
// optimize the size of images
var imagemin = require('gulp-imagemin');
// optimizing images takes a lot of time so it would be better to cache them after process
var cache = require('gulp-cached');
// clean files in the selected directory
var del = require('del');
// call the arguments in order
var runSequence = require('run-sequence');
var htmlmin = require('gulp-htmlmin');
// js minification
var uglify = require('gulp-uglify');
var pump = require('pump');
// sourcemaps
var sourcemaps = require('gulp-sourcemaps');
// log the size of files
var size = require('gulp-size');

gulp.task('html-minify', function() {
  return gulp.src('templates/*.html')
    .pipe(sourcemaps.init())
    .pipe(size({title: 'x-minified-html'}))
    .pipe(htmlmin({
      removeComments: true,
      collapseWhitespace: true,
      collapseBooleanAttributes: true,
      removeAttributeQuotes: true,
      removeRedundantAttributes: true,
      removeEmptyAttributes: true,
      removeScriptTypeAttributes: true,
      removeStyleLinkTypeAttributes: true,
      removeOptionalTags: true
    }))
    .pipe(gulp.dest('dist/templates'))
    .pipe(size({title: 'o-minified-html'}));
});

gulp.task('js-minify', function (cb) {
  return gulp.src('js/*.js')
    .pipe(sourcemaps.init())
    .pipe(size({title: 'x-minified-js'}))
    .pipe(uglify({preserveComments: 'some'}))
    .pipe(size({title: 'o-minified-js'}))
    .pipe(gulp.dest('dist/js'));
});

// gulp.task('js-libs-concat', function() {
// 	return gulp.src('js/libs/*.js')
// 		.pipe(concat('concated-lib.js'))
// 		.pipe(gulp.dest('dist/js'));
// });

gulp.task('images', function(){
  return gulp.src('images/**/*.+(png|jpg|gif|svg)')
  .pipe(sourcemaps.init())
  .pipe(size({title: 'x-compressed-images'}))
  .pipe(cache(imagemin({
		// show the picture in low resolution and make it progressively clear
		interlaced: true,
    progressive: true
	})))
  .pipe(size({title: 'o-compressed-images'}))
  .pipe(gulp.dest('dist/images'));
});

gulp.task('clean:dist', function() {
  return del.sync('dist/**.*');
});

gulp.task('build', [`clean:dist`, `html-minify`, `js-minify`, `images`], function (callback){
  console.log('Building files');
});

gulp.task('watch', ['browserSync'], function () {
	gulp.watch('js/**/*.js', ['js-optimization']);
	gulp.watch('templates/*.html', browserSync.reload);
  gulp.watch('css/**/*.css', browserSync.reload);
});

gulp.task('browserSync', function() {
  browserSync.init({
    server: {
      baseDir: ''
    },
  })
});

gulp.task('default', function (callback) {
  runSequence(['browserSync', 'watch'],
    callback
  )
});
