/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.util;

import com.poscoict.glueframework.plugin.activity.designer.GlueActivityDesignerPlugin;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;

public class GlueClassGenerator {
    private static String PACKAGE = "#PACKAGE#";
    private static String CLASS = "#CLASS#";

    public static boolean generateClass(String classFullName, String projectSourcePath) throws Exception {
        File classFile;
        String template = GlueActivityDesignerPlugin.getGlueConfigInfo().getActivityTemplate().trim();
        String packageName = classFullName.substring(0, classFullName.lastIndexOf("."));
        String className = classFullName.substring(classFullName.lastIndexOf(".") + 1);
        template = template.replaceAll(PACKAGE, packageName);
        template = template.replaceAll(CLASS, className);
        String fullPath = String.valueOf(projectSourcePath) + File.separator + packageName.replace('.', File.separatorChar);
        File packageDir = new File(fullPath);
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
        if (!(classFile = new File(String.valueOf(fullPath) + File.separator + className + ".java")).exists() && classFile.createNewFile()) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(classFile));
            bw.write(template);
            bw.close();
            return true;
        }
        return false;
    }

    public static boolean checkReusableClass(String classFullName) {
        boolean isReuseClass = false;
        List excludePackageList = GlueActivityDesignerPlugin.getGlueConfigInfo().getExcludePackageList();
        if (classFullName != null && classFullName.indexOf("com.poscoict.glueframework") == -1) {
            for (String excludePackage : excludePackageList) {
                if (classFullName.indexOf(excludePackage) == -1) continue;
                isReuseClass = true;
                break;
            }
        } else {
            isReuseClass = true;
        }
        return isReuseClass;
    }
}

