/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.rulers;

import com.poscoict.glueframework.plugin.activity.designer.model.commands.GlueCreateGuideCommand;
import com.poscoict.glueframework.plugin.activity.designer.model.commands.GlueDeleteGuideCommand;
import com.poscoict.glueframework.plugin.activity.designer.model.commands.GlueMoveGuideCommand;
import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.activity.model.impl.GlueGuide;
import com.poscoict.glueframework.plugin.activity.model.impl.GlueRuler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;

public class GlueRulerProvider
extends RulerProvider {
    private final GlueRuler ruler;
    private final PropertyChangeListener rulerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("children changed")) {
                GlueGuide guide = (GlueGuide)evt.getNewValue();
                if (GlueRulerProvider.this.getGuides().contains(guide)) {
                    guide.addPropertyChangeListener(GlueRulerProvider.this.guideListener);
                } else {
                    guide.removePropertyChangeListener(GlueRulerProvider.this.guideListener);
                }
                for (Object listener : GlueRulerProvider.this.listeners) {
                    ((RulerChangeListener)listener).notifyGuideReparented((Object)guide);
                }
            } else {
                for (Object listener : GlueRulerProvider.this.listeners) {
                    ((RulerChangeListener)listener).notifyUnitsChanged(GlueRulerProvider.this.ruler.getUnit());
                }
            }
        }
    };
    private final PropertyChangeListener guideListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("subparts changed")) {
                for (Object listener : GlueRulerProvider.this.listeners) {
                    ((RulerChangeListener)listener).notifyPartAttachmentChanged(event.getNewValue(), event.getSource());
                }
            } else {
                for (Object listener : GlueRulerProvider.this.listeners) {
                    ((RulerChangeListener)listener).notifyGuideMoved(event.getSource());
                }
            }
        }
    };

    public GlueRulerProvider(GlueRuler ruler) {
        this.ruler = ruler;
        ruler.addPropertyChangeListener(this.rulerListener);
        for (GlueGuide glueGuide : this.getGuides()) {
            glueGuide.addPropertyChangeListener(this.guideListener);
        }
    }

    public List<GlueSubpart> getAttachedModelObjects(Object guide) {
        return new ArrayList<GlueSubpart>(((GlueGuide)guide).getParts());
    }

    public Command getCreateGuideCommand(int position) {
        return new GlueCreateGuideCommand(this.ruler, position);
    }

    public Command getDeleteGuideCommand(Object guide) {
        return new GlueDeleteGuideCommand(this.ruler, (GlueGuide)guide);
    }

    public Command getMoveGuideCommand(Object guide, int pDelta) {
        return new GlueMoveGuideCommand((GlueGuide)guide, pDelta);
    }

    public int[] getGuidePositions() {
        List<GlueGuide> guides = this.getGuides();
        int[] result = new int[guides.size()];
        int i = 0;
        while (i < guides.size()) {
            result[i] = guides.get(i).getPosition();
            ++i;
        }
        return result;
    }

    public Object getRuler() {
        return this.ruler;
    }

    public int getUnit() {
        return this.ruler.getUnit();
    }

    public void setUnit(int newUnit) {
        this.ruler.setUnit(newUnit);
    }

    public int getGuidePosition(Object guide) {
        return ((GlueGuide)guide).getPosition();
    }

    public List<GlueGuide> getGuides() {
        return this.ruler.getGuides();
    }
}

