/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.preferences;

import com.poscoict.glueframework.plugin.activity.designer.GlueActivityDesignerPlugin;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GlueCellModifier;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GluePropertyTask;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GlueTableLabelProvider;
import com.poscoict.glueframework.schema.plugin.config.parser.GlueConfigInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GlueActivityPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static Map<String, Map<String, String>> activityPreferenceMap = new LinkedHashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> tempPreferenceMap = new LinkedHashMap<String, Map<String, String>>();
    private ListViewer listViewer;
    private TableViewer tableViewer;
    private String previousActivityName;

    static {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("class", "package");
        activityPreferenceMap.put("Custom", propertyMap);
        List activityInfoList = GlueActivityDesignerPlugin.getGlueConfigInfo().getActivityInfoList();
        if (activityInfoList != null) {
            for (GlueConfigInfo.GlueActivityInfo activityInfo : activityInfoList) {
                LinkedHashMap propertiesMap = new LinkedHashMap();
                propertiesMap.putAll(activityInfo.getPropertiesMap());
                activityPreferenceMap.put(activityInfo.getName(), propertiesMap);
            }
        }
    }

    public GlueActivityPreferencePage() {
        super.setDescription("Activity Preference property :");
        this.tempPreferenceMap.clear();
        this.tempPreferenceMap.putAll(activityPreferenceMap);
    }

    public static Map<String, Map<String, String>> getActivityPreferenceMap() {
        return activityPreferenceMap;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label activityLabel = new Label(composite, 64);
        activityLabel.setText("Activity List");
        activityLabel.setFont(parent.getFont());
        Label activityProperty = new Label(composite, 64);
        activityProperty.setText("Activity Property");
        activityProperty.setFont(parent.getFont());
        this.makeActivityListViewer(composite);
        this.makePropertyTableViewer(composite);
        composite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent event) {
                GlueActivityPreferencePage.this.resizeTableColumn();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.listViewer.setSelection((ISelection)new StructuredSelection(this.listViewer.getElementAt(0)));
        return composite;
    }

    protected void performDefaults() {
        super.updateApplyButton();
        this.previousActivityName = null;
        this.tempPreferenceMap.clear();
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("class", "package");
        this.tempPreferenceMap.put("Custom", propertyMap);
        for (GlueConfigInfo.GlueActivityInfo activityInfo : GlueActivityDesignerPlugin.getGlueConfigInfo().getActivityInfoList()) {
            LinkedHashMap propertiesMap = new LinkedHashMap();
            propertiesMap.putAll(activityInfo.getPropertiesMap());
            this.tempPreferenceMap.put(activityInfo.getName(), propertiesMap);
        }
        this.listViewer.setSelection((ISelection)new StructuredSelection(this.listViewer.getElementAt(0)));
    }

    public boolean performOk() {
        this.setActivityProperty(this.previousActivityName);
        activityPreferenceMap.clear();
        activityPreferenceMap.putAll(this.tempPreferenceMap);
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    private void makeActivityListViewer(Composite composite) {
        this.listViewer = new ListViewer(composite, 2816);
        GridData gridData = new GridData(1040);
        gridData.heightHint = 200;
        this.listViewer.getControl().setLayoutData((Object)gridData);
        this.listViewer.setUseHashlookup(true);
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return ((Set)inputElement).toArray();
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (GlueActivityPreferencePage.this.previousActivityName != null) {
                    GlueActivityPreferencePage.this.setActivityProperty(GlueActivityPreferencePage.this.previousActivityName);
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                String activityName = (String)selection.getFirstElement();
                GlueActivityPreferencePage.this.setTableViewerProperty(activityName);
                GlueActivityPreferencePage.this.previousActivityName = activityName;
            }
        });
        this.listViewer.setInput(this.tempPreferenceMap.keySet());
    }

    private void makePropertyTableViewer(Composite composite) {
        Composite propertyComposite = new Composite(composite, 0);
        propertyComposite.setLayout((Layout)new GridLayout());
        propertyComposite.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(propertyComposite, 68388);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 100;
        gridData.minimumWidth = 400;
        table.setLayoutData((Object)gridData);
        this.tableViewer.setColumnProperties(new String[]{"Name", "Value"});
        TableColumn nameColumn = new TableColumn(table, 0x1000000);
        nameColumn.setText("Name");
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText("Value");
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setCellModifier((ICellModifier)new GlueCellModifier(true));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new GlueTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonComposite = new Composite(propertyComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, true));
        buttonComposite.setLayoutData((Object)new GridData(768));
        Button addRowButton = new Button(buttonComposite, 8);
        addRowButton.setText("Add");
        addRowButton.setLayoutData((Object)new GridData(768));
        addRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GlueActivityPreferencePage.this.tableViewer.add((Object)new GluePropertyTask("", ""));
                GlueActivityPreferencePage.this.tableViewer.getTable().select(GlueActivityPreferencePage.this.tableViewer.getTable().getItemCount() - 1);
            }
        });
        Button deleteRowButton = new Button(buttonComposite, 8);
        deleteRowButton.setText("Delete");
        deleteRowButton.setLayoutData((Object)new GridData(768));
        deleteRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = 0;
                while (i < GlueActivityPreferencePage.this.tableViewer.getTable().getItemCount()) {
                    if (GlueActivityPreferencePage.this.tableViewer.getTable().getItem(i).getChecked()) {
                        GlueActivityPreferencePage.this.tableViewer.getTable().remove(i);
                        i = -1;
                    }
                    ++i;
                }
            }
        });
    }

    private void setTableViewerProperty(String activityName) {
        if (this.tableViewer != null) {
            Map<String, String> propertyMap = this.tempPreferenceMap.get(activityName);
            this.tableViewer.getTable().removeAll();
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                this.tableViewer.add((Object)new GluePropertyTask(entry.getKey(), entry.getValue()));
            }
            this.resizeTableColumn();
        }
    }

    private void setActivityProperty(String activityName) {
        if (this.tableViewer != null) {
            LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
            int i = 0;
            while (i < this.tableViewer.getTable().getItemCount()) {
                GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
                propertyMap.put(task.getName(), task.getValue());
                ++i;
            }
            this.tempPreferenceMap.put(activityName, propertyMap);
        }
    }

    private void resizeTableColumn() {
        this.tableViewer.getTable().getColumn(0).pack();
        int tableWidth = this.tableViewer.getTable().getSize().x;
        if (tableWidth == 0) {
            tableWidth = 400;
        }
        int tableInnerWidth = tableWidth - 2 * this.tableViewer.getTable().getBorderWidth();
        int barWidth = this.tableViewer.getTable().getVerticalBar().getSize().x;
        int nameColumnWidth = this.tableViewer.getTable().getColumn(0).getWidth();
        if (this.tableViewer.getTable().getVerticalBar().isVisible()) {
            this.tableViewer.getTable().getColumn(1).setWidth(tableInnerWidth - barWidth - nameColumnWidth);
        } else {
            this.tableViewer.getTable().getColumn(1).setWidth(tableInnerWidth - nameColumnWidth);
        }
    }
}

