/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.model.commands;

import com.poscoict.glueframework.plugin.activity.designer.GlueActivityDesignerPlugin;
import com.poscoict.glueframework.plugin.activity.designer.util.GlueClassGenerator;
import com.poscoict.glueframework.plugin.activity.model.GlueActivity;
import com.poscoict.glueframework.plugin.activity.model.GlueDiagram;
import com.poscoict.glueframework.plugin.activity.model.GlueFinalState;
import com.poscoict.glueframework.plugin.activity.model.GlueInitialState;
import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.activity.model.GlueWire;
import com.poscoict.glueframework.plugin.project.startup.GlueProjectPlugin;
import com.poscoict.glueframework.plugin.project.startup.util.GlueEclipseProjectUtil;
import com.poscoict.glueframework.schema.service.parser.GlueServiceInfo;
import com.poscoict.glueframework.schema.service.parser.GlueServiceParser;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class GlueGenerateServiceCommand
extends Command {
    private final GlueDiagram diagram;
    private String selectedDirectory;
    private String serviceName;
    private String projectName;

    public GlueGenerateServiceCommand(GlueDiagram diagram) {
        this.diagram = diagram;
    }

    public void setSelectedDirectory(String selectedDirectory) {
        this.selectedDirectory = selectedDirectory;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void execute() {
        GlueServiceParser parser = GlueServiceParser.getInstance();
        try {
            boolean isCreate;
            if (this.serviceName == null) {
                throw new Exception("serviceName is null");
            }
            String fileName = this.serviceName;
            if (!fileName.endsWith("service")) {
                fileName = "-service";
            }
            GlueServiceInfo serviceInfo = this.makeServiceInfo((List<GlueSubpart>)this.diagram.getChildren(), this.diagram.getTransactionMap());
            parser.makeXml(new File(String.valueOf(this.selectedDirectory) + File.separator + fileName + ".xml"), serviceInfo);
            boolean doConfirm = GlueProjectPlugin.getDefault().getPreferenceStore().getBoolean("GLUE_CONFIRM_CLASS_GENERATE");
            if (doConfirm && (isCreate = MessageDialog.openQuestion((Shell)new Shell(), (String)"Activity Class Generator", (String)"Do you generate all Classes in this Service?"))) {
                this.generateActivityClass((List<GlueSubpart>)this.diagram.getChildren());
                GlueEclipseProjectUtil.getProject((String)this.projectName).refreshLocal(2, null);
            }
            MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell());
            dialog.setMessage("Glue Service File[" + fileName + ".xml] has been generated.");
            dialog.open();
        }
        catch (Exception e) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, e.getMessage(), (Throwable)e);
            CoreException ce = new CoreException((IStatus)status);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error During generating service", (String)"Glue Error", (IStatus)ce.getStatus());
            GlueActivityDesignerPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private GlueServiceInfo makeServiceInfo(List<GlueSubpart> subpartList, Map<String, String> transactionMap) {
        String initActivityName = "";
        for (GlueSubpart glueSubpart : subpartList) {
            if (!(glueSubpart instanceof GlueInitialState)) continue;
            GlueSubpart nextSubpart = ((GlueWire)glueSubpart.getSourceConnections().get(0)).getTarget();
            if (nextSubpart instanceof GlueFinalState) {
                initActivityName = "end";
                break;
            }
            if (!(nextSubpart instanceof GlueActivity)) break;
            initActivityName = ((GlueActivity)nextSubpart).getName();
            break;
        }
        GlueServiceInfo serviceInfo = new GlueServiceInfo(this.serviceName, initActivityName);
        for (GlueSubpart glueSubpart : subpartList) {
            if (!(glueSubpart instanceof GlueActivity)) continue;
            String activityName = ((GlueActivity)glueSubpart).getName();
            String className = ((GlueActivity)glueSubpart).getClassName();
            serviceInfo.addActivityInfo(activityName, className);
            String targetName = "";
            for (GlueWire wire : glueSubpart.getSourceConnections()) {
                targetName = wire.getTarget() instanceof GlueFinalState ? "end" : (wire.getTarget() instanceof GlueActivity ? ((GlueActivity)wire.getTarget()).getName() : "");
                serviceInfo.putActivityTransition(activityName, wire.getWireGuardConditionContents(), targetName);
            }
            for (Map.Entry entry : ((GlueActivity)glueSubpart).getPropertyMap().entrySet()) {
                if ("description".equals(entry.getKey())) continue;
                serviceInfo.putActivityProperty(activityName, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (Map.Entry entry : transactionMap.entrySet()) {
            if ("description".equals(entry.getKey())) continue;
            serviceInfo.putTransaction((String)entry.getKey(), Boolean.parseBoolean((String)entry.getValue()));
        }
        return serviceInfo;
    }

    private void generateActivityClass(List<GlueSubpart> activityList) throws Exception {
        for (GlueSubpart glueSubpart : activityList) {
            String className;
            if (!(glueSubpart instanceof GlueActivity) || (className = ((GlueActivity)glueSubpart).getClassName()) == null || GlueClassGenerator.checkReusableClass(className.trim())) continue;
            GlueClassGenerator.generateClass(className, (String)GlueEclipseProjectUtil.getProjectSourcePathList((String)this.projectName).get(0));
        }
    }
}

