/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.model.commands;

import com.poscoict.glueframework.plugin.activity.designer.GlueActivityDesignerPlugin;
import com.poscoict.glueframework.plugin.activity.model.GlueActivity;
import com.poscoict.glueframework.plugin.activity.model.GlueDiagram;
import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.project.startup.util.GlueEclipseProjectUtil;
import com.poscoict.glueframework.schema.plugin.config.parser.GlueConfigInfo;
import com.poscoict.glueframework.schema.query.parser.GlueQueryMapInfo;
import com.poscoict.glueframework.schema.query.parser.GlueQueryParser;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GlueGenerateDocumentCommand
extends Command {
    private final GlueDiagram diagram;
    private String selectedDirectory;
    private String serviceName;
    private String projectName;

    public GlueGenerateDocumentCommand(GlueDiagram diagram) {
        this.diagram = diagram;
    }

    public void setSelectedDirectory(String selectedDirectory) {
        this.selectedDirectory = selectedDirectory;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void execute() {
        try {
            if (this.serviceName == null) {
                throw new Exception("serviceName is null");
            }
            String fileName = this.serviceName;
            if (!fileName.endsWith("service")) {
                fileName = "-service";
            }
            EList activityList = this.diagram.getChildren();
            String serviceOverview = (String)this.diagram.getTransactionMap().get("description");
            File docFile = new File(String.valueOf(this.selectedDirectory) + File.separator + fileName + ".doc");
            if (docFile.exists()) {
                boolean reGenerate = MessageDialog.openQuestion((Shell)new Shell(), (String)"Service Document Generator", (String)("The file '" + fileName + ".doc" + "' already exist. Click OK to regenerate it."));
                if (reGenerate) {
                    this.generateDocument((List<GlueSubpart>)activityList, docFile, serviceOverview);
                }
            } else {
                this.generateDocument((List<GlueSubpart>)activityList, docFile, serviceOverview);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, e.getMessage(), (Throwable)e);
            CoreException ce = new CoreException((IStatus)status);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error During generating service document", (String)"Glue Error", (IStatus)ce.getStatus());
            GlueActivityDesignerPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private void generateDocument(List<GlueSubpart> activityList, File docFile, String serviceOverview) throws Exception {
        if (activityList != null) {
            GlueConfigInfo.DocumentInfo info = GlueActivityDesignerPlugin.getGlueConfigInfo().getDocumentInfo();
            String projectName = info.getProjectName();
            String phase = info.getPhase();
            String taskName = info.getTaskName();
            String serviceId = info.getServiceId();
            String currrentDate = info.getCurrentDate();
            String serviceBrief = info.getServiceBrief();
            String acitivitySubject = info.getActivitySubject();
            String activityDescription = info.getActivityDescription();
            String fileType = info.getFileType();
            StringBuffer docBuff = new StringBuffer();
            docBuff.append("<html>\n");
            docBuff.append("<head>\n");
            docBuff.append("<meta http-equiv='Content-Type' content='text/html; charset=" + fileType + "'>\n");
            docBuff.append("</head>\n");
            docBuff.append("    <body>\n");
            docBuff.append("<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>\n");
            docBuff.append("        <center><font size=7><b>Service Specification</b></font><br><br></center>\n");
            docBuff.append("    <p align='right'>\n");
            docBuff.append("    <table width='400' border=1 cellspacing='0' cellpadding='0' bordercolorlight='#666666' bordercolordark='#FFFFFF'>\n");
            docBuff.append("    \t<tr>\n");
            docBuff.append("    \t\t<td align='right'>" + projectName + "&nbsp;&nbsp;</td>\n");
            docBuff.append("    \t\t<td>&nbsp;</td>\n");
            docBuff.append("    \t</tr>\n");
            docBuff.append("    \t<tr>\n");
            docBuff.append("    \t\t<td align='right'>" + phase + "&nbsp;&nbsp;</td>\n");
            docBuff.append("    \t\t<td>&nbsp;</td>\n");
            docBuff.append("    \t</tr>\n");
            docBuff.append("    \t<tr>\n");
            docBuff.append("    \t\t<td align='right'>" + taskName + "&nbsp;&nbsp;</td>\n");
            docBuff.append("    \t\t<td>&nbsp;</td>\n");
            docBuff.append("    \t</tr>\n");
            docBuff.append("    \t<tr>\n");
            docBuff.append("    \t\t<td align='right'>" + serviceId + "&nbsp;&nbsp;</td>\n");
            docBuff.append("    \t\t<td>&nbsp;" + this.serviceName + "</td>\n");
            docBuff.append("    \t</tr>\n");
            docBuff.append("    \t<tr>\n");
            docBuff.append("    \t\t<td align='right'>" + currrentDate + "&nbsp;&nbsp;</td>\n");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            docBuff.append("    \t\t<td>&nbsp;" + format.format(new Date()) + "</td>\n");
            docBuff.append("    \t</tr>\n");
            docBuff.append("    </table>\n");
            docBuff.append("    </p><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>\n");
            docBuff.append("        <font size=6><b>Service Name : " + this.serviceName + " </b></font><br><br>\n");
            docBuff.append("&nbsp;&nbsp;        <font size=5><b>1. " + serviceBrief + " </b></font><br>\n");
            docBuff.append("                      <div style='margin-left:40px;' width='550'><xmp>\n");
            docBuff.append(serviceOverview);
            docBuff.append("                      </xmp></div>\n");
            docBuff.append("&nbsp;&nbsp;        <font size=5><b>2. Activity Diagram</b></font><br><br><br>\n");
            docBuff.append("&nbsp;&nbsp;&nbsp;&nbsp;        <font size=2 color='blue'><b>Please put the Activity Diagram Image!</b></font><br><br><br>\n");
            docBuff.append("&nbsp;&nbsp;        <font size=5><b>3. " + acitivitySubject + "</b></font><br><br>\n");
            int index = 1;
            GlueActivity activity = null;
            for (GlueSubpart glueSubpart : activityList) {
                if (!(glueSubpart instanceof GlueActivity)) continue;
                activity = (GlueActivity)glueSubpart;
                docBuff.append("&nbsp;&nbsp;        <font size=4><b>3." + index++ + " " + activity.getName() + "</b></font><br><br>\n");
                docBuff.append("&nbsp;&nbsp;&nbsp;        <font size=3>Properties:</font>\n");
                docBuff.append("        <table style='margin-left:40px;' width='550' border=1 cellspacing='0' cellpadding='0' bordercolorlight='#666666' bordercolordark='#FFFFFF'>\n");
                docBuff.append("            <tr height='20' bgcolor='lightgrey'>\n");
                docBuff.append("                <td align='center'>name</td>\n");
                docBuff.append("                <td align='center'>value</td>\n");
                docBuff.append("            </tr>\n");
                docBuff.append("            <tr height='20'>\n");
                docBuff.append("                <td align='center'>class</td>\n");
                docBuff.append("                <td>" + activity.getClassName() + "</td>\n");
                docBuff.append("            </tr>\n");
                Map propertyMap = activity.getPropertyMap();
                String key = null;
                String value = null;
                for (Map.Entry entry : propertyMap.entrySet()) {
                    key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    if ("description".equals(key) || "class".equals(key)) continue;
                    if ("sql-key".equals(key)) {
                        docBuff.append("            <tr height='20'>\n");
                        docBuff.append("                <td align='center'>" + key + "</td>\n");
                        docBuff.append("                <td><b>[" + value + "]</b><br>" + this.getQuery(value) + "</td>\n");
                        docBuff.append("            </tr>\n");
                        continue;
                    }
                    docBuff.append("            <tr height='20'>\n");
                    docBuff.append("                <td align='center'>" + key + "</td>\n");
                    docBuff.append("                <td>" + value + "</td>\n");
                    docBuff.append("            </tr>\n");
                }
                docBuff.append("        </table><br>\n");
                docBuff.append("&nbsp;&nbsp;&nbsp;       <font size=3>" + activityDescription + ":</font>\n");
                docBuff.append("        <table style='margin-left:40px;' width='550' border=1 cellspacing='0' cellpadding='0' bordercolorlight='#666666' bordercolordark='#FFFFFF'>\n");
                docBuff.append("            <tr>\n");
                docBuff.append("                <td>\n");
                docBuff.append("                    <xmp>\n");
                docBuff.append(activity.getProperty("description"));
                docBuff.append("                    </xmp>\n");
                docBuff.append("                </td>\n");
                docBuff.append("            </tr>\n");
                docBuff.append("        </table><br><br>\n");
            }
            docBuff.append("    </body>\n");
            docBuff.append("<html>\n");
            FileOutputStream fos = new FileOutputStream(docFile);
            try {
                fos.write(docBuff.toString().getBytes(fileType));
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    private String getQuery(String queryId) throws Exception {
        String query = "";
        List queryFileList = GlueEclipseProjectUtil.getFileList((String)"glue_sql", (String[])GlueEclipseProjectUtil.getProjectSourcePaths((String)this.projectName));
        for (String filePath : queryFileList) {
            GlueQueryMapInfo mapInfo = GlueQueryParser.getInstance().parseXml(new File(filePath));
            GlueQueryMapInfo.GlueQueryInfo queryInfo = (GlueQueryMapInfo.GlueQueryInfo)mapInfo.getQueryMap().get(queryId);
            if (queryInfo == null) continue;
            query = queryInfo.getSql();
            break;
        }
        return query;
    }
}

