/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.model.commands;

import com.poscoict.glueframework.plugin.activity.model.GlueDiagram;
import com.poscoict.glueframework.plugin.activity.model.GlueObject;
import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.activity.model.GlueWire;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class GlueDeleteCommand
extends Command {
    private GlueDiagram parent;
    private GlueSubpart child;
    private final List<GlueWire> sourceConnections = new ArrayList<GlueWire>();
    private final List<GlueWire> targetConnections = new ArrayList<GlueWire>();
    private int index = -1;

    public GlueDeleteCommand() {
        super("Delete GlueSubpart");
    }

    public void setParent(GlueDiagram parent) {
        this.parent = parent;
    }

    public void setChild(GlueSubpart child) {
        this.child = child;
    }

    public void execute() {
        this.parent.removeWireInChild(this.child);
        this.deleteConnections(this.child);
        this.parent.removeChild((GlueObject)this.child);
        this.index = this.parent.getChildren().indexOf((Object)this.child);
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.parent.addChild(this.child, this.index);
        this.restoreConnections();
    }

    private void deleteConnections(GlueSubpart part) {
        this.sourceConnections.addAll((Collection<GlueWire>)part.getSourceConnections());
        for (GlueWire wire : this.sourceConnections) {
            wire.detachSource();
            wire.detachTarget();
        }
        this.targetConnections.addAll((Collection<GlueWire>)part.getTargetConnections());
        for (GlueWire wire : this.targetConnections) {
            wire.detachSource();
            wire.detachTarget();
        }
    }

    private void restoreConnections() {
        for (GlueWire wire : this.sourceConnections) {
            if (!this.parent.getWires().contains((Object)wire)) {
                this.parent.getWires().add((Object)wire);
            }
            wire.attachSource();
            wire.attachTarget();
        }
        this.sourceConnections.clear();
        for (GlueWire wire : this.targetConnections) {
            if (!this.parent.getWires().contains((Object)wire)) {
                this.parent.getWires().add((Object)wire);
            }
            wire.detachSource();
            wire.detachTarget();
        }
        this.targetConnections.clear();
    }
}

