/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.model.commands;

import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.activity.model.GlueWire;
import org.eclipse.gef.commands.Command;

public class GlueConnectionCommand
extends Command {
    private GlueSubpart oldSource;
    private GlueSubpart oldTarget;
    private GlueSubpart source;
    private GlueSubpart target;
    private GlueWire wire;

    public GlueConnectionCommand() {
        super("Wire Connection");
    }

    public void execute() {
        if (this.source != null) {
            this.wire.detachSource();
            this.wire.setSource(this.source);
            this.wire.attachSource();
            this.wire.setGlueDiagram(this.source.getGlueDiagram());
        }
        if (this.target != null) {
            this.wire.detachTarget();
            this.wire.setTarget(this.target);
            this.wire.attachTarget();
            this.wire.setGlueDiagram(this.target.getGlueDiagram());
        }
        if (this.source == null && this.target == null) {
            this.wire.detachSource();
            this.wire.detachTarget();
            this.wire.setTarget(null);
            this.wire.setSource(null);
            this.wire.getGlueDiagram().getWires().remove((Object)this.wire);
        }
    }

    public String getLabel() {
        return "Connection Change";
    }

    public void setSource(GlueSubpart newSource) {
        this.source = newSource;
    }

    public void setTarget(GlueSubpart newTarget) {
        this.target = newTarget;
    }

    public void setWire(GlueWire wire) {
        this.wire = wire;
        this.oldSource = wire.getSource();
        this.oldTarget = wire.getTarget();
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.source = this.wire.getSource();
        this.target = this.wire.getTarget();
        this.wire.detachSource();
        this.wire.detachTarget();
        this.wire.setSource(this.oldSource);
        this.wire.setTarget(this.oldTarget);
        this.wire.attachSource();
        this.wire.attachTarget();
    }
}

