/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.model.commands;

import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class GlueChangeConstraintCommand
extends Command {
    private GlueSubpart subpart;
    private Point newLocation;
    private Point oldLocation;
    private Dimension newSize;
    private Dimension oldSize;

    public void setLocation(Rectangle rectangle) {
        this.newLocation = rectangle.getLocation();
        this.newSize = rectangle.getSize();
    }

    public void setSubpart(GlueSubpart part) {
        this.subpart = part;
    }

    public void execute() {
        this.oldLocation = this.subpart.getLocation();
        this.oldSize = this.subpart.getSize();
        this.redo();
    }

    public void redo() {
        this.subpart.setLocation(this.newLocation);
        this.subpart.setSize(this.newSize);
    }

    public void undo() {
        this.subpart.setLocation(this.oldLocation);
        this.subpart.setSize(this.oldSize);
    }

    public String getLabel() {
        if (this.oldSize.equals((Object)this.newSize)) {
            return "Move";
        }
        return "Resize";
    }
}

