/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.figure;

import com.poscoict.glueframework.plugin.activity.designer.figure.GlueFinalStateFigure;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueInitialStateFigure;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class GlueConnectionAnchor
extends EllipseAnchor {
    private Point dropPoint = null;
    private IFigure figure = null;

    public GlueConnectionAnchor(IFigure owner) {
        super(owner);
        this.figure = owner;
    }

    public void setDropPoint(Point dropPoint) {
        this.dropPoint = dropPoint;
    }

    public Point getLocation(Point reference) {
        Point finalPoint = super.getLocation(reference);
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.figure.getBounds());
        this.figure.translateToAbsolute((Translatable)rectangle);
        if (this.figure instanceof GlueInitialStateFigure || this.figure instanceof GlueFinalStateFigure) {
            Dimension difference = finalPoint.getDifference(reference);
            if (Math.abs(difference.width) < 5) {
                finalPoint.setLocation(reference.x, finalPoint.y);
            }
            return finalPoint;
        }
        float centerX = (float)rectangle.x + 0.5f * (float)rectangle.width;
        float centerY = (float)rectangle.y + 0.5f * (float)rectangle.height;
        long min = Long.MAX_VALUE;
        float slope = ((float)reference.y - centerY) / ((float)reference.x - centerX);
        float constraintK = centerY - slope * centerX;
        float arcRadious = 0.3f * (float)rectangle.height;
        int leftArcX = Math.round((float)rectangle.x + arcRadious);
        int rightArcX = Math.round((float)(rectangle.x + rectangle.width) - arcRadious);
        int topArcY = Math.round((float)rectangle.y + arcRadious);
        int bottomArcY = Math.round((float)(rectangle.y + rectangle.height) - arcRadious);
        float resultLineY = 0.0f;
        float tempResultArcY = 0.0f;
        int finalResultY = 0;
        int finalResultX = 0;
        if (reference.x >= leftArcX && reference.x <= rightArcX) {
            finalPoint = reference.y < Math.round(centerY) ? new Point(reference.x, rectangle.y) : new Point(reference.x, rectangle.y + rectangle.height);
        } else if (reference.x < leftArcX) {
            if (reference.y >= rectangle.y && reference.y <= rectangle.y + rectangle.height) {
                if (reference.y >= topArcY && reference.y <= bottomArcY) {
                    finalPoint = new Point(rectangle.x, reference.y);
                } else if (reference.y < topArcY) {
                    double contributeX = Math.sqrt(Math.pow(arcRadious, 2.0) - Math.pow(reference.y - topArcY, 2.0));
                    finalPoint = new Point(leftArcX - (int)Math.round(contributeX), reference.y);
                } else if (reference.y > bottomArcY) {
                    double contributeX = Math.sqrt(Math.pow(arcRadious, 2.0) - Math.pow(reference.y - bottomArcY, 2.0));
                    finalPoint = new Point(leftArcX - (int)Math.round(contributeX), reference.y);
                }
            } else {
                int i = rectangle.x;
                while (i <= leftArcX) {
                    resultLineY = slope * (float)i + constraintK;
                    double contributeY = Math.sqrt(Math.pow(arcRadious, 2.0) - Math.pow(i - leftArcX, 2.0));
                    if (reference.y < rectangle.y) {
                        tempResultArcY = (long)topArcY - Math.round(contributeY);
                    } else if (reference.y > rectangle.y + rectangle.height) {
                        tempResultArcY = (long)bottomArcY + Math.round(contributeY);
                    }
                    if (Math.abs(resultLineY - tempResultArcY) < (float)min) {
                        finalResultY = Math.round(tempResultArcY);
                        finalResultX = i;
                        min = (long)Math.abs(resultLineY - tempResultArcY);
                    }
                    ++i;
                }
                finalPoint = new Point(finalResultX, finalResultY);
            }
        } else if (reference.x > rightArcX) {
            if (reference.y >= rectangle.y && reference.y <= rectangle.y + rectangle.height) {
                if (reference.y >= topArcY && reference.y <= bottomArcY) {
                    finalPoint = new Point(rectangle.x + rectangle.width, reference.y);
                } else if (reference.y < topArcY) {
                    double contributeX = Math.sqrt(Math.pow(arcRadious, 2.0) - Math.pow(reference.y - topArcY, 2.0));
                    finalPoint = new Point(rightArcX + (int)Math.round(contributeX), reference.y);
                } else if (reference.y > bottomArcY) {
                    double contributeX = Math.sqrt(Math.pow(arcRadious, 2.0) - Math.pow(reference.y - bottomArcY, 2.0));
                    finalPoint = new Point(rightArcX + (int)Math.round(contributeX), reference.y);
                }
            } else {
                int i = rightArcX;
                while (i <= rectangle.x + rectangle.width) {
                    resultLineY = slope * (float)i + constraintK;
                    double contributeY = Math.sqrt(Math.pow(arcRadious, 2.0) - Math.pow(i - rightArcX, 2.0));
                    if (reference.y < rectangle.y) {
                        tempResultArcY = (long)topArcY - Math.round(contributeY);
                    } else if (reference.y > rectangle.y + rectangle.height) {
                        tempResultArcY = (long)bottomArcY + Math.round(contributeY);
                    }
                    if (Math.abs(resultLineY - tempResultArcY) < (float)min) {
                        finalResultY = Math.round(tempResultArcY);
                        finalResultX = i;
                        min = (long)Math.abs(resultLineY - tempResultArcY);
                    }
                    ++i;
                }
                finalPoint = new Point(finalResultX, finalResultY);
            }
        }
        return finalPoint;
    }

    public Point getReferencePoint() {
        Point referencePoint;
        if (this.dropPoint != null) {
            referencePoint = this.dropPoint.getCopy();
            this.setDropPoint(null);
        } else {
            referencePoint = this.figure.getBounds().getCenter();
            this.figure.translateToAbsolute((Translatable)referencePoint);
        }
        return referencePoint;
    }
}

