/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.figure;

import com.poscoict.glueframework.plugin.activity.designer.figure.GlueFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class GlueActivityFigure
extends GlueFigure {
    public static final float ARC_FACTOR = 0.3f;
    private final Label activityName = new Label();
    private final Label tooltip = new Label();
    private final Color color;

    public GlueActivityFigure(Color color) {
        super.setLayoutManager((LayoutManager)new StackLayout());
        super.setMinimumSize(new Dimension(100, 30));
        this.activityName.setTextAlignment(2);
        super.add((IFigure)this.activityName);
        super.setToolTip((IFigure)this.tooltip);
        this.color = color;
    }

    public void paintFigure(Graphics graphics) {
        super.setBounds(this.makeShape(graphics, this.color));
    }

    private Rectangle makeShape(Graphics graphics, Color color) {
        Rectangle rectangle = super.getBounds().getCopy();
        int arcWidth = Math.round((float)rectangle.height * 0.7f);
        graphics.setBackgroundColor(color);
        graphics.fillRoundRectangle(rectangle, arcWidth, arcWidth);
        graphics.setXORMode(false);
        graphics.setForegroundColor(ColorConstants.black);
        Rectangle borderRectangle = rectangle.getCopy().setSize(rectangle.width - 1, rectangle.height - 1);
        graphics.drawRoundRectangle(borderRectangle, arcWidth, arcWidth);
        return rectangle;
    }

    public String getText() {
        return this.activityName.getText();
    }

    public void setText(String newText) {
        this.activityName.setText(newText);
    }

    public void setToolTipText(String tooltip) {
        this.tooltip.setText(tooltip);
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public Dimension getPreferredSize(int width, int height) {
        Dimension prefSize = super.getPreferredSize(width, height);
        Dimension defaultSize = new Dimension(100, 30);
        prefSize.union(defaultSize);
        return prefSize;
    }
}

