/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.editpart.tool;

import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueWireEditPart;
import com.poscoict.glueframework.plugin.activity.designer.editpart.tool.GlueDirectEditRequest;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

public class GlueWireEditManager {
    private final GlueWireEditPart source;
    private final String wireGuardCondition;
    private boolean showingFeedback = false;
    private boolean committing = false;
    private boolean dirty = false;
    private GlueDirectEditRequest request;

    public GlueWireEditManager(GlueWireEditPart source) {
        this.source = source;
        this.wireGuardCondition = source.getWire().getWireGuardConditionContents();
    }

    public void show() {
        Shell shell = new Shell();
        InputDialog inputDialog = new InputDialog(shell, "Transition Condition Setting", "Transition Condition : ", this.wireGuardCondition, null);
        inputDialog.open();
        if (inputDialog.getReturnCode() == 0 && this.isWireLabelChanged(inputDialog.getValue())) {
            this.dirty = true;
            this.getGlueDirectEditRequest().setWireGuardCondition(inputDialog.getValue());
            this.commit();
            this.showFeedback();
        }
    }

    private void commit() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            this.eraseFeedback();
            if (this.dirty) {
                CommandStack stack = this.source.getViewer().getEditDomain().getCommandStack();
                stack.execute(this.source.getCommand((Request)this.getGlueDirectEditRequest()));
            }
        }
        finally {
            this.eraseFeedback();
            this.request = null;
            this.dirty = false;
            this.committing = false;
        }
    }

    private boolean isWireLabelChanged(String newWireLabel) {
        String oldWireConnectionLabel = this.wireGuardCondition;
        return !oldWireConnectionLabel.equals(newWireLabel);
    }

    private void showFeedback() {
        this.showingFeedback = true;
        this.source.showSourceFeedback((Request)this.getGlueDirectEditRequest());
    }

    private void eraseFeedback() {
        if (this.showingFeedback) {
            this.source.eraseSourceFeedback((Request)this.getGlueDirectEditRequest());
            this.showingFeedback = false;
        }
    }

    private GlueDirectEditRequest getGlueDirectEditRequest() {
        if (this.request == null) {
            this.request = new GlueDirectEditRequest();
        }
        return this.request;
    }
}

