/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.editpart.tool;

import com.poscoict.glueframework.plugin.activity.designer.dialog.GlueActivityDialog;
import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueActivityEditPart;
import com.poscoict.glueframework.plugin.activity.designer.editpart.tool.GlueDirectEditRequest;
import com.poscoict.glueframework.plugin.activity.designer.viewpart.GlueActivityViewPart;
import com.poscoict.glueframework.plugin.activity.model.GlueActivity;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class GlueActivityOpenEditManager {
    private final GlueActivityEditPart source;
    private final String activityName;
    private final Map<String, String> activityPropertyMap;
    private boolean showingFeedback = false;
    private boolean committing = false;
    private boolean dirty = false;
    private GlueDirectEditRequest request;

    public GlueActivityOpenEditManager(GlueActivityEditPart source) {
        this.source = source;
        this.activityName = source.getActivity().getName();
        this.activityPropertyMap = source.getActivity().getPropertyMap();
    }

    public void openDialog() {
        Shell shell = new Shell();
        GlueActivityDialog activityDialog = new GlueActivityDialog(shell);
        activityDialog.setActivityName(this.activityName);
        String activityNameOld = this.activityName;
        activityDialog.setActivityPropertyMap(this.activityPropertyMap);
        activityDialog.setProjectName((String)this.source.getViewer().getProperty("Glue Project Name"));
        activityDialog.open();
        if (activityDialog.getReturnCode() == 0 && activityDialog.isPropertyChange()) {
            String newActivityName = activityDialog.getActivityName();
            List childs = this.source.getParent().getChildren();
            for (Object child : childs) {
                if (!(child instanceof GlueActivityEditPart)) continue;
                GlueActivity activity = ((GlueActivityEditPart)child).getActivity();
                if (activityNameOld.equals(newActivityName) || !activity.getName().equals(newActivityName)) continue;
                MessageDialog.openInformation((Shell)shell, (String)"Warning!!", (String)("Can't use same Activity Name[" + newActivityName + "]!"));
                activityDialog.setActivityName(String.valueOf(newActivityName) + "_1");
            }
            this.dirty = true;
            this.getGlueDirectEditRequest().setActivityName(activityDialog.getActivityName());
            this.getGlueDirectEditRequest().setActivityPropsMap(activityDialog.getActivityPropertyMap());
            this.commit();
            this.showFeedback();
        }
    }

    public void showView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            try {
                page.showView("Glue Activity Property View");
                GlueActivityViewPart viewPart = (GlueActivityViewPart)page.findView("Glue Activity Property View");
                viewPart.setActivityName(this.activityName);
                viewPart.setActivityPropertyMap(this.activityPropertyMap);
                viewPart.setProjectName((String)this.source.getViewer().getProperty("Glue Project Name"));
                viewPart.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object object, int propId) {
                        if (propId == 257) {
                            GlueActivityViewPart viewPart = (GlueActivityViewPart)((Object)object);
                            String activityNameOld = GlueActivityOpenEditManager.this.activityName;
                            String newActivityName = viewPart.getActivityName();
                            List childs = GlueActivityOpenEditManager.this.source.getParent().getChildren();
                            for (Object child : childs) {
                                if (!(child instanceof GlueActivityEditPart)) continue;
                                GlueActivity activity = ((GlueActivityEditPart)child).getActivity();
                                if (activityNameOld.equals(newActivityName) || !activity.getName().equals(newActivityName)) continue;
                                MessageDialog.openInformation((Shell)new Shell(), (String)"Warning!!", (String)("Can't use same Activity Name[" + newActivityName + "]!"));
                                viewPart.setActivityName(String.valueOf(newActivityName) + "_1");
                            }
                            GlueActivityOpenEditManager.this.dirty = true;
                            GlueActivityOpenEditManager.this.getGlueDirectEditRequest().setActivityName(viewPart.getActivityName());
                            GlueActivityOpenEditManager.this.getGlueDirectEditRequest().setActivityPropsMap(viewPart.getActivityPropertyMap());
                            GlueActivityOpenEditManager.this.commit();
                            GlueActivityOpenEditManager.this.showFeedback();
                        }
                    }
                });
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private void commit() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            this.eraseFeedback();
            if (this.dirty) {
                CommandStack stack = this.source.getViewer().getEditDomain().getCommandStack();
                stack.execute(this.source.getCommand((Request)this.getGlueDirectEditRequest()));
            }
        }
        finally {
            this.eraseFeedback();
            this.request = null;
            this.dirty = false;
            this.committing = false;
        }
    }

    private void showFeedback() {
        this.showingFeedback = true;
        this.source.showSourceFeedback((Request)this.getGlueDirectEditRequest());
    }

    private void eraseFeedback() {
        if (this.showingFeedback) {
            this.source.eraseSourceFeedback((Request)this.getGlueDirectEditRequest());
            this.showingFeedback = false;
        }
    }

    private GlueDirectEditRequest getGlueDirectEditRequest() {
        if (this.request == null) {
            this.request = new GlueDirectEditRequest();
        }
        return this.request;
    }
}

