/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.editpart;

import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueEditPartUtil;
import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueRelativeBendpoint;
import com.poscoict.glueframework.plugin.activity.designer.editpart.tool.GlueWireEditManager;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueFigureFactory;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueLineConnection;
import com.poscoict.glueframework.plugin.activity.designer.policy.GlueWireBendpointEditPolicy;
import com.poscoict.glueframework.plugin.activity.designer.policy.GlueWireDirectEditPolicy;
import com.poscoict.glueframework.plugin.activity.designer.policy.GlueWireEditPolicy;
import com.poscoict.glueframework.plugin.activity.designer.policy.GlueWireEndpointEditPolicy;
import com.poscoict.glueframework.plugin.activity.model.GlueInitialState;
import com.poscoict.glueframework.plugin.activity.model.GlueWire;
import com.poscoict.glueframework.plugin.activity.model.GlueWireBendpoint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class GlueWireEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    private AccessibleEditPart accessibleEditPart;

    public void activate() {
        super.activate();
        this.getWire().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void activateFigure() {
        super.activateFigure();
        this.getFigure().addPropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
    }

    protected void createEditPolicies() {
        super.installEditPolicy((Object)"Connection Endpoint Policy", (EditPolicy)new GlueWireEndpointEditPolicy());
        super.installEditPolicy((Object)"Connection Bendpoint Policy", (EditPolicy)new GlueWireBendpointEditPolicy());
        super.installEditPolicy((Object)"ConnectionEditPolicy", (EditPolicy)new GlueWireEditPolicy());
        super.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new GlueWireDirectEditPolicy());
    }

    public void performRequest(Request request) {
        if (!this.isInitialState() && request.getType() == "open") {
            new GlueWireEditManager(this).show();
        }
    }

    protected IFigure createFigure() {
        if (this.getWire() == null) {
            return null;
        }
        return GlueFigureFactory.createNewBendableWire(this.getWire());
    }

    public void deactivate() {
        this.getWire().removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    public void deactivateFigure() {
        this.getFigure().removePropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
        super.deactivateFigure();
    }

    public AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEditPart == null) {
            this.accessibleEditPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = "Wire";
                }
            };
        }
        return this.accessibleEditPart;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("connectionRouter".equals(property) || "bendpoint".equals(property) || "wireGuardCondition".equals(property)) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        ConnectionRouter router = super.getConnectionFigure().getConnectionRouter();
        if (router instanceof ManhattanConnectionRouter || router instanceof ShortestPathConnectionRouter) {
            return;
        }
        List bendpointList = this.getWire().getBendpoints();
        ArrayList<GlueRelativeBendpoint> figureConstraint = new ArrayList<GlueRelativeBendpoint>();
        int i = 0;
        while (i < bendpointList.size()) {
            GlueWireBendpoint wbp = (GlueWireBendpoint)bendpointList.get(i);
            GlueRelativeBendpoint rbp = new GlueRelativeBendpoint(this.getConnectionFigure());
            rbp.setRelativeDimensions(wbp.getFirstRelativeDimension(), wbp.getSecondRelativeDimension());
            rbp.setWeight((float)(i + 1) / ((float)bendpointList.size() + 1.0f));
            figureConstraint.add(rbp);
            ++i;
        }
        super.getConnectionFigure().setRoutingConstraint(figureConstraint);
        GlueLineConnection connection = this.getWireFigure();
        Point[] recentRelPoint = GlueEditPartUtil.getRecentRelativePoint(connection);
        if (recentRelPoint != null && recentRelPoint.length == 2) {
            if (recentRelPoint[0] != null) {
                this.getWire().setFirstRelativePoint(recentRelPoint[0]);
            }
            if (recentRelPoint[1] != null) {
                this.getWire().setLastRelativePoint(recentRelPoint[1]);
            }
        }
        if (this.getWire().getID() == null) {
            this.getWire().setNewID();
        }
        connection.setWireID(this.getWire().getID());
        this.replaceWireLabel(connection, bendpointList.size() / 2);
    }

    public GlueWire getWire() {
        return (GlueWire)this.getModel();
    }

    public Label getWireConnectionLabel() {
        List figureList = this.getWireFigure().getChildren();
        for (Object figure : figureList) {
            if (!(figure instanceof Label)) continue;
            return (Label)figure;
        }
        return null;
    }

    private boolean isInitialState() {
        return this.getWire().getSource() instanceof GlueInitialState;
    }

    private GlueLineConnection getWireFigure() {
        return (GlueLineConnection)this.getFigure();
    }

    private void replaceWireLabel(GlueLineConnection connection, int index) {
        for (Object figure : this.getWireFigure().getChildren()) {
            if (!(figure instanceof Label)) continue;
            connection.add((IFigure)((Label)figure), new MidpointLocator((Connection)connection, index));
        }
    }
}

