/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.editpart;

import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueEditPartUtil;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueActivityFigure;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueConnectionAnchor;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueFinalStateFigure;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueInitialStateFigure;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueLineConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class GluePointConnectionRouter
extends AbstractRouter {
    private static final PrecisionPoint PRECISION_POINT = new PrecisionPoint();
    private final Map<Connection, Object> constraintMap = new HashMap<Connection, Object>();
    private final Map<String, Point[]> initPointMap = new HashMap<String, Point[]>();
    private final Map<Connection, Point[]> lastPonitMap = new HashMap<Connection, Point[]>();
    private Point recentSourcePoint = null;
    private Point recentTargetPoint = null;

    public void putInitPoint(String key, Point[] value) {
        this.initPointMap.put(key, value);
    }

    public Point getRecentSourcePoint() {
        return this.recentSourcePoint;
    }

    public Point getRecentTargetPoint() {
        return this.recentTargetPoint;
    }

    public Object getConstraint(Connection connection) {
        return this.constraintMap.get(connection);
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.constraintMap.put(connection, constraint);
    }

    public void remove(Connection connection) {
        this.constraintMap.remove(connection);
    }

    public void route(Connection conn) {
        Point finalTargetPoint;
        Point ref2;
        Point ref1;
        ArrayList bendpoints;
        Point[] oldConnPoints;
        GlueLineConnection connection = (GlueLineConnection)conn;
        ConnectionAnchor sourceAnchor = connection.getSourceAnchor();
        ConnectionAnchor targetAnchor = connection.getTargetAnchor();
        PointList points = connection.getPoints();
        points.removeAllPoints();
        Point firstPoint = connection.getFirstRelativePoint();
        Point lastPoint = connection.getLastRelativePoint();
        String unionID = GlueEditPartUtil.getFigureUnionIDForConnection(connection);
        if (this.constraintMap.containsKey((Object)connection) && this.initPointMap.containsKey(unionID)) {
            oldConnPoints = this.initPointMap.get(unionID);
            if (oldConnPoints == null) {
                oldConnPoints = new Point[]{firstPoint, lastPoint};
            }
            connection.translateToAbsolute((Translatable)oldConnPoints[0]);
            connection.translateToAbsolute((Translatable)oldConnPoints[1]);
            if (sourceAnchor instanceof GlueConnectionAnchor && sourceAnchor.getOwner() != null) {
                ((GlueConnectionAnchor)sourceAnchor).setDropPoint(new Point(oldConnPoints[0].x, oldConnPoints[0].y));
            }
            if (targetAnchor instanceof GlueConnectionAnchor && targetAnchor.getOwner() != null) {
                ((GlueConnectionAnchor)targetAnchor).setDropPoint(new Point(oldConnPoints[1].x, oldConnPoints[1].y));
            }
        }
        if (this.constraintMap.containsKey((Object)connection) && (this.lastPonitMap.containsKey((Object)connection) || firstPoint != null && lastPoint != null)) {
            oldConnPoints = this.lastPonitMap.get((Object)connection);
            if (oldConnPoints == null) {
                oldConnPoints = new Point[]{firstPoint, lastPoint};
            }
            connection.translateToAbsolute((Translatable)oldConnPoints[0]);
            connection.translateToAbsolute((Translatable)oldConnPoints[1]);
            if (sourceAnchor instanceof GlueConnectionAnchor) {
                ((GlueConnectionAnchor)sourceAnchor).setDropPoint(new Point(oldConnPoints[0].x, oldConnPoints[0].y));
            }
            if (targetAnchor instanceof GlueConnectionAnchor) {
                ((GlueConnectionAnchor)targetAnchor).setDropPoint(new Point(oldConnPoints[1].x, oldConnPoints[1].y));
            }
        }
        if ((bendpoints = (ArrayList)this.getConstraint((Connection)connection)) == null) {
            bendpoints = new ArrayList();
        }
        if (bendpoints.isEmpty()) {
            ref1 = targetAnchor.getReferencePoint();
            ref2 = sourceAnchor.getReferencePoint();
            this.checkStateStatus(ref2, ref1, sourceAnchor.getOwner(), targetAnchor.getOwner());
        } else {
            if (sourceAnchor instanceof GlueConnectionAnchor) {
                ((GlueConnectionAnchor)sourceAnchor).setDropPoint(null);
            }
            if (targetAnchor instanceof GlueConnectionAnchor) {
                ((GlueConnectionAnchor)targetAnchor).setDropPoint(null);
            }
            ref1 = new Point(((Bendpoint)bendpoints.get(0)).getLocation());
            connection.translateToAbsolute((Translatable)ref1);
            ref2 = new Point(((Bendpoint)bendpoints.get(bendpoints.size() - 1)).getLocation());
            connection.translateToAbsolute((Translatable)ref2);
        }
        Point finalSourcePoint = sourceAnchor.getLocation(ref1);
        PRECISION_POINT.setLocation(finalSourcePoint);
        connection.translateToRelative((Translatable)PRECISION_POINT);
        points.addPoint((Point)PRECISION_POINT);
        for (Bendpoint bendpoint : bendpoints) {
            points.addPoint(bendpoint.getLocation());
        }
        if (!bendpoints.isEmpty()) {
            Point lastPointOfBendpoint = points.getLastPoint().getCopy();
            connection.translateToAbsolute((Translatable)lastPointOfBendpoint);
            finalTargetPoint = targetAnchor.getLocation(lastPointOfBendpoint);
        } else {
            finalTargetPoint = targetAnchor.getOwner() instanceof GlueActivityFigure ? targetAnchor.getLocation(finalSourcePoint) : targetAnchor.getLocation(ref2);
        }
        PRECISION_POINT.setLocation(finalTargetPoint);
        connection.translateToRelative((Translatable)PRECISION_POINT);
        points.addPoint((Point)PRECISION_POINT);
        connection.setPoints(points);
        points = connection.getPoints();
        this.setRelativePointAtConnection(connection);
        if (points.size() >= 2 && this.constraintMap.containsKey((Object)connection)) {
            Point relSrcPoint = points.getFirstPoint().getCopy();
            Point relTarPoint = points.getLastPoint().getCopy();
            this.lastPonitMap.put((Connection)connection, new Point[]{relSrcPoint, relTarPoint});
            connection.setFirstRelativePoint(relSrcPoint);
            connection.setLastRelativePoint(relTarPoint);
        }
    }

    private void checkStateStatus(Point sourcePoint, Point targetPoint, IFigure sourceFigure, IFigure targetFigure) {
        int centerX;
        Rectangle targetOwner;
        Rectangle sourceOwner;
        if ((sourceFigure instanceof GlueInitialStateFigure || sourceFigure instanceof GlueFinalStateFigure) && targetFigure != null) {
            sourceOwner = Rectangle.SINGLETON;
            sourceOwner.setBounds(sourceFigure.getBounds());
            sourceFigure.translateToAbsolute((Translatable)sourceOwner);
            targetOwner = Rectangle.SINGLETON;
            targetOwner.setBounds(targetFigure.getBounds());
            sourceFigure.translateToAbsolute((Translatable)targetOwner);
            centerX = sourceOwner.getCenter().x;
            int targetFigureLeftX = targetOwner.x;
            int targetFigureRightX = targetFigureLeftX + targetOwner.width;
            if (centerX > targetFigureLeftX && centerX < targetFigureRightX) {
                sourcePoint.setLocation(centerX, sourcePoint.y);
                targetPoint.setLocation(centerX, targetPoint.y);
                return;
            }
        }
        if ((targetFigure instanceof GlueInitialStateFigure || targetFigure instanceof GlueFinalStateFigure) && sourceFigure != null) {
            sourceOwner = Rectangle.SINGLETON;
            sourceOwner.setBounds(sourceFigure.getBounds());
            sourceFigure.translateToAbsolute((Translatable)sourceOwner);
            targetOwner = Rectangle.SINGLETON;
            targetOwner.setBounds(targetFigure.getBounds());
            sourceFigure.translateToAbsolute((Translatable)targetOwner);
            centerX = targetOwner.getCenter().x;
            int sourceFigureLeftX = sourceOwner.x;
            int sourceFigureRightX = sourceFigureLeftX + sourceOwner.width;
            if (centerX > sourceFigureLeftX && centerX < sourceFigureRightX) {
                sourcePoint.setLocation(centerX, sourcePoint.y);
                targetPoint.setLocation(centerX, targetPoint.y);
                return;
            }
        }
    }

    private void setRelativePointAtConnection(GlueLineConnection connection) {
        PointList points = connection.getPoints();
        if (points.size() >= 2) {
            if (connection.getSourceAnchor().getOwner() != null) {
                Point relSrcPoint = points.getFirstPoint().getCopy();
                connection.setFirstRelativePoint(relSrcPoint);
                this.recentSourcePoint = relSrcPoint;
            }
            if (connection.getTargetAnchor().getOwner() != null) {
                Point relTarPoint = points.getLastPoint().getCopy();
                connection.setLastRelativePoint(relTarPoint);
                this.recentTargetPoint = relTarPoint;
            }
        }
    }
}

