/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.editpart;

import com.poscoict.glueframework.plugin.activity.designer.editpart.GluePointConnectionRouter;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueActivityFigure;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueFigure;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueFinalStateFigure;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueInitialStateFigure;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueLineConnection;
import com.poscoict.glueframework.plugin.activity.model.GlueActivity;
import com.poscoict.glueframework.plugin.activity.model.GlueFinalState;
import com.poscoict.glueframework.plugin.activity.model.GlueInitialState;
import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.activity.model.GlueWire;
import org.eclipse.draw2d.geometry.Point;

public class GlueEditPartUtil {
    public static Point[] getRecentRelativePoint(GlueLineConnection conn) {
        GluePointConnectionRouter router = (GluePointConnectionRouter)conn.getConnectionRouter();
        return new Point[]{router.getRecentSourcePoint(), router.getRecentTargetPoint()};
    }

    public static String getFigureUnionIDForConnection(GlueLineConnection conn) {
        StringBuffer figureID = new StringBuffer();
        figureID.append(GlueEditPartUtil.getFigureIDName((GlueFigure)conn.getSourceAnchor().getOwner()));
        figureID.append("->");
        figureID.append(GlueEditPartUtil.getFigureIDName((GlueFigure)conn.getTargetAnchor().getOwner()));
        figureID.append("(Wire[" + conn.getWireID() + "])");
        return figureID.toString();
    }

    public static String getFigureIDName(GlueFigure glueFigure) {
        if (glueFigure instanceof GlueActivityFigure) {
            return "Activity[" + glueFigure.getFigureID() + "]";
        }
        if (glueFigure instanceof GlueInitialStateFigure) {
            return "InitialState[" + glueFigure.getFigureID() + "]";
        }
        if (glueFigure instanceof GlueFinalStateFigure) {
            return "FinalState[" + glueFigure.getFigureID() + "]";
        }
        return null;
    }

    public static String getFigureUnionIDForConnection(GlueWire wire) {
        StringBuffer figureID = new StringBuffer();
        figureID.append(GlueEditPartUtil.getFigureIDName(wire.getSource()));
        figureID.append("->");
        figureID.append(GlueEditPartUtil.getFigureIDName(wire.getTarget()));
        figureID.append("(Wire[" + wire.getID() + "])");
        return figureID.toString();
    }

    public static String getFigureIDName(GlueSubpart glueSubpart) {
        if (glueSubpart instanceof GlueActivity) {
            return "Activity[" + glueSubpart.getID() + "]";
        }
        if (glueSubpart instanceof GlueInitialState) {
            return "InitialState[" + glueSubpart.getID() + "]";
        }
        if (glueSubpart instanceof GlueFinalState) {
            return "FinalState[" + glueSubpart.getID() + "]";
        }
        return null;
    }
}

