/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.editpart;

import com.poscoict.glueframework.plugin.activity.designer.figure.GlueFigure;
import com.poscoict.glueframework.plugin.activity.designer.policy.GlueComponentEditPolicy;
import com.poscoict.glueframework.plugin.activity.designer.policy.GlueNodeEditPolicy;
import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.activity.model.GlueWire;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;

public abstract class GlueEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
PropertyChangeListener {
    private AccessibleEditPart accessibleEditPart;

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.getGlueSubpart().addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void createEditPolicies() {
        super.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new GlueComponentEditPolicy());
        super.installEditPolicy((Object)"GraphicalNodeEditPolicy", (EditPolicy)new GlueNodeEditPolicy());
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        this.getGlueSubpart().removePropertyChangeListener((PropertyChangeListener)this);
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEditPart == null) {
            this.accessibleEditPart = this.createAccessible();
        }
        return this.accessibleEditPart;
    }

    protected List<GlueWire> getModelSourceConnections() {
        return this.getGlueSubpart().getSourceConnections();
    }

    protected List<GlueWire> getModelTargetConnections() {
        return this.getGlueSubpart().getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        return this.getGlueFigure().getSourceConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getGlueFigure().getSourceConnectionAnchorAt(pt);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        return this.getGlueFigure().getTargetConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point point = new Point(((DropRequest)request).getLocation());
        return this.getGlueFigure().getTargetConnectionAnchorAt(point);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if (prop.equals("Children")) {
            super.refreshChildren();
        } else if (prop.equals("inputs")) {
            super.refreshTargetConnections();
        } else if (prop.equals("outputs")) {
            super.refreshSourceConnections();
        } else if (prop.equals("size") || prop.equals("location")) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        Rectangle rectangle = new Rectangle(this.getGlueSubpart().getLocation(), this.getGlueSubpart().getSize());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, super.getFigure(), (Object)rectangle);
    }

    protected abstract AccessibleEditPart createAccessible();

    private GlueFigure getGlueFigure() {
        return (GlueFigure)super.getFigure();
    }

    private GlueSubpart getGlueSubpart() {
        return (GlueSubpart)super.getModel();
    }
}

