/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.editpart;

import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueEditPart;
import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueEditPartUtil;
import com.poscoict.glueframework.plugin.activity.designer.editpart.GluePointConnectionRouter;
import com.poscoict.glueframework.plugin.activity.designer.policy.GlueDiagramDirectEditPolicy;
import com.poscoict.glueframework.plugin.activity.designer.policy.GlueXYLayoutEditPolicy;
import com.poscoict.glueframework.plugin.activity.model.GlueDiagram;
import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.activity.model.GlueWire;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class GlueDiagramEditPart
extends GlueEditPart
implements LayerConstants {
    private final FreeformLayout layout = new FreeformLayout();

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent event) {
                event.result = "Label";
            }
        };
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        super.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new GlueDiagramDirectEditPolicy());
        super.installEditPolicy((Object)"NodeEditPolicy", null);
        super.installEditPolicy((Object)"GraphicalNodeEditPolicy", null);
        super.installEditPolicy((Object)"Selection Feedback", null);
        super.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        super.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new GlueXYLayoutEditPolicy((XYLayout)this.getContentPane().getLayoutManager()));
        super.installEditPolicy((Object)"Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer();
        figure.setLayoutManager((LayoutManager)this.layout);
        figure.setBorder((Border)new MarginBorder(5));
        return figure;
    }

    public Object getAdapter(Class adapter) {
        try {
            this.getViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(10, 10));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            return new CompoundSnapToHelper(snapStrategies.toArray(new SnapToHelper[snapStrategies.size()]));
        }
        return super.getAdapter(adapter);
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new MarqueeDragTracker();
    }

    protected List<GlueSubpart> getModelChildren() {
        return this.getGlueDiagram().getChildren();
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    @Override
    protected void refreshVisuals() {
        ConnectionLayer connectionLayer = (ConnectionLayer)super.getLayer((Object)"Connection Layer");
        this.getFigure().setLayoutManager((LayoutManager)this.layout);
        GluePointConnectionRouter router = new GluePointConnectionRouter();
        this.initializeConnectionRouter(router);
        connectionLayer.setConnectionRouter((ConnectionRouter)router);
    }

    public GlueDiagram getGlueDiagram() {
        return (GlueDiagram)super.getModel();
    }

    private void initializeConnectionRouter(GluePointConnectionRouter router) {
        for (GlueWire wire : this.getGlueDiagram().getWires()) {
            String key = GlueEditPartUtil.getFigureUnionIDForConnection(wire);
            Point firstPoint = wire.getFirstRelativePoint();
            Point lastPoint = wire.getLastRelativePoint();
            if (firstPoint == null || lastPoint == null) continue;
            router.putInitPoint(key, new Point[]{firstPoint.getCopy(), lastPoint.getCopy()});
        }
    }
}

