/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.editpart;

import com.poscoict.glueframework.plugin.activity.designer.GlueActivityDesignerPlugin;
import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueEditPart;
import com.poscoict.glueframework.plugin.activity.designer.editpart.tool.GlueActivityDirectEditManager;
import com.poscoict.glueframework.plugin.activity.designer.editpart.tool.GlueActivityOpenEditManager;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueActivityFigure;
import com.poscoict.glueframework.plugin.activity.designer.figure.GlueFigureFactory;
import com.poscoict.glueframework.plugin.activity.designer.policy.GlueActivityDirectEditPolicy;
import com.poscoict.glueframework.plugin.activity.model.GlueActivity;
import com.poscoict.glueframework.plugin.project.startup.GlueProjectPlugin;
import com.poscoict.glueframework.schema.plugin.config.parser.GlueConfigInfo;
import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;

public class GlueActivityEditPart
extends GlueEditPart {
    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getValue(AccessibleControlEvent event) {
                event.result = GlueActivityEditPart.this.getActivity().getName();
            }

            public void getName(AccessibleEvent event) {
                event.result = "Label";
            }
        };
    }

    protected IFigure createFigure() {
        Color color = new Color(null, 255, 255, 255);
        String className = this.getActivity().getClassName();
        for (GlueConfigInfo.GlueActivityInfo activityInfo : GlueActivityDesignerPlugin.getGlueConfigInfo().getActivityInfoList()) {
            if (!((String)activityInfo.getPropertiesMap().get("class")).equalsIgnoreCase(className)) continue;
            int[] arrColor = activityInfo.getColor();
            color = new Color(null, arrColor[0], arrColor[1], arrColor[2]);
            break;
        }
        return GlueFigureFactory.createActivityFigure(color);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        super.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new GlueActivityDirectEditPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            new GlueActivityDirectEditManager((GraphicalEditPart)this, this.getActivityFigure()).show();
        } else if (request.getType() == "open") {
            String propertyEditor = GlueProjectPlugin.getDefault().getPreferenceStore().getString("GLUE_ACTIVITY_PROPERTY_EDITOR");
            if ("dialog".equals(propertyEditor)) {
                new GlueActivityOpenEditManager(this).openDialog();
            } else if ("view".equals(propertyEditor)) {
                new GlueActivityOpenEditManager(this).showView();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("activityContents")) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    protected void refreshVisuals() {
        this.getActivityFigure().setText(this.getActivity().getName());
        this.getActivityFigure().setToolTipText(this.getActivity().getClassName());
        this.getActivityFigure().setFigureID(this.getActivity().getID());
        super.refreshVisuals();
    }

    public GlueActivity getActivity() {
        return (GlueActivity)super.getModel();
    }

    public GlueActivityFigure getActivityFigure() {
        return (GlueActivityFigure)super.getFigure();
    }
}

