/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.dialog;

import com.poscoict.glueframework.plugin.activity.designer.dialog.GlueCellModifier;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GluePropertyTask;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GlueTableLabelProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class GlueTransactionDialog
extends Dialog {
    private Text descriptionText;
    private TableViewer tableViewer;
    private String description = "";
    private final Map<String, String> transactionPropertyMap = new LinkedHashMap<String, String>();
    private boolean isPropertyChange = false;

    public GlueTransactionDialog(Shell parentShell) {
        super(parentShell);
    }

    public Map<String, String> getTransactionPropertyMap() {
        return this.transactionPropertyMap;
    }

    public void setTransactionPropertyMap(Map<String, String> transactionPropertyMap) {
        this.transactionPropertyMap.clear();
        this.transactionPropertyMap.putAll(transactionPropertyMap);
    }

    public boolean isPropertyChange() {
        return this.isPropertyChange;
    }

    protected Control createDialogArea(Composite parent) {
        super.getShell().setText("Transaction Setting");
        Composite composite = (Composite)super.createDialogArea(parent);
        Label propertyLabel = new Label(composite, 64);
        propertyLabel.setText("Properties : ");
        propertyLabel.setFont(parent.getFont());
        this.tableViewer = new TableViewer(composite, 65572);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 100;
        gridData.minimumWidth = 300;
        table.setLayoutData((Object)gridData);
        this.tableViewer.setColumnProperties(new String[]{"Name", "Value"});
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText("Name");
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText("Value");
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, true));
        buttonComposite.setLayoutData((Object)new GridData(768));
        Button addRowButton = new Button(buttonComposite, 8);
        addRowButton.setText("Add");
        addRowButton.setLayoutData((Object)new GridData(768));
        addRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GlueTransactionDialog.this.tableViewer.add((Object)new GluePropertyTask("", ""));
                GlueTransactionDialog.this.tableViewer.getTable().select(GlueTransactionDialog.this.tableViewer.getTable().getItemCount() - 1);
            }
        });
        Button deleteRowButton = new Button(buttonComposite, 8);
        deleteRowButton.setText("Delete");
        deleteRowButton.setLayoutData((Object)new GridData(768));
        deleteRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = 0;
                while (i < GlueTransactionDialog.this.tableViewer.getTable().getItemCount()) {
                    if (GlueTransactionDialog.this.tableViewer.getTable().getItem(i).getChecked()) {
                        GlueTransactionDialog.this.tableViewer.getTable().remove(i);
                        i = -1;
                    }
                    ++i;
                }
            }
        });
        Label descriptionLabel = new Label(composite, 64);
        descriptionLabel.setText("Description : ");
        descriptionLabel.setFont(parent.getFont());
        this.descriptionText = new Text(composite, 2816);
        gridData = new GridData(258);
        gridData.heightHint = 100;
        this.descriptionText.setLayoutData((Object)gridData);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setCellModifier((ICellModifier)new GlueCellModifier(false));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new GlueTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        for (Map.Entry<String, String> entry : this.transactionPropertyMap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!"description".equals(name)) {
                this.tableViewer.add((Object)new GluePropertyTask(name, value));
                continue;
            }
            this.description = value;
            this.descriptionText.setText(value);
        }
        composite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent event) {
                int tableWidth = ((Composite)event.getSource()).getSize().x - 24;
                int barWidth = ((GlueTransactionDialog)GlueTransactionDialog.this).tableViewer.getTable().getVerticalBar().getSize().x;
                int columnWidth = 0;
                columnWidth = GlueTransactionDialog.this.tableViewer.getTable().getVerticalBar().isVisible() ? (tableWidth - barWidth) / 2 : tableWidth / 2;
                GlueTransactionDialog.this.tableViewer.getTable().getColumn(0).setWidth(columnWidth);
                GlueTransactionDialog.this.tableViewer.getTable().getColumn(1).setWidth(columnWidth);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return composite;
    }

    protected void okPressed() {
        this.checkPropertyChange();
        if (this.isPropertyChange) {
            this.transactionPropertyMap.clear();
            int i = 0;
            while (i < this.tableViewer.getTable().getItemCount()) {
                GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
                if (task.getValue() == null || task.getValue().trim().length() == 0 || !"true".equals(task.getValue())) {
                    MessageDialog.openInformation((Shell)this.tableViewer.getControl().getShell(), (String)"Warning!", (String)"Transaction Value must be \"true\"! It will be fixed to \"true\" automatically!");
                }
                this.transactionPropertyMap.put(task.getName(), "true");
                ++i;
            }
            this.transactionPropertyMap.put("description", this.descriptionText.getText());
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    private void checkPropertyChange() {
        if (!this.description.equals(this.descriptionText.getText())) {
            this.isPropertyChange = true;
            return;
        }
        if (this.transactionPropertyMap != null && this.transactionPropertyMap.size() != this.tableViewer.getTable().getItemCount() + 1) {
            this.isPropertyChange = true;
            return;
        }
        if (this.transactionPropertyMap == null && this.tableViewer.getTable().getItemCount() > 0) {
            this.isPropertyChange = true;
            return;
        }
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
            if (!this.isPropertyChange && task.isPropertyChanged()) {
                this.isPropertyChange = true;
            }
            ++i;
        }
    }
}

