/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.dialog;

import com.poscoict.glueframework.plugin.project.startup.util.GlueEclipseProjectUtil;
import com.poscoict.glueframework.plugin.query.editor.model.GlueQuery;
import com.poscoict.glueframework.plugin.query.editor.model.GlueQueryMap;
import com.poscoict.glueframework.plugin.query.editor.model.GlueQueryRoot;
import com.poscoict.glueframework.plugin.query.editor.view.GlueQueryContentProvider;
import com.poscoict.glueframework.plugin.query.editor.view.GlueQueryLabelProvider;
import com.poscoict.glueframework.schema.query.parser.GlueQueryMapInfo;
import com.poscoict.glueframework.schema.query.parser.GlueQueryParser;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GlueQuerySelectDialog
extends Dialog {
    private TreeViewer treeViewer;
    private Text idText;
    private Text descText;
    private Text queryText;
    private Text resultTypeText;
    private Button namedChk;
    private String projectName;
    private String selectedQueryKey;
    private boolean isNamed;
    private int bindCount = 0;
    private GlueQuery selectedQuery;

    public GlueQuerySelectDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getSelectedQueryKey() {
        return this.selectedQueryKey;
    }

    public void setSelectedQueryKey(String selectedQueryKey) {
        this.selectedQueryKey = selectedQueryKey;
    }

    public boolean isNamed() {
        return this.isNamed;
    }

    public int getBindCount() {
        return this.bindCount;
    }

    protected Control createDialogArea(Composite parent) {
        super.getShell().setText("Query Explorer Diaglog");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        GridData data = (GridData)composite.getLayoutData();
        data.minimumWidth = 500;
        Group listGroup = new Group(composite, 4);
        listGroup.setText("Query List");
        listGroup.setLayout((Layout)new GridLayout());
        listGroup.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer((Composite)listGroup, 2048);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new GlueQueryLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new GlueQueryContentProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        try {
            this.makeQueryTree();
        }
        catch (CoreException e) {
            this.showErrorDialog("Tree error", "error making query tree", e);
        }
        Group detailGroup = new Group(composite, 4);
        detailGroup.setText("Details");
        detailGroup.setLayout((Layout)new GridLayout(2, false));
        detailGroup.setLayoutData((Object)new GridData(1808));
        Label idLabel = new Label((Composite)detailGroup, 131072);
        idLabel.setText("ID");
        this.idText = new Text((Composite)detailGroup, 2060);
        this.idText.setLayoutData((Object)new GridData(768));
        Label descLabel = new Label((Composite)detailGroup, 131072);
        descLabel.setText("Description");
        this.descText = new Text((Composite)detailGroup, 2060);
        this.descText.setLayoutData((Object)new GridData(768));
        Label typeLabel = new Label((Composite)detailGroup, 131072);
        typeLabel.setText("Result Type");
        this.resultTypeText = new Text((Composite)detailGroup, 2060);
        this.resultTypeText.setLayoutData((Object)new GridData(768));
        Label queryLabel = new Label((Composite)detailGroup, 131072);
        queryLabel.setText("Named Query");
        this.namedChk = new Button((Composite)detailGroup, 16416);
        this.namedChk.setLayoutData((Object)new GridData(768));
        this.namedChk.setEnabled(false);
        Group sqlGroup = new Group(composite, 4);
        sqlGroup.setText("SQL");
        sqlGroup.setLayout((Layout)new GridLayout());
        GridData sqlData = new GridData(1808);
        sqlData.horizontalSpan = 2;
        sqlGroup.setLayoutData((Object)sqlData);
        this.queryText = new Text((Composite)sqlGroup, 2826);
        GridData queryData = new GridData(1810);
        queryData.minimumHeight = 100;
        this.queryText.setLayoutData((Object)queryData);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof GlueQueryMap) {
                    GlueQueryMap queryMap = (GlueQueryMap)selection;
                    GlueQuerySelectDialog.this.idText.setText(queryMap.getName());
                    GlueQuerySelectDialog.this.descText.setText(queryMap.getDesc());
                    GlueQuerySelectDialog.this.resultTypeText.setVisible(false);
                    GlueQuerySelectDialog.this.namedChk.setVisible(false);
                    GlueQuerySelectDialog.this.queryText.setVisible(false);
                    GlueQuerySelectDialog.this.getButton(0).setEnabled(false);
                } else if (selection instanceof GlueQuery) {
                    GlueQuery query = (GlueQuery)selection;
                    GlueQuerySelectDialog.this.idText.setText(query.getId());
                    GlueQuerySelectDialog.this.descText.setText(query.getDesc());
                    GlueQuerySelectDialog.this.resultTypeText.setText(query.getResultType());
                    GlueQuerySelectDialog.this.resultTypeText.setVisible(true);
                    GlueQuerySelectDialog.this.namedChk.setSelection(query.isNamed());
                    GlueQuerySelectDialog.this.namedChk.setVisible(true);
                    GlueQuerySelectDialog.this.queryText.setText(query.getSql());
                    GlueQuerySelectDialog.this.queryText.setVisible(true);
                    Button button = GlueQuerySelectDialog.this.getButton(0);
                    if (button != null) {
                        button.setEnabled(true);
                    }
                }
            }
        });
        if (this.selectedQuery != null) {
            TreeSelection selection = new TreeSelection(new TreePath(new Object[]{this.selectedQuery}));
            this.treeViewer.setSelection((ISelection)selection, true);
        }
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.setSelectedQueryKey(this.idText.getText());
        this.bindCount = this.getBindCountInQuery(this.queryText.getText());
        this.isNamed = this.namedChk.getSelection();
        super.okPressed();
    }

    private void makeQueryTree() throws CoreException {
        try {
            List fileList = GlueEclipseProjectUtil.getFileList((String)"glue_sql", (String[])GlueEclipseProjectUtil.getProjectSourcePaths((String)this.projectName));
            if (fileList == null || fileList.isEmpty()) {
                new Exception("Glue Query File[.glue_sql] does not exist!");
            }
            GlueQueryRoot queryRoot = new GlueQueryRoot();
            GlueQueryMap queryMap = null;
            for (String filePath : fileList) {
                File queryFile = new File(filePath);
                GlueQueryMapInfo mapInfo = GlueQueryParser.getInstance().parseXml(queryFile);
                queryMap = queryRoot.newQueryMap();
                queryMap.setName(queryFile.getName().substring(0, queryFile.getName().indexOf(".")));
                queryMap.setDesc(mapInfo.getDesc());
                GlueQuery glueQuery = null;
                for (Map.Entry entry : mapInfo.getQueryMap().entrySet()) {
                    GlueQueryMapInfo.GlueQueryInfo queryInfo = (GlueQueryMapInfo.GlueQueryInfo)entry.getValue();
                    glueQuery = queryMap.newQuery();
                    glueQuery.setId(queryInfo.getId());
                    glueQuery.setDesc(queryInfo.getDesc());
                    glueQuery.setResultType(queryInfo.getResultType());
                    glueQuery.setNamed(queryInfo.isNamed());
                    glueQuery.setSql(queryInfo.getSql());
                    if (!glueQuery.getId().equals(this.getSelectedQueryKey())) continue;
                    this.selectedQuery = glueQuery;
                }
            }
            this.treeViewer.setInput((Object)queryRoot);
        }
        catch (Exception e) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "Making Query Tree Error : " + e.getMessage(), e.getCause());
            throw new CoreException((IStatus)status);
        }
    }

    private int getBindCountInQuery(String query) {
        if (query.endsWith("?")) {
            query = String.valueOf(query) + " ";
        }
        String[] splitQuery = query.split("\\?");
        return splitQuery.length - 1;
    }

    private void showErrorDialog(String title, String message, CoreException e) {
        ErrorDialog.openError((Shell)super.getShell(), (String)title, (String)message, (IStatus)e.getStatus());
    }
}

