/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.dialog;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GlueActivityPropertyDialog
extends Dialog {
    private Text nameText;
    private Text valueText;
    private final Map<String, String> activityPropertyMap = new LinkedHashMap<String, String>();

    public GlueActivityPropertyDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        super.getShell().setText("Property Editor");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        Label nameLabel = new Label(composite, 64);
        nameLabel.setLayoutData((Object)new GridData(768));
        nameLabel.setText("Name");
        nameLabel.setFont(parent.getFont());
        Label valueLabel = new Label(composite, 64);
        valueLabel.setLayoutData((Object)new GridData(768));
        valueLabel.setText("Value");
        valueLabel.setFont(parent.getFont());
        this.nameText = new Text(composite, 2816);
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 100;
        gridData.minimumHeight = 200;
        this.nameText.setLayoutData((Object)gridData);
        this.valueText = new Text(composite, 2816);
        this.valueText.setLayoutData((Object)new GridData(1808));
        StringBuffer nameBuf = new StringBuffer();
        StringBuffer valueBuf = new StringBuffer();
        for (Map.Entry<String, String> entry : this.activityPropertyMap.entrySet()) {
            nameBuf.append(String.valueOf(entry.getKey()) + Text.DELIMITER);
            valueBuf.append(String.valueOf(entry.getValue()) + Text.DELIMITER);
        }
        this.nameText.setText(nameBuf.toString());
        this.valueText.setText(valueBuf.toString());
        return composite;
    }

    protected void okPressed() {
        this.activityPropertyMap.clear();
        String[] arrName = this.nameText.getText().split(Text.DELIMITER);
        String[] arrValue = this.valueText.getText().split(Text.DELIMITER);
        int i = 0;
        while (i < arrName.length) {
            if (arrName[i] != null && i < arrValue.length && arrValue[i] != null && !"".equals(arrName[i].trim())) {
                this.activityPropertyMap.put(arrName[i].trim(), arrValue[i].trim());
            } else if (arrName[i] != null && !"".equals(arrName[i].trim())) {
                this.activityPropertyMap.put(arrName[i].trim(), "");
            }
            ++i;
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    public Map<String, String> getActivityPropertyMap() {
        return this.activityPropertyMap;
    }

    public void setActivityPropertyMap(Map<String, String> activityPropertyMap) {
        this.activityPropertyMap.clear();
        this.activityPropertyMap.putAll(activityPropertyMap);
    }
}

