/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.dialog;

import com.poscoict.glueframework.plugin.activity.designer.GlueActivityDesignerPlugin;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GlueActivityPropertyDialog;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GlueCellModifier;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GluePropertyTask;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GlueQuerySelectDialog;
import com.poscoict.glueframework.plugin.activity.designer.dialog.GlueTableLabelProvider;
import com.poscoict.glueframework.plugin.activity.designer.util.GlueClassGenerator;
import com.poscoict.glueframework.plugin.project.startup.util.GlueEclipseProjectUtil;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;

public class GlueActivityDialog
extends Dialog {
    private Text activityNameText;
    private Text descriptionText;
    private TableViewer tableViewer;
    private Button createClassButton;
    private Button openClassButton;
    private Button subServiceButton;
    private String activityName;
    private String description = "";
    private String projectName = "";
    private final Map<String, String> activityPropertyMap = new LinkedHashMap<String, String>();
    private boolean isPropertyChange = false;

    public GlueActivityDialog(Shell parentShell) {
        super(parentShell);
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Map<String, String> getActivityPropertyMap() {
        return this.activityPropertyMap;
    }

    public void setActivityPropertyMap(Map<String, String> propertyMap) {
        this.activityPropertyMap.clear();
        this.activityPropertyMap.putAll(propertyMap);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean isPropertyChange() {
        return this.isPropertyChange;
    }

    protected Control createDialogArea(Composite parent) {
        super.getShell().setText("Activity Setting");
        Composite composite = (Composite)super.createDialogArea(parent);
        Label nameLabel = new Label(composite, 64);
        nameLabel.setText("Name : ");
        nameLabel.setFont(parent.getFont());
        this.activityNameText = new Text(composite, 2052);
        this.activityNameText.setLayoutData((Object)new GridData(260));
        this.activityNameText.setText(this.activityName);
        Label propertyLabel = new Label(composite, 64);
        propertyLabel.setText("Properties : ");
        propertyLabel.setFont(parent.getFont());
        this.tableViewer = this.makePropertyTable(composite);
        this.makeButton(composite);
        Label descLabel = new Label(composite, 64);
        descLabel.setText("Description : ");
        descLabel.setFont(parent.getFont());
        this.descriptionText = new Text(composite, 2560);
        GridData gridData = new GridData(258);
        gridData.heightHint = 100;
        this.descriptionText.setLayoutData((Object)gridData);
        this.setActivityPropertyMap();
        composite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent event) {
                GlueActivityDialog.this.tableViewer.getTable().getColumn(0).pack();
                int tableWidth = ((Composite)event.getSource()).getSize().x - 26;
                int barWidth = ((GlueActivityDialog)GlueActivityDialog.this).tableViewer.getTable().getVerticalBar().getSize().x;
                int nameColumnWidth = GlueActivityDialog.this.tableViewer.getTable().getColumn(0).getWidth();
                if (GlueActivityDialog.this.tableViewer.getTable().getVerticalBar().isVisible()) {
                    GlueActivityDialog.this.tableViewer.getTable().getColumn(1).setWidth(tableWidth - barWidth - nameColumnWidth);
                } else {
                    GlueActivityDialog.this.tableViewer.getTable().getColumn(1).setWidth(tableWidth - nameColumnWidth);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return composite;
    }

    protected void okPressed() {
        this.checkPropertyChange();
        this.activityName = this.activityNameText.getText();
        if (this.isPropertyChange) {
            this.activityPropertyMap.clear();
            int i = 0;
            while (i < this.tableViewer.getTable().getItemCount()) {
                GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
                String value = task.getValue();
                if (value != null) {
                    value = value.trim();
                }
                this.activityPropertyMap.put(task.getName().trim(), value);
                ++i;
            }
            if (!this.descriptionText.getText().equals("")) {
                this.activityPropertyMap.put("description", this.descriptionText.getText());
            }
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    private TableViewer makePropertyTable(Composite composite) {
        TableViewer tableViewer = new TableViewer(composite, 68388);
        tableViewer.addDoubleClickListener((IDoubleClickListener)new PropertyDoubleClickListener());
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 120;
        table.setLayoutData((Object)gridData);
        tableViewer.setColumnProperties(new String[]{"Name", "Value"});
        TableColumn nameColumn = new TableColumn(table, 0x1000000);
        nameColumn.setText("Name");
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText("Value");
        tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        tableViewer.setCellModifier((ICellModifier)new GlueCellModifier(true));
        tableViewer.setLabelProvider((IBaseLabelProvider)new GlueTableLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return tableViewer;
    }

    private void makeButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(6, true));
        composite.setLayoutData((Object)new GridData(768));
        Button addRowButton = new Button(composite, 8);
        addRowButton.setText("Add");
        addRowButton.setLayoutData((Object)new GridData(768));
        addRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GlueActivityDialog.this.tableViewer.add((Object)new GluePropertyTask("", ""));
                GlueActivityDialog.this.tableViewer.getTable().select(GlueActivityDialog.this.tableViewer.getTable().getItemCount() - 1);
            }
        });
        Button deleteRowButton = new Button(composite, 8);
        deleteRowButton.setText("Delete");
        deleteRowButton.setLayoutData((Object)new GridData(768));
        deleteRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = 0;
                while (i < GlueActivityDialog.this.tableViewer.getTable().getItemCount()) {
                    if (GlueActivityDialog.this.tableViewer.getTable().getItem(i).getChecked()) {
                        GlueActivityDialog.this.tableViewer.getTable().remove(i);
                        i = -1;
                    }
                    ++i;
                }
            }
        });
        Button editButton = new Button(composite, 8);
        editButton.setText("Edit");
        editButton.setLayoutData((Object)new GridData(768));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GlueActivityDialog.this.openPropertyEditor();
            }
        });
        this.createClassButton = new Button(composite, 8);
        this.createClassButton.setText("Create Class");
        this.createClassButton.setLayoutData((Object)new GridData(768));
        this.createClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GlueActivityDialog.this.createButtonPressed();
            }
        });
        this.createClassButton.setEnabled(false);
        this.openClassButton = new Button(composite, 8);
        this.openClassButton.setText("Open Class");
        this.openClassButton.setLayoutData((Object)new GridData(768));
        this.openClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GlueActivityDialog.this.openButtonPressed();
            }
        });
        this.openClassButton.setEnabled(false);
        this.subServiceButton = new Button(composite, 8);
        this.subServiceButton.setText("Open Service");
        this.subServiceButton.setLayoutData((Object)new GridData(768));
        this.subServiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GlueActivityDialog.this.openServicePressed();
            }
        });
        this.subServiceButton.setEnabled(false);
    }

    private void setActivityPropertyMap() {
        if (this.tableViewer != null) {
            for (Map.Entry<String, String> entry : this.activityPropertyMap.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (!"description".equals(name)) {
                    this.tableViewer.add((Object)new GluePropertyTask(name, value));
                    if (!"class".equals(name)) continue;
                    if (GlueClassGenerator.checkReusableClass(value)) {
                        this.createClassButton.setEnabled(false);
                        this.openClassButton.setEnabled(false);
                    } else {
                        this.createClassButton.setEnabled(true);
                        this.openClassButton.setEnabled(true);
                    }
                    if ("com.poscoict.glueframework.biz.activity.GlueSubService".equals(value)) {
                        this.subServiceButton.setEnabled(true);
                        continue;
                    }
                    this.subServiceButton.setEnabled(false);
                    continue;
                }
                this.description = value;
                this.descriptionText.setText(value);
            }
            this.sortTableViewer();
        }
    }

    private void checkPropertyChange() {
        if (!this.description.equals(this.descriptionText.getText())) {
            this.isPropertyChange = true;
            return;
        }
        if (!this.activityName.equals(this.activityNameText.getText())) {
            this.isPropertyChange = true;
            return;
        }
        if (this.activityPropertyMap.size() != this.tableViewer.getTable().getItemCount() + 1) {
            this.isPropertyChange = true;
            return;
        }
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
            if (task.isPropertyChanged()) {
                this.isPropertyChange = true;
                break;
            }
            ++i;
        }
    }

    private void createButtonPressed() {
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
            String name = task.getName();
            String value = task.getValue();
            if (name != null && "class".equals(name.trim())) {
                if (value != null && !GlueClassGenerator.checkReusableClass(value.trim())) {
                    boolean successCreate = false;
                    try {
                        successCreate = GlueClassGenerator.generateClass(value.trim(), this.getProjectSourcePath());
                        GlueEclipseProjectUtil.getProject((String)this.projectName).refreshLocal(2, null);
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "Can not generate the class file, because " + e.getMessage(), (Throwable)e);
                        CoreException ce = new CoreException((IStatus)status);
                        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Glue Activity generate error", (String)"Glue Error", (IStatus)ce.getStatus());
                        GlueActivityDesignerPlugin.getDefault().getLog().log((IStatus)status);
                        return;
                    }
                    if (!successCreate) {
                        Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "Can not generate the Class, because the class is already exists.", (Throwable)new Exception(String.valueOf(value) + " Class Already Exists"));
                        CoreException ce = new CoreException((IStatus)status);
                        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Glue Activity generate error", (String)"Glue Error", (IStatus)ce.getStatus());
                        GlueActivityDesignerPlugin.getDefault().getLog().log((IStatus)status);
                        break;
                    }
                    MessageDialog.openInformation((Shell)new Shell(), (String)"Completed ", (String)("Glue Activity Class File[" + value + "] generate completed."));
                    break;
                }
                Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "Glue Activity Error", (Throwable)new Exception("Glue Reusable Activity"));
                CoreException ce = new CoreException((IStatus)status);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Can not generate the class file, because the class is Glue reusable class", (String)"Glue Error", (IStatus)ce.getStatus());
                GlueActivityDesignerPlugin.getDefault().getLog().log((IStatus)status);
                break;
            }
            ++i;
        }
    }

    private void openButtonPressed() {
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
            String name = task.getName();
            String value = task.getValue();
            if (name != null && "class".equals(name.trim())) {
                if (value != null && !GlueClassGenerator.checkReusableClass(value.trim())) {
                    try {
                        value = value.trim();
                        String packageName = value.substring(0, value.lastIndexOf("."));
                        String className = value.substring(value.lastIndexOf(".") + 1);
                        String fullPath = String.valueOf(this.getProjectSourcePath()) + File.separator + packageName.replace('.', File.separatorChar);
                        String fileName = String.valueOf(fullPath) + File.separator + className + ".java";
                        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
                        IJavaElement javaFile = JavaCore.create((IFile)ifile);
                        JavaUI.openInEditor((IJavaElement)javaFile);
                        IWorkbenchPage page = GlueActivityDesignerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.saveAllEditors(true);
                        this.okPressed();
                        break;
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "Can not open the Class, because " + e.getMessage(), (Throwable)e);
                        CoreException ce = new CoreException((IStatus)status);
                        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Glue Activity Opent Class Error", (String)"Glue Error", (IStatus)ce.getStatus());
                        GlueActivityDesignerPlugin.getDefault().getLog().log((IStatus)status);
                        return;
                    }
                }
                Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "Glue Activity Error", (Throwable)new Exception("Glue Reusable Activity"));
                CoreException ce = new CoreException((IStatus)status);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Can not open the class file, because the class is reusable class or dose not exist!", (String)"Glue Error", (IStatus)ce.getStatus());
                GlueActivityDesignerPlugin.getDefault().getLog().log((IStatus)status);
                break;
            }
            ++i;
        }
    }

    private void openServicePressed() {
        try {
            int i = 0;
            while (i < this.tableViewer.getTable().getItemCount()) {
                GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
                String name = task.getName();
                String value = task.getValue();
                if (name != null && "service-name".equals(name.trim())) {
                    if (value != null) {
                        value = value.trim();
                    }
                    String serviceName = null;
                    if (value.indexOf("-service") != -1) {
                        serviceName = value.substring(0, value.indexOf("-service"));
                    }
                    if (serviceName == null) {
                        throw new Exception("Set the ServiceName!");
                    }
                    List diagramFileList = GlueEclipseProjectUtil.getFileList((String)"glue_uml_ad", (String[])new String[]{GlueEclipseProjectUtil.getProject((String)this.projectName).getLocation().toOSString()});
                    IFile ifile = null;
                    for (String diagramFile : diagramFileList) {
                        String fileName = diagramFile.substring(diagramFile.lastIndexOf(File.separator) + 1);
                        if (!fileName.equals(String.valueOf(serviceName) + ".glue_uml_ad")) continue;
                        ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(diagramFile));
                        break;
                    }
                    IWorkbenchWindow dwindow = GlueActivityDesignerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = dwindow.getActivePage();
                    if (page == null || ifile == null || !ifile.exists()) {
                        throw new Exception("There is no Sub Service File![" + ifile + "]");
                    }
                    IDE.openEditor((IWorkbenchPage)page, ifile, (boolean)true);
                    page.saveAllEditors(true);
                    this.okPressed();
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "Can not open the SubService Diagram, because " + e.getMessage(), (Throwable)e);
            CoreException ce = new CoreException((IStatus)status);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Glue Activity Open SubService Diagram Error", (String)"Glue Error", (IStatus)ce.getStatus());
            GlueActivityDesignerPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private void openPropertyEditor() {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>(5);
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
            String value = task.getValue();
            if (value != null) {
                value = value.trim();
            }
            propertyMap.put(task.getName().trim(), value);
            ++i;
        }
        Shell shell = new Shell();
        GlueActivityPropertyDialog propertyDialog = new GlueActivityPropertyDialog(shell);
        propertyDialog.setActivityPropertyMap(propertyMap);
        propertyDialog.open();
        if (propertyDialog.getReturnCode() == 0) {
            ArrayList<Object> elements = new ArrayList<Object>();
            int i2 = 0;
            while (i2 < this.tableViewer.getTable().getItemCount()) {
                elements.add(this.tableViewer.getElementAt(i2));
                ++i2;
            }
            this.tableViewer.remove(elements.toArray());
            for (Map.Entry<String, String> entry : propertyDialog.getActivityPropertyMap().entrySet()) {
                this.tableViewer.add((Object)new GluePropertyTask(entry.getKey(), entry.getValue()));
            }
            this.sortTableViewer();
        }
        this.isPropertyChange = true;
    }

    private String getProjectSourcePath() throws CoreException {
        return (String)GlueEclipseProjectUtil.getProjectSourcePathList((String)this.projectName).get(0);
    }

    private void sortTableViewer() {
        GluePropertyTask classTask = null;
        ArrayList<GluePropertyTask> propertyTaskList = new ArrayList<GluePropertyTask>();
        ArrayList<GluePropertyTask> paramTaskList = new ArrayList<GluePropertyTask>();
        GluePropertyTask resultTask = null;
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            GluePropertyTask task = (GluePropertyTask)this.tableViewer.getElementAt(i);
            String taskName = task.getName();
            if ("class".equals(taskName)) {
                classTask = task;
            } else if ("result-key".equals(taskName)) {
                resultTask = task;
            } else if (taskName.startsWith("param")) {
                paramTaskList.add(task);
            } else {
                propertyTaskList.add(task);
            }
            ++i;
        }
        Collections.sort(paramTaskList, new Comparator<GluePropertyTask>(){

            @Override
            public int compare(GluePropertyTask task1, GluePropertyTask task2) {
                String param1 = task1.getName().substring(5);
                String param2 = task2.getName().substring(5);
                if (param1.startsWith("-")) {
                    param1 = "-1";
                }
                if (param2.startsWith("-")) {
                    param2 = "-1";
                }
                try {
                    return new Integer(param1).compareTo(new Integer(param2));
                }
                catch (Exception exception) {
                    return Collator.getInstance().compare(task1.getName(), task2.getName());
                }
            }
        });
        Collections.sort(propertyTaskList, new Comparator<GluePropertyTask>(){

            @Override
            public int compare(GluePropertyTask task1, GluePropertyTask task2) {
                return task1.getName().compareTo(task2.getName());
            }
        });
        this.tableViewer.refresh();
        this.tableViewer.add((Object)classTask);
        for (GluePropertyTask propertyTask : propertyTaskList) {
            this.tableViewer.add((Object)propertyTask);
        }
        for (GluePropertyTask propertyTask : paramTaskList) {
            this.tableViewer.add((Object)propertyTask);
        }
        if (resultTask != null) {
            this.tableViewer.add((Object)resultTask);
        }
    }

    private class PropertyDoubleClickListener
    implements IDoubleClickListener {
        private PropertyDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            GluePropertyTask task = (GluePropertyTask)selection.getFirstElement();
            String taskName = task.getName();
            if (taskName != null) {
                if (taskName.indexOf("sql-key") != -1 || taskName.indexOf("-sql") != -1) {
                    this.selectSQLKey(task);
                } else if (taskName.indexOf("_sql") != -1) {
                    this.selectSQLKeyForSave(task);
                }
            }
        }

        private void selectSQLKey(GluePropertyTask task) {
            Shell shell = new Shell();
            GlueQuerySelectDialog sqlKeySelectDialog = new GlueQuerySelectDialog(shell);
            sqlKeySelectDialog.setProjectName(GlueActivityDialog.this.projectName);
            sqlKeySelectDialog.setSelectedQueryKey(task.getValue());
            sqlKeySelectDialog.open();
            if (sqlKeySelectDialog.getReturnCode() == 0) {
                if (sqlKeySelectDialog.getSelectedQueryKey().equals(task.getValue())) {
                    return;
                }
                task.setValue(sqlKeySelectDialog.getSelectedQueryKey());
                this.deleteParamsInTableViewer();
                this.addParamsInTableViewer(sqlKeySelectDialog.getBindCount(), sqlKeySelectDialog.isNamed());
                GlueActivityDialog.this.tableViewer.refresh((Object)task);
            }
            GlueActivityDialog.this.sortTableViewer();
        }

        private void selectSQLKeyForSave(GluePropertyTask task) {
            Shell shell = new Shell();
            GlueQuerySelectDialog sqlKeySelectDialog = new GlueQuerySelectDialog(shell);
            sqlKeySelectDialog.setProjectName(GlueActivityDialog.this.projectName);
            sqlKeySelectDialog.setSelectedQueryKey(task.getValue());
            sqlKeySelectDialog.open();
            if (sqlKeySelectDialog.getReturnCode() == 0) {
                if (sqlKeySelectDialog.getSelectedQueryKey().equals(task.getValue())) {
                    return;
                }
                task.setValue(sqlKeySelectDialog.getSelectedQueryKey());
                GlueActivityDialog.this.tableViewer.refresh((Object)task);
            }
            GlueActivityDialog.this.sortTableViewer();
        }

        private void addParamsInTableViewer(int bindCount, boolean isNamed) {
            if (isNamed) {
                GlueActivityDialog.this.tableViewer.add((Object)new GluePropertyTask("param-bindings", "DEPTNO=DeptnoP"));
            } else {
                GlueActivityDialog.this.tableViewer.add((Object)new GluePropertyTask("param-count", Integer.toString(bindCount)));
                int i = 0;
                while (i < bindCount) {
                    GlueActivityDialog.this.tableViewer.add((Object)new GluePropertyTask("param" + i, ""));
                    ++i;
                }
            }
        }

        private void deleteParamsInTableViewer() {
            int i = 0;
            while (i < GlueActivityDialog.this.tableViewer.getTable().getItemCount()) {
                GluePropertyTask task = (GluePropertyTask)GlueActivityDialog.this.tableViewer.getElementAt(i);
                if ((task.getName() != null || "".equals(task.getName())) && task.getName().startsWith("param")) {
                    GlueActivityDialog.this.tableViewer.getTable().remove(i);
                    i = -1;
                }
                ++i;
            }
        }
    }
}

