/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.actions;

import com.poscoict.glueframework.plugin.activity.designer.GlueDiagramEditor;
import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueDiagramEditPart;
import com.poscoict.glueframework.plugin.activity.designer.model.commands.GlueGenerateServiceCommand;
import com.poscoict.glueframework.plugin.project.startup.util.GlueEclipseProjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;

public class GlueGenerateServiceXmlAction
extends SelectionAction {
    private static String serviceXmlPath;
    private final String projectName;
    private final String fileName;

    public GlueGenerateServiceXmlAction(IWorkbenchPart part) {
        super(part);
        IFile file = ((FileEditorInput)((GlueDiagramEditor)part).getEditorInput()).getFile();
        this.projectName = file.getProject().getName();
        this.fileName = file.getName().replaceFirst("." + file.getFileExtension(), "");
    }

    public GlueGenerateServiceXmlAction(IWorkbenchPart part, int style) {
        super(part, style);
        IFile file = ((FileEditorInput)((GlueDiagramEditor)part).getEditorInput()).getFile();
        this.projectName = file.getProject().getName();
        this.fileName = file.getName().replaceFirst(file.getFileExtension(), "");
    }

    protected void init() {
        super.init();
        super.setText("Generate Service");
        super.setId("Generate Service");
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() > 0 && this.getSelectedObjects().get(0) instanceof GlueDiagramEditPart;
    }

    public void run() {
        DirectoryDialog dialog = new DirectoryDialog(new Shell());
        dialog.setFilterPath(this.getOldServiceXmlPath());
        String selectedDirectory = dialog.open();
        if (selectedDirectory == null || "".equals(selectedDirectory)) {
            return;
        }
        serviceXmlPath = selectedDirectory;
        GlueGenerateServiceCommand generateServiceCommand = this.createGenerateServiceCommand();
        generateServiceCommand.setSelectedDirectory(selectedDirectory);
        generateServiceCommand.setServiceName(this.getServiceName());
        generateServiceCommand.setProjectName(this.projectName);
        super.execute((Command)generateServiceCommand);
    }

    private GlueGenerateServiceCommand createGenerateServiceCommand() {
        GlueDiagramEditPart editPart = (GlueDiagramEditPart)this.getSelectedObjects().get(0);
        DirectEditRequest request = new DirectEditRequest((Object)"direct edit");
        request.getExtendedData().put("CommandType", super.getId());
        return (GlueGenerateServiceCommand)editPart.getCommand((Request)request);
    }

    private String getOldServiceXmlPath() {
        if (serviceXmlPath == null || "".equals(serviceXmlPath)) {
            IProject project = GlueEclipseProjectUtil.getProject((String)this.projectName);
            serviceXmlPath = project.getLocation().toOSString();
        }
        return serviceXmlPath;
    }

    private String getServiceName() {
        if (!this.fileName.endsWith("-service")) {
            return String.valueOf(this.fileName) + "-service";
        }
        return this.fileName;
    }
}

