/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer.actions;

import com.poscoict.glueframework.plugin.activity.designer.actions.GlueActivityCreationFactory;
import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueActivityEditPart;
import com.poscoict.glueframework.plugin.activity.model.GlueActivity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class GlueCopyActivityAction
extends SelectionAction {
    public GlueCopyActivityAction(IWorkbenchPart part) {
        super(part);
    }

    public GlueCopyActivityAction(IWorkbenchPart part, int style) {
        super(part, style);
    }

    protected void init() {
        super.init();
        super.setId(ActionFactory.COPY.getId());
        super.setText("Copy Activity");
    }

    protected boolean calculateEnabled() {
        for (Object object : super.getSelectedObjects()) {
            if (!(object instanceof GlueActivityEditPart)) continue;
            return true;
        }
        return false;
    }

    public void run() {
        ArrayList<Map<String, Object>> specList = new ArrayList<Map<String, Object>>();
        for (Object object : super.getSelectedObjects()) {
            if (!(object instanceof GlueActivityEditPart)) continue;
            GlueActivityEditPart editPart = (GlueActivityEditPart)object;
            specList.add(this.createActivitySpec(editPart.getActivity()));
        }
        if (specList.isEmpty()) {
            return;
        }
        Clipboard.getDefault().setContents(specList);
    }

    private Map<String, Object> createActivitySpec(GlueActivity selectedActivity) {
        LinkedHashMap<String, Object> specMap = new LinkedHashMap<String, Object>(5);
        Point point = selectedActivity.getLocation();
        specMap.put(GlueActivityCreationFactory.ACTIVITY_SPEC_NAME, selectedActivity.getName());
        specMap.put(GlueActivityCreationFactory.ACTIVITY_SPEC_SIZE, selectedActivity.getSize());
        specMap.put(GlueActivityCreationFactory.ACTIVITY_SPEC_LOCATION, new Point(point.x + 10, point.y + 10));
        specMap.put(GlueActivityCreationFactory.ACTIVITY_SPEC_PROPERTY, selectedActivity.getPropertyMap());
        return specMap;
    }
}

