/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer;

import com.poscoict.glueframework.plugin.activity.designer.GlueActivityDesignerPlugin;
import com.poscoict.glueframework.plugin.activity.designer.GlueContextMenuProvider;
import com.poscoict.glueframework.plugin.activity.designer.actions.GlueCopyActivityAction;
import com.poscoict.glueframework.plugin.activity.designer.actions.GlueGenerateDocumentAction;
import com.poscoict.glueframework.plugin.activity.designer.actions.GlueGenerateServiceXmlAction;
import com.poscoict.glueframework.plugin.activity.designer.actions.GluePasteActivityAction;
import com.poscoict.glueframework.plugin.activity.designer.actions.GlueTransactionEditAction;
import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueEditPartFactory;
import com.poscoict.glueframework.plugin.activity.designer.editpart.GlueTreePartFactory;
import com.poscoict.glueframework.plugin.activity.designer.model.GlueModelManager;
import com.poscoict.glueframework.plugin.activity.designer.model.commands.GlueGenerateDocumentCommand;
import com.poscoict.glueframework.plugin.activity.designer.model.commands.GlueGenerateServiceCommand;
import com.poscoict.glueframework.plugin.activity.designer.rulers.GlueRulerProvider;
import com.poscoict.glueframework.plugin.activity.model.GlueDiagram;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.MatchHeightAction;
import org.eclipse.gef.ui.actions.MatchWidthAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ToggleRulerVisibilityAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class GlueDiagramEditor
extends GraphicalEditorWithFlyoutPalette {
    public static final String GLUE_PROJECT_NAME = "Glue Project Name";
    private static final String PALETTE_DOCK_LOCATION = "Dock location";
    private static final String PALETTE_SIZE = "Palette Size";
    private static final String PALETTE_STATE = "Palette state";
    private static final int DEFAULT_PALETTE_SIZE = 130;
    private final IPartListener partListener = new GluePartListener();
    private final IResourceChangeListener resourceListener = new GlueDiagramResourceTracker();
    private GlueModelManager modelManager;
    private GlueOutlinePage outlinePage;
    private GlueDiagram diagram;
    private boolean editorSaving = false;
    private boolean savePreviouslyNeeded = false;
    private KeyHandler keyHandler;
    private PaletteRoot root;
    private RulerComposite rulerComp;

    static {
        GlueActivityDesignerPlugin.getDefault().getPreferenceStore().setDefault(PALETTE_SIZE, 130);
    }

    public GlueDiagramEditor() {
        super.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        super.getGraphicalViewer().setContents((Object)this.diagram);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = GlueActivityDesignerPlugin.createPalette();
        }
        return this.root;
    }

    protected GraphicalEditorWithFlyoutPalette.CustomPalettePage createPalettePage() {
        return new GraphicalEditorWithFlyoutPalette.CustomPalettePage(this, super.getPaletteViewerProvider()){

            public void init(IPageSite pageSite) {
                super.init(pageSite);
                IAction copy = GlueDiagramEditor.this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
                pageSite.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
            }
        };
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new GlueOutlinePage((EditPartViewer)new TreeViewer());
            }
            return this.outlinePage;
        }
        if (type == ZoomManager.class) {
            return super.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    protected Control getGraphicalControl() {
        return this.rulerComp;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return GlueActivityDesignerPlugin.getDefault().getPreferenceStore().getInt(GlueDiagramEditor.PALETTE_DOCK_LOCATION);
            }

            public void setDockLocation(int location) {
                GlueActivityDesignerPlugin.getDefault().getPreferenceStore().setValue(GlueDiagramEditor.PALETTE_DOCK_LOCATION, location);
            }

            public int getPaletteState() {
                return GlueActivityDesignerPlugin.getDefault().getPreferenceStore().getInt(GlueDiagramEditor.PALETTE_STATE);
            }

            public void setPaletteState(int state) {
                GlueActivityDesignerPlugin.getDefault().getPreferenceStore().setValue(GlueDiagramEditor.PALETTE_STATE, state);
            }

            public int getPaletteWidth() {
                return GlueActivityDesignerPlugin.getDefault().getPreferenceStore().getInt(GlueDiagramEditor.PALETTE_SIZE);
            }

            public void setPaletteWidth(int width) {
                GlueActivityDesignerPlugin.getDefault().getPreferenceStore().setValue(GlueDiagramEditor.PALETTE_SIZE, width);
            }
        };
    }

    public void commandStackChanged(EventObject event) {
        Object[] commands = ((CommandStack)event.getSource()).getCommands();
        Object lastCommand = commands[commands.length - 1];
        if (lastCommand instanceof GlueGenerateServiceCommand || lastCommand instanceof GlueGenerateDocumentCommand) {
            return;
        }
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded) {
                this.savePreviouslyNeeded = true;
                super.firePropertyChange(257);
            }
        } else {
            this.savePreviouslyNeeded = false;
            super.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)super.getGraphicalViewer();
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        super.getActionRegistry().registerAction((IAction)zoomIn);
        super.getActionRegistry().registerAction((IAction)zoomOut);
        IHandlerService service = (IHandlerService)super.getSite().getService(IHandlerService.class);
        service.activateHandler(zoomIn.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomIn));
        service.activateHandler(zoomOut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomOut));
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory((EditPartFactory)new GlueEditPartFactory());
        GlueContextMenuProvider provider = new GlueContextMenuProvider((EditPartViewer)viewer, super.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        super.getSite().registerContextMenu("com.poscoict.glueframework.plugin.activity.contextmenu", (MenuManager)provider, (ISelectionProvider)viewer);
        viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler()));
        this.loadProperties();
        ToggleRulerVisibilityAction showRulers = new ToggleRulerVisibilityAction(super.getGraphicalViewer());
        super.getActionRegistry().registerAction((IAction)showRulers);
        ToggleSnapToGeometryAction snapAction = new ToggleSnapToGeometryAction(super.getGraphicalViewer());
        super.getActionRegistry().registerAction((IAction)snapAction);
        ToggleGridAction showGrid = new ToggleGridAction(super.getGraphicalViewer());
        super.getActionRegistry().registerAction((IAction)showGrid);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                GlueDiagramEditor.this.handleActivationChanged(event);
            }
        };
        super.getGraphicalControl().addListener(26, listener);
        super.getGraphicalControl().addListener(27, listener);
    }

    protected void createActions() {
        super.createActions();
        this.addAction((IAction)new GlueCopyActivityAction((IWorkbenchPart)this));
        this.addAction((IAction)new GluePasteActivityAction((IWorkbenchPart)this));
        this.addAction((IAction)new DirectEditAction((IEditorPart)this));
        this.addAction((IAction)new MatchWidthAction((IWorkbenchPart)this));
        this.addAction((IAction)new MatchHeightAction((IWorkbenchPart)this));
        this.addAction((IAction)new AlignmentAction((IWorkbenchPart)this, 1));
        this.addAction((IAction)new AlignmentAction((IWorkbenchPart)this, 4));
        this.addAction((IAction)new AlignmentAction((IWorkbenchPart)this, 8));
        this.addAction((IAction)new AlignmentAction((IWorkbenchPart)this, 32));
        this.addAction((IAction)new AlignmentAction((IWorkbenchPart)this, 2));
        this.addAction((IAction)new AlignmentAction((IWorkbenchPart)this, 16));
        this.addAction((IAction)new GlueGenerateServiceXmlAction((IWorkbenchPart)this));
        this.addAction((IAction)new GlueGenerateDocumentAction((IWorkbenchPart)this));
        this.addAction((IAction)new GlueTransactionEditAction((IWorkbenchPart)this));
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new RulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)super.getGraphicalViewer());
    }

    public void doSaveAs() {
        this.performSaveAs();
    }

    public void dispose() {
        super.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        ((FileEditorInput)super.getEditorInput()).getFile().getWorkspace().removeResourceChangeListener(this.resourceListener);
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            try {
                this.editorSaving = true;
                this.saveProperties();
                IFile file = ((IFileEditorInput)super.getEditorInput()).getFile();
                if (file.exists() || MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Create File", (String)("The file '" + file.getName() + "' doesn't exist. Click OK to create it."))) {
                    this.save(file, monitor);
                    super.getCommandStack().markSaveLocation();
                }
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error During Save", (String)"The current glue diagram model could not be saved.", (IStatus)e.getStatus());
                this.editorSaving = false;
            }
        }
        finally {
            this.editorSaving = false;
        }
    }

    public void setInput(IEditorInput input) {
        this.superSetInput(input);
        IFile file = ((IFileEditorInput)input).getFile();
        this.modelManager = new GlueModelManager();
        if (file.exists()) {
            try {
                this.modelManager.load(file.getFullPath());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (file.getContents(true).available() != 0) {
                        Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "can't read glue_uml_ad file : " + file.getRawLocation().toOSString(), (Throwable)e);
                        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Parsing Error", (String)"error parsing glue_uml_ad file", (IStatus)status);
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                try {
                    this.modelManager.createGlueDiagram(file.getFullPath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.diagram = this.modelManager.getGlueDiagram(file.getFullPath());
        }
        if (!this.editorSaving) {
            if (super.getGraphicalViewer() != null) {
                super.getGraphicalViewer().setContents((Object)this.diagram);
                this.loadProperties();
            }
            if (this.outlinePage != null) {
                this.outlinePage.setContents(this.diagram);
            }
        }
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        super.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    private KeyHandler getCommonKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.keyHandler;
    }

    private void loadProperties() {
        super.getGraphicalViewer().setProperty(GLUE_PROJECT_NAME, (Object)((IFileEditorInput)this.getEditorInput()).getFile().getProject().getName());
        super.getGraphicalViewer().setProperty("vertical ruler", (Object)new GlueRulerProvider(this.diagram.getRuler(8)));
        super.getGraphicalViewer().setProperty("horizontal ruler", (Object)new GlueRulerProvider(this.diagram.getRuler(1)));
        super.getGraphicalViewer().setProperty("ruler$visibility", (Object)new Boolean(this.diagram.isRulerVisibility()));
        super.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)new Boolean(this.diagram.isSnapToGeometryEnabled()));
        super.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)new Boolean(this.diagram.isGridEnabled()));
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (manager != null) {
            manager.setZoom(this.diagram.getZoom());
        }
    }

    private void handleActivationChanged(Event event) {
        if (event.type == 27) {
            IAction copy = super.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
            if (super.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()) != copy) {
                super.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
                super.getEditorSite().getActionBars().updateActionBars();
            }
        }
    }

    private void addAction(IAction action) {
        super.getActionRegistry().registerAction(action);
        super.getSelectionActions().add(action.getId());
    }

    private boolean performSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(super.getSite().getWorkbenchWindow().getShell());
        dialog.setOriginalFile(((IFileEditorInput)super.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return false;
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (!file.exists()) {
            WorkspaceModifyOperation modifyOper = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    GlueDiagramEditor.this.saveProperties();
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(baos);
                        oos.writeObject(GlueDiagramEditor.this.diagram);
                        oos.close();
                        file.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, monitor);
                        baos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)modifyOper);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.superSetInput((IEditorInput)new FileEditorInput(file));
        super.getCommandStack().markSaveLocation();
        return true;
    }

    private void saveProperties() {
        this.diagram.setRulerVisibility(((Boolean)this.getGraphicalViewer().getProperty("ruler$visibility")).booleanValue());
        this.diagram.setGridEnabled(((Boolean)this.getGraphicalViewer().getProperty("SnapToGrid.isEnabled")).booleanValue());
        this.diagram.setSnapToGeometry(((Boolean)this.getGraphicalViewer().getProperty("SnapToGeometry.isEnabled")).booleanValue());
        ZoomManager manager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (manager != null) {
            this.diagram.setZoom(manager.getZoom());
        }
    }

    private void superSetInput(IEditorInput input) {
        IFile file;
        if (super.getEditorInput() != null) {
            file = ((FileEditorInput)super.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        super.setInput(input);
        if (super.getEditorInput() != null) {
            file = ((FileEditorInput)super.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener(this.resourceListener);
            super.setPartName(file.getName());
        }
    }

    private FigureCanvas getEditor() {
        return (FigureCanvas)super.getGraphicalViewer().getControl();
    }

    private void closeEditor(boolean save) {
        super.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    private void save(IFile file, IProgressMonitor progressMonitor) throws CoreException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.beginTask("Saving " + file, 2);
        try {
            this.modelManager.save(file.getFullPath());
            progressMonitor.worked(1);
            file.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            progressMonitor.done();
        }
        catch (FileNotFoundException e) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "Error writing file.", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (IOException e) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.activity.designer", 0, "Error writing file.", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private class GlueDiagramResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private GlueDiagramResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {}
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((FileEditorInput)GlueDiagramEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = GlueDiagramEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!GlueDiagramEditor.this.isDirty()) {
                                GlueDiagramEditor.this.closeEditor(false);
                            }
                        }
                    });
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GlueDiagramEditor.this.superSetInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            } else if (delta.getKind() == 4 && !GlueDiagramEditor.this.editorSaving) {
                final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getFullPath());
                Display display = GlueDiagramEditor.this.getSite().getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GlueDiagramEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                        GlueDiagramEditor.this.getCommandStack().flush();
                    }
                });
            }
            return false;
        }
    }

    private class GlueOutlinePage
    extends ContentOutlinePage
    implements IAdaptable {
        private static final int ID_OUTLINE = 0;
        private static final int ID_OVERVIEW = 1;
        private PageBook pageBook;
        private Control outline;
        private Canvas overview;
        private IAction showOutlineAction;
        private IAction showOverviewAction;
        private Thumbnail thumbnail;
        private DisposeListener disposeListener;

        public GlueOutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        public void createControl(Composite parent) {
            this.pageBook = new PageBook(parent, 0);
            this.outline = this.getViewer().createControl((Composite)this.pageBook);
            this.overview = new Canvas((Composite)this.pageBook, 0);
            this.pageBook.showPage(this.outline);
            this.configureOutlineViewer();
            this.setContents(GlueDiagramEditor.this.diagram);
        }

        private void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)GlueDiagramEditor.this.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new GlueTreePartFactory());
            IToolBarManager toolbarManager = this.getSite().getActionBars().getToolBarManager();
            this.showOutlineAction = new Action(){

                public void run() {
                    GlueOutlinePage.this.showPage(0);
                }
            };
            this.showOutlineAction.setImageDescriptor(ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/outline.gif"));
            toolbarManager.add(this.showOutlineAction);
            this.showOverviewAction = new Action(){

                public void run() {
                    GlueOutlinePage.this.showPage(1);
                }
            };
            this.showOverviewAction.setImageDescriptor(ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/overview.gif"));
            toolbarManager.add(this.showOverviewAction);
            this.showPage(0);
            GlueDiagramEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        public void dispose() {
            GlueDiagramEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            if (this.disposeListener != null && GlueDiagramEditor.this.getEditor() != null && !GlueDiagramEditor.this.getEditor().isDisposed()) {
                GlueDiagramEditor.this.getEditor().removeDisposeListener(this.disposeListener);
            }
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            super.dispose();
            GlueDiagramEditor.this.outlinePage = null;
        }

        public Object getAdapter(Class type) {
            if (type == ZoomManager.class) {
                return GlueDiagramEditor.this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
            }
            return null;
        }

        public Control getControl() {
            return this.pageBook;
        }

        private void setContents(Object contents) {
            this.getViewer().setContents(contents);
        }

        private void showPage(int id) {
            switch (id) {
                case 0: {
                    this.showOutlineAction.setChecked(true);
                    this.showOverviewAction.setChecked(false);
                    this.pageBook.showPage(this.outline);
                    if (this.thumbnail == null) break;
                    this.thumbnail.setVisible(false);
                    break;
                }
                case 1: {
                    this.showOutlineAction.setChecked(false);
                    this.showOverviewAction.setChecked(true);
                    this.pageBook.showPage((Control)this.overview);
                    if (this.thumbnail == null) {
                        this.makeThumnail();
                    }
                    this.thumbnail.setVisible(true);
                }
            }
        }

        private void makeThumnail() {
            LightweightSystem system = new LightweightSystem(this.overview);
            RootEditPart rep = GlueDiagramEditor.this.getGraphicalViewer().getRootEditPart();
            if (rep instanceof ScalableFreeformRootEditPart) {
                ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
                this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
                this.thumbnail.setBorder((Border)new MarginBorder(3));
                this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
                system.setContents((IFigure)this.thumbnail);
                this.disposeListener = new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (GlueOutlinePage.this.thumbnail != null) {
                            GlueOutlinePage.this.thumbnail.deactivate();
                            GlueOutlinePage.this.thumbnail = null;
                        }
                    }
                };
                GlueDiagramEditor.this.getEditor().addDisposeListener(this.disposeListener);
            }
        }
    }

    private class GluePartListener
    implements IPartListener {
        private GluePartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part != GlueDiagramEditor.this) {
                return;
            }
            if (!((FileEditorInput)GlueDiagramEditor.this.getEditorInput()).getFile().exists()) {
                Shell shell = GlueDiagramEditor.this.getSite().getShell();
                String title = "File Deleted";
                String message = "The file has been deleted from the file system.  Do you want to save your changes or close the editor without saving?";
                String[] buttons = new String[]{"Save", "Close"};
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttons, 0);
                if (dialog.open() == 0) {
                    if (!GlueDiagramEditor.this.performSaveAs()) {
                        this.partActivated(part);
                    }
                } else {
                    GlueDiagramEditor.this.closeEditor(false);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

