/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer;

import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;

public class GlueContextMenuProvider
extends ContextMenuProvider {
    private final ActionRegistry actionRegistry;

    public GlueContextMenuProvider(EditPartViewer viewer, ActionRegistry actionRegistry) {
        super(viewer);
        this.actionRegistry = actionRegistry;
    }

    public void buildContextMenu(IMenuManager manager) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)manager);
        this.addAction(manager, ActionFactory.UNDO.getId(), "org.eclipse.gef.group.undo", false);
        this.addAction(manager, ActionFactory.REDO.getId(), "org.eclipse.gef.group.undo", false);
        this.addAction(manager, ActionFactory.COPY.getId(), "org.eclipse.gef.group.copy", true);
        this.addAction(manager, ActionFactory.PASTE.getId(), "org.eclipse.gef.group.copy", true);
        this.addAction(manager, "org.eclipse.gef.direct_edit", "org.eclipse.gef.group.edit", false);
        this.addAction(manager, ActionFactory.DELETE.getId(), "org.eclipse.gef.group.edit", true);
        MenuManager submenu = new MenuManager("&Align");
        this.addAction((IMenuManager)submenu, "org.eclipse.gef.match.width", null, true);
        this.addAction((IMenuManager)submenu, "org.eclipse.gef.match.height", null, true);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "org.eclipse.gef.align_left", null, true);
        this.addAction((IMenuManager)submenu, "org.eclipse.gef.align_center", null, true);
        this.addAction((IMenuManager)submenu, "org.eclipse.gef.align_right", null, true);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "org.eclipse.gef.align_top", null, true);
        this.addAction((IMenuManager)submenu, "org.eclipse.gef.align_middle", null, true);
        this.addAction((IMenuManager)submenu, "org.eclipse.gef.align_bottom", null, true);
        if (!submenu.isEmpty()) {
            manager.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)submenu);
        }
        this.addAction(manager, ActionFactory.SAVE.getId(), "org.eclipse.gef.group.save", false);
        this.addAction(manager, "Transaction Setting", "org.eclipse.gef.group.save", false);
        this.addAction(manager, "Generate Service", "org.eclipse.gef.group.save", false);
        this.addAction(manager, "Generate Document", "org.eclipse.gef.group.save", false);
    }

    private void addAction(IMenuManager manager, String actionID, String groupName, boolean checkEnable) {
        IAction action = this.actionRegistry.getAction((Object)actionID);
        if (!checkEnable || action.isEnabled()) {
            if (groupName != null) {
                manager.appendToGroup(groupName, action);
            } else {
                manager.add(action);
            }
        }
    }
}

